/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send.email;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.SenderIdentity;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.send.HylaTFLItem;
import yajhfc.send.SendController;
import yajhfc.send.email.MailException;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class YajMailer {
    protected static Class<? extends YajMailer> IMPLEMENTATION = null;
    protected SenderIdentity fromIdentity = null;
    protected String subject = null;
    protected String body = null;
    protected Collection<String> toAddresses = null;
    protected Collection<String> ccAddresses = null;
    protected Collection<String> bccAddresses = null;
    protected List<Attachment> attachments = new ArrayList<Attachment>();
    protected MessageFormat attachmentNameFormat = null;

    public static boolean isAvailable() {
        return IMPLEMENTATION != null;
    }

    public static YajMailer getInstance() {
        try {
            return IMPLEMENTATION.newInstance();
        }
        catch (Exception exception) {
            Logger.getLogger(YajMailer.class.getName()).log(Level.SEVERE, "Invalid implementation: " + IMPLEMENTATION, exception);
            IMPLEMENTATION = null;
            return null;
        }
    }

    public MessageFormat getAttachmentNameFormat() {
        if (this.attachmentNameFormat == null) {
            this.attachmentNameFormat = new MessageFormat("doc_{0,date,yyyy-MM-dd_HH-mm-ss}.pdf");
        }
        return this.attachmentNameFormat;
    }

    public void setAttachmentNameFormat(MessageFormat messageFormat) {
        this.attachmentNameFormat = messageFormat;
    }

    public boolean mailToRecipients(SendController sendController, Collection<String> collection) throws MailException {
        this.initializeFromSendController(sendController);
        this.setToAddresses(collection);
        return this.sendMail();
    }

    public void initializeFromSendController(SendController sendController) throws MailException {
        this.setSubject(sendController.getSubject());
        this.setBody(sendController.getComment());
        this.setFromIdentity(sendController.getIdentity());
        this.addPDFAttachmentForTFLItems(sendController.getFiles(), sendController.getPaperSize());
    }

    public void addPDFAttachmentForTFLItems(List<HylaTFLItem> list, PaperSize paperSize) throws MailException {
        MessageFormat messageFormat = this.getAttachmentNameFormat();
        Date date = new Date();
        try {
            File file = File.createTempFile("attachment", ".pdf");
            ShutdownManager.deleteOnExit(file);
            MultiFileConverter.convertTFLItemsToSingleFile(list, file, MultiFileConvFormat.PDF, paperSize);
            this.addAttachment(file, messageFormat.format(new Object[]{date}));
        }
        catch (Exception exception) {
            throw new MailException("Error creating PDF for fax", exception);
        }
    }

    public void addAttachment(File file) {
        this.addAttachment(file, null);
    }

    public void addAttachment(File file, String string) {
        this.attachments.add(new Attachment(string, file, null));
    }

    public void addAttachment(String string, String string2) {
        this.attachments.add(new Attachment(string2, null, string));
    }

    public SenderIdentity getFromIdentity() {
        return this.fromIdentity;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public Collection<String> getToAddresses() {
        return this.toAddresses;
    }

    public Collection<String> getCcAddresses() {
        return this.ccAddresses;
    }

    public Collection<String> getBccAddresses() {
        return this.bccAddresses;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setFromIdentity(SenderIdentity senderIdentity) {
        this.fromIdentity = senderIdentity;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public void setToAddresses(Collection<String> collection) {
        this.toAddresses = collection;
    }

    public void setToAddresses(String ... stringArray) {
        this.toAddresses = Arrays.asList(stringArray);
    }

    public void setCcAddresses(Collection<String> collection) {
        this.ccAddresses = collection;
    }

    public void setCcAddresses(String ... stringArray) {
        this.ccAddresses = Arrays.asList(stringArray);
    }

    public void setBccAddresses(Collection<String> collection) {
        this.bccAddresses = collection;
    }

    public void setBccAddresses(String ... stringArray) {
        this.bccAddresses = Arrays.asList(stringArray);
    }

    public abstract boolean sendMail() throws MailException;

    public abstract Date getLastSendTime();

    public static final class Attachment {
        public final String fileName;
        public final File file;
        public final String textContent;

        protected Attachment(String string, File file, String string2) {
            this.fileName = string;
            this.file = file;
            this.textContent = string2;
        }
    }
}

