/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.server;

import java.util.logging.Logger;
import yajhfc.FaxOptions;
import yajhfc.HylaClientManager;
import yajhfc.IDAndNameOptions;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.model.servconn.ConnectionState;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.FaxListConnectionFactory;
import yajhfc.server.ServerOptions;
import yajhfc.ui.YajOptionPane;
import yajhfc.virtualcolumnstore.VirtColPersister;

public class Server {
    static final Logger log = Logger.getLogger(Server.class.getName());
    protected ServerOptions options;
    protected FaxListConnection connection;
    protected VirtColPersister persistence;
    protected HylaClientManager clientManager;

    public int getID() {
        return this.options.id;
    }

    public String getDisplayName() {
        return this.options.name;
    }

    public String toString() {
        return this.getOptions().toString();
    }

    public ServerOptions getOptions() {
        return this.options;
    }

    public synchronized void setOptions(ServerOptions serverOptions) {
        this.options = serverOptions;
        if (this.connection != null) {
            if (FaxListConnectionFactory.isConnectionTypeStillValid(this.connection, serverOptions)) {
                if (Utils.debugMode) {
                    log.fine("Server " + serverOptions.id + ": reloading connection settings");
                }
                this.connection.setOptions(serverOptions);
            } else {
                if (Utils.debugMode) {
                    log.fine("Server " + serverOptions.id + ": removing old connection");
                }
                if (this.connection.getConnectionState() != ConnectionState.DISCONNECTED) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
        }
        this.cleanupPersistence();
        this.cleanupClientManager();
    }

    public synchronized FaxListConnection getConnection() {
        if (this.connection == null) {
            try {
                if (Utils.debugMode) {
                    log.fine("Server " + this.options.id + ": creating connection");
                }
                this.connection = FaxListConnectionFactory.getFaxListConnection(this.options, this.getDialogUI());
                this.cleanupClientManager();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.connection;
    }

    protected YajOptionPane getDialogUI() {
        return Launcher2.application.getDialogUI();
    }

    public synchronized HylaClientManager getClientManager() {
        if (this.connection != null) {
            if (Utils.debugMode) {
                log.fine("Server " + this.options.id + ": getting client manager from connection");
            }
            return this.connection.getClientManager();
        }
        if (this.clientManager == null) {
            if (Utils.debugMode) {
                log.fine("Server " + this.options.id + ": creating client manager");
            }
            this.clientManager = new HylaClientManager(this.options);
        }
        if (Utils.debugMode) {
            log.fine("Server " + this.options.id + ": using separate client manager");
        }
        return this.clientManager;
    }

    public synchronized VirtColPersister getPersistence() {
        if (this.persistence == null) {
            if (Utils.debugMode) {
                log.fine("Server " + this.options.id + ": creating persistence");
            }
            this.persistence = VirtColPersister.createFromOptions(this.options);
        }
        return this.persistence;
    }

    public SenderIdentity getDefaultIdentity() {
        FaxOptions faxOptions = Utils.getFaxOptions();
        SenderIdentity senderIdentity = null;
        if (this.options.defaultIdentity >= 0) {
            senderIdentity = IDAndNameOptions.getItemByID(faxOptions.identities, this.options.defaultIdentity);
        }
        if (senderIdentity == null) {
            senderIdentity = faxOptions.getDefaultIdentity();
        }
        return senderIdentity;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.getConnectionState() == ConnectionState.CONNECTED || this.clientManager != null;
    }

    private void cleanupPersistence() {
        if (this.persistence != null) {
            if (Utils.debugMode) {
                log.fine("Server " + this.options.id + ": saving persistence");
            }
            this.persistence.persistValues();
            this.persistence.shutdown();
            this.persistence = null;
        }
    }

    private void cleanupClientManager() {
        if (this.clientManager != null) {
            if (Utils.debugMode) {
                log.fine("Server " + this.options.id + ": destroying old client manager");
            }
            this.clientManager.forceLogout();
            this.clientManager = null;
        }
    }

    public void shutdownCleanup() {
        this.cleanupPersistence();
        this.cleanupClientManager();
    }

    public Server(ServerOptions serverOptions) {
        this.setOptions(serverOptions);
    }
}

