/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import yajhfc.Utils;
import yajhfc.server.Server;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager {
    private static ServerManager DEFAULT = new ServerManager();
    protected final List<Server> servers = new ArrayList<Server>();
    protected final Map<Integer, Server> serversByID = new HashMap<Integer, Server>();
    protected Server currentServer = null;

    public static ServerManager getDefault() {
        return DEFAULT;
    }

    public synchronized void optionsChanged() {
        this.servers.clear();
        for (ServerOptions object : Utils.getFaxOptions().servers) {
            Server server = this.serversByID.get(object.id);
            if (server != null) {
                server.setOptions(object);
            } else {
                server = new Server(object);
            }
            this.servers.add(server);
        }
        this.serversByID.clear();
        for (Server server : this.servers) {
            this.serversByID.put(server.getID(), server);
        }
        if (this.currentServer != null) {
            if (!this.setCurrentByID(this.currentServer.getID())) {
                this.setCurrentByIndex(0);
            }
        } else if (this.servers.size() > 0) {
            this.setCurrentByIndex(0);
        }
    }

    public void setCurrentByIndex(int n) {
        this.currentServer = this.servers.get(n);
    }

    public synchronized boolean setCurrentByID(int n) {
        Server server = this.serversByID.get(n);
        if (server != null) {
            this.currentServer = server;
            return true;
        }
        return false;
    }

    public Server getServerByID(int n) {
        return this.serversByID.get(n);
    }

    public synchronized List<Server> getServers() {
        return this.servers;
    }

    public synchronized Server getCurrent() {
        return this.currentServer;
    }

    public void shutdownCleanup() {
        for (Server server : this.servers) {
            server.shutdownCleanup();
        }
    }

    public ServerManager() {
        this.optionsChanged();
    }
}

