/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.shutdown;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;
import yajhfc.shutdown.Win32ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySignalHandler
implements SignalHandler {
    private static final Logger log = Logger.getLogger(MySignalHandler.class.getName());
    private SignalHandler oldHandler;
    protected final List<Runnable> listToRun;

    public static SignalHandler install(String string, List<Runnable> list) {
        log.info("Installing signal handler for signal " + string);
        Signal signal = new Signal(string);
        MySignalHandler mySignalHandler = new MySignalHandler(list);
        mySignalHandler.oldHandler = Signal.handle(signal, mySignalHandler);
        log.fine("Installed signal handler " + mySignalHandler + "(prev: " + mySignalHandler.oldHandler + ")");
        return mySignalHandler;
    }

    @Override
    public void handle(Signal signal) {
        log.fine("Signal handler called for signal " + signal);
        Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".handle(): signal=" + signal);
        try {
            this.signalAction(signal);
            if (this.oldHandler != SIG_DFL && this.oldHandler != SIG_IGN) {
                Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".handle(): signal=" + signal + "; CHAINING");
                this.oldHandler.handle(signal);
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Signal handler failed", exception);
            Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".handle(): signal=" + signal + ": " + exception);
        }
        Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".handle(): signal=" + signal + "; DONE");
    }

    public void signalAction(Signal signal) {
        log.fine("Running runnables...");
        Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".signalAction(): signal=" + signal);
        for (Runnable runnable : this.listToRun) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                log.log(Level.WARNING, "Error running runnable", throwable);
                Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".signalAction(): signal=" + signal + ": " + throwable);
            }
        }
        Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".signalAction(): signal=" + signal + "; END!");
        log.fine("Runnables ran.");
    }

    private MySignalHandler(List<Runnable> list) {
        this.listToRun = list;
    }
}

