/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.splashscreen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class YJSplashScreen {
    private static final String IMPL_CLASS_NAME = "yajhfc.splashscreen.Java6YJSplashScreen";
    private static boolean triedLoad = false;
    private static YJSplashScreen splashScreenImpl;

    public abstract void close() throws IllegalStateException;

    public abstract void setImageURL(URL var1) throws NullPointerException, IOException, IllegalStateException;

    public abstract URL getImageURL() throws IllegalStateException;

    public abstract Rectangle getBounds() throws IllegalStateException;

    public abstract Dimension getSize() throws IllegalStateException;

    public abstract Graphics2D createGraphics() throws IllegalStateException;

    public abstract void update() throws IllegalStateException;

    public abstract boolean isVisible();

    protected abstract boolean haveSplashscreen();

    public static YJSplashScreen getSplashScreen() {
        if (!triedLoad) {
            Logger logger = Logger.getLogger(YJSplashScreen.class.getName());
            try {
                Class<?> clazz = Class.forName(IMPL_CLASS_NAME);
                splashScreenImpl = (YJSplashScreen)clazz.newInstance();
                if (!splashScreenImpl.haveSplashscreen()) {
                    logger.fine("No valid splash screen found (splashScreenImpl.haveSplashscreen() == false).");
                    splashScreenImpl = null;
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Could not create a splash screen implementation.", exception);
                splashScreenImpl = null;
            }
            triedLoad = true;
        }
        return splashScreenImpl;
    }
}

