/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tiff;

import java.lang.reflect.Array;
import java.util.Arrays;

public class TIFFTag {
    public final int ID;
    public final int nIFD;
    public final int dataType;
    public final Object value;

    public static int getLengthForDatatype(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: 
            case 8: {
                return 2;
            }
            case 4: 
            case 9: 
            case 11: {
                return 4;
            }
            case 5: 
            case 10: 
            case 12: {
                return 8;
            }
        }
        return -1;
    }

    public double doubleValue() {
        return this.doubleValue(0);
    }

    public double doubleValue(int n) {
        switch (this.dataType) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Array.getDouble(this.value, n);
            }
            case 5: 
            case 10: {
                double d = Array.getDouble(this.value, 2 * n);
                double d2 = Array.getDouble(this.value, 2 * n + 1);
                return d / d2;
            }
        }
        throw new IllegalArgumentException("This tag's data type does not represent a double value");
    }

    public float floatValue() {
        return this.floatValue(0);
    }

    public float floatValue(int n) {
        return (float)this.doubleValue(n);
    }

    public long longValue() {
        return this.longValue(0);
    }

    public long longValue(int n) {
        switch (this.dataType) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                return Array.getLong(this.value, n);
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                return (long)this.doubleValue(n);
            }
        }
        throw new IllegalArgumentException("This tag's data type does not represent a long value");
    }

    public int intValue() {
        return this.intValue(0);
    }

    public int intValue(int n) {
        return (int)this.longValue(n);
    }

    public String toString() {
        return "{ID: " + this.ID + "; nIFD: " + this.nIFD + "; dataType: " + this.dataType + "; value: " + this.valueToString() + '}';
    }

    protected String valueToString() {
        if (this.value instanceof byte[]) {
            return Arrays.toString((byte[])this.value);
        }
        if (this.value instanceof short[]) {
            return Arrays.toString((short[])this.value);
        }
        if (this.value instanceof int[]) {
            return Arrays.toString((int[])this.value);
        }
        if (this.value instanceof long[]) {
            return Arrays.toString((long[])this.value);
        }
        if (this.value instanceof float[]) {
            return Arrays.toString((float[])this.value);
        }
        if (this.value instanceof double[]) {
            return Arrays.toString((double[])this.value);
        }
        return this.value.toString();
    }

    public TIFFTag(int n, int n2, int n3, Object object) {
        this.ID = n;
        this.nIFD = n2;
        this.dataType = n3;
        this.value = object;
    }
}

