/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tray;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.tray.DefaultTrayIcon;
import yajhfc.tray.ITrayIcon;
import yajhfc.tray.TrayManager;

public class DefaultTrayManager
implements TrayManager {
    private static final Logger log = Logger.getLogger(DefaultTrayManager.class.getName());

    @Override
    public ITrayIcon installTrayIcon(Image image, String string, PopupMenu popupMenu, ActionListener actionListener) {
        try {
            DefaultTrayIcon defaultTrayIcon = new DefaultTrayIcon(image, string, popupMenu);
            defaultTrayIcon.addActionListener(actionListener);
            SystemTray.getSystemTray().add(defaultTrayIcon);
            return defaultTrayIcon;
        }
        catch (AWTException aWTException) {
            log.log(Level.WARNING, "Error creating a tray icon:", aWTException);
            return null;
        }
    }

    @Override
    public void removeTrayIcon(ITrayIcon iTrayIcon) {
        SystemTray.getSystemTray().remove((TrayIcon)((Object)iTrayIcon));
    }

    @Override
    public Dimension getTrayIconSize() {
        return SystemTray.getSystemTray().getTrayIconSize();
    }
}

