/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import yajhfc.Utils;
import yajhfc.util.ClipboardPopup;

public abstract class AbstractQuickSearchHelper
implements DocumentListener,
ActionListener {
    protected boolean eventLock = false;
    protected JToolBar quickSearchBar;
    protected JTextField textQuickSearch;
    protected JButton clearQuickSearchButton;
    private int searchTXID = 0;
    protected static final int QUICKSEARCH_DELAY = 500;
    private static Timer quickSearchTimer = null;

    protected static Timer getQuickSearchTimer() {
        if (quickSearchTimer == null) {
            quickSearchTimer = new Timer("QuickSearchTimer", true);
        }
        return quickSearchTimer;
    }

    protected final synchronized int nextTXID() {
        return ++this.searchTXID;
    }

    protected final synchronized int curTXID() {
        return this.searchTXID;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.eventLock) {
            return;
        }
        this.performQuickSearch();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.eventLock) {
            return;
        }
        this.performQuickSearch();
    }

    protected void performQuickSearch() {
        this.clearQuickSearchButton.setEnabled(this.textQuickSearch.getText().length() > 0);
        AbstractQuickSearchHelper.getQuickSearchTimer().schedule(new TimerTask(){
            final int txID;
            {
                this.txID = AbstractQuickSearchHelper.this.nextTXID();
            }

            public void run() {
                if (this.txID == AbstractQuickSearchHelper.this.curTXID()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (txID == AbstractQuickSearchHelper.this.curTXID()) {
                                AbstractQuickSearchHelper.this.performActualQuickSearch();
                            }
                        }
                    });
                }
            }
        }, 500L);
    }

    protected abstract void performActualQuickSearch();

    protected abstract Component getFocusComponent();

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear")) {
            this.textQuickSearch.setText("");
        } else if (string.equals("focus")) {
            this.getFocusComponent().requestFocusInWindow();
        }
    }

    public JToolBar getQuickSearchBar(Action action, String string, String string2) {
        return this.getQuickSearchBar(string, string2, action);
    }

    public JToolBar getQuickSearchBar(String string, String string2, Action ... actionArray) {
        if (this.quickSearchBar == null) {
            this.quickSearchBar = new JToolBar();
            this.textQuickSearch = new JTextField(20);
            this.textQuickSearch.getDocument().addDocumentListener(this);
            this.textQuickSearch.setActionCommand("focus");
            this.textQuickSearch.addActionListener(this);
            this.textQuickSearch.setToolTipText(string);
            Dimension dimension = this.textQuickSearch.getPreferredSize();
            dimension.width = Integer.MAX_VALUE;
            dimension.height += 4;
            this.textQuickSearch.setMaximumSize(dimension);
            this.textQuickSearch.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            this.clearQuickSearchButton = new JButton(Utils._("Reset"));
            this.clearQuickSearchButton.setActionCommand("clear");
            this.clearQuickSearchButton.addActionListener(this);
            this.clearQuickSearchButton.setEnabled(false);
            this.clearQuickSearchButton.setToolTipText(string2);
            this.quickSearchBar.add(new JLabel(Utils._("Search") + ": "));
            this.quickSearchBar.add(this.textQuickSearch);
            this.quickSearchBar.add(this.clearQuickSearchButton);
            if (actionArray != null && actionArray.length > 0) {
                this.quickSearchBar.addSeparator();
                for (Action action : actionArray) {
                    this.quickSearchBar.add(action);
                }
            }
        }
        return this.quickSearchBar;
    }
}

