/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class AlphaPanel
extends JComponent {
    protected static final String DEFAULT_COLOR = "controlShadow";
    protected Color alphaColor;
    protected float transparency;
    protected AlphaComposite alphaComposite = null;

    public AlphaPanel(Color color, float f) {
        this.alphaColor = color;
        this.transparency = f;
        this.setOpaque(false);
    }

    public AlphaPanel() {
        this(UIManager.getColor(DEFAULT_COLOR), 0.25f);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.transparency);
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(this.alphaComposite);
        graphics2D.setColor(this.alphaColor);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setComposite(composite);
    }

    public void updateUI() {
        if (this.alphaColor instanceof UIResource) {
            this.setAlphaColor(UIManager.getColor(DEFAULT_COLOR));
        }
        super.updateUI();
    }

    public Color getAlphaColor() {
        return this.alphaColor;
    }

    public void setAlphaColor(Color color) {
        this.alphaColor = color;
        this.alphaComposite = null;
        this.repaint();
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float f) {
        this.transparency = f;
        this.alphaComposite = null;
        this.repaint();
    }
}

