/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import yajhfc.Utils;

public class ClipboardPopup
implements MouseListener,
ActionListener {
    protected JPopupMenu popupMenu;
    protected JMenuItem cut;
    protected JMenuItem copy;
    protected JMenuItem paste;
    protected JMenuItem delete;
    protected JMenuItem selectAll;
    protected JTextComponent lastTarget;
    public static final ClipboardPopup DEFAULT_POPUP = new ClipboardPopup();

    public ClipboardPopup() {
        this.createPopupMenu();
    }

    protected void createPopupMenu() {
        this.cut = new JMenuItem(Utils._("Cut"), Utils.loadIcon("general/Cut"));
        this.cut.addActionListener(this);
        this.copy = new JMenuItem(Utils._("Copy"), Utils.loadIcon("general/Copy"));
        this.copy.addActionListener(this);
        this.paste = new JMenuItem(Utils._("Paste"), Utils.loadIcon("general/Paste"));
        this.paste.addActionListener(this);
        this.delete = new JMenuItem(Utils._("Delete"), Utils.loadIcon("general/Remove"));
        this.delete.addActionListener(this);
        this.selectAll = new JMenuItem(Utils._("Select All"));
        this.selectAll.addActionListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.cut);
        this.popupMenu.add(this.copy);
        this.popupMenu.add(this.paste);
        this.popupMenu.add(this.delete);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.selectAll);
    }

    protected void preparePopup(JTextComponent jTextComponent) {
        boolean bl = jTextComponent.getSelectionStart() < jTextComponent.getSelectionEnd();
        boolean bl2 = jTextComponent.isEditable();
        boolean bl3 = Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
        this.cut.setEnabled(bl && bl2);
        this.copy.setEnabled(bl);
        this.paste.setEnabled(bl2 && bl3);
        this.delete.setEnabled(bl && bl2);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cut) {
            this.lastTarget.cut();
        } else if (object == this.copy) {
            this.lastTarget.copy();
        } else if (object == this.paste) {
            this.lastTarget.paste();
        } else if (object == this.delete) {
            this.lastTarget.replaceSelection("");
        } else if (object == this.selectAll) {
            this.lastTarget.selectAll();
        }
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            this.preparePopup(jTextComponent);
            this.lastTarget = jTextComponent;
            this.popupMenu.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean addToComponent(Component component) {
        Component component2;
        JComboBox jComboBox;
        if (component instanceof JTextComponent) {
            component.addMouseListener(this);
            return true;
        }
        if (component instanceof JComboBox && (jComboBox = (JComboBox)component).isEditable() && (component2 = jComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
            component2.addMouseListener(this);
            return true;
        }
        return false;
    }
}

