/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleFileFilter
extends FileFilter {
    public static final String ANY_EXTENSION = "/any\\";
    private Set<String> filters = new TreeSet<String>();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private String defaultExtension;
    private boolean acceptAnyFile = false;

    public ExampleFileFilter() {
    }

    public ExampleFileFilter(String string) {
        this(string, null);
    }

    public ExampleFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public ExampleFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public ExampleFileFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            if (this.acceptAnyFile) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.contains(this.getExtension(file))) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        if (file != null) {
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return "";
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new TreeSet<String>();
        }
        this.filters.add(string.toLowerCase());
        this.fullDescription = null;
        if (this.defaultExtension == null) {
            this.defaultExtension = string;
        }
        if (ANY_EXTENSION.equals(string)) {
            this.acceptAnyFile = true;
            this.useExtensionsInDescription = false;
        }
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.description != null) {
                    stringBuilder.append(this.description).append(" (");
                } else {
                    stringBuilder.append('(');
                }
                Iterator<String> iterator = this.filters.iterator();
                if (iterator != null) {
                    stringBuilder.append('.').append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder.append(", .").append(iterator.next());
                    }
                }
                stringBuilder.append(')');
                this.fullDescription = stringBuilder.toString();
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public Set<String> getExtensions() {
        return this.filters;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(String string) {
        this.defaultExtension = string;
    }
}

