/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.util.ClipboardPopup;

public class ExceptionDialog
extends JDialog
implements ActionListener {
    private static final int border = 12;
    private static final int maxTextWidth = 400;
    private static final int maxTextLines = 10;
    private JLabel lblText;
    private JLabel lblExceptionText;
    private JScrollPane scrollStacktrace;
    private JTextArea textStacktrace;
    private JButton btnOK;
    private JButton btnDetails;
    private JButton btnCopy;
    private JPanel contentPane;
    private Box boxButtons;
    private Component strutStacktrace;
    private boolean detailState = false;
    private String fullMessage;
    private int timeout = 0;
    private Timer timeoutTimer = null;
    private static final Logger log = Logger.getLogger(ExceptionDialog.class.getName());

    private void initialize(String string, Exception exception) {
        double[][] dArrayArray = new double[][]{{12.0, -2.0, 12.0, -1.0, 12.0}, {12.0, -2.0, 12.0, -2.0, -2.0, -1.0, 12.0, -2.0, 12.0}};
        this.contentPane = new JPanel(new TableLayout(dArrayArray));
        this.boxButtons = Box.createHorizontalBox();
        this.btnOK = new JButton(Utils._("OK"));
        this.btnOK.addActionListener(this);
        this.btnDetails = new JButton(Utils._("Details") + " >>");
        this.btnDetails.addActionListener(this);
        this.btnCopy = new JButton(Utils._("Copy"), Utils.loadIcon("general/Copy"));
        this.btnCopy.addActionListener(this);
        this.boxButtons.add(Box.createHorizontalGlue());
        this.boxButtons.add(this.btnOK);
        this.boxButtons.add(Box.createHorizontalStrut(12));
        this.boxButtons.add(this.btnDetails);
        this.boxButtons.add(Box.createHorizontalStrut(12));
        this.boxButtons.add(this.btnCopy);
        this.boxButtons.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        this.lblText = new JLabel("<html>" + string + "</html>");
        this.adjustTextLabelSize(this.lblText);
        String string2 = exception.getLocalizedMessage();
        if (string2 == null) {
            string2 = exception.getMessage();
        }
        if (string2 != null) {
            this.lblExceptionText = new JLabel("<html>" + string2 + "</html>");
            this.lblExceptionText.setVerticalAlignment(1);
            this.adjustTextLabelSize(this.lblExceptionText);
        } else {
            this.lblExceptionText = null;
        }
        this.strutStacktrace = Box.createVerticalStrut(20);
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        stringWriter.append("\n\n");
        stringWriter.append("YajHFC").append(' ').append("0.6.1 (srfax v4)").append('\n');
        stringWriter.append("Java ").append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.vendor")).append(")\n").append(System.getProperty("java.runtime.name")).append(' ').append(System.getProperty("java.runtime.version")).append('\n').append(System.getProperty("java.vm.name")).append('\n');
        stringWriter.append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version")).append(" (").append(System.getProperty("os.arch")).append(")\n");
        String string3 = stringWriter.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('\n');
        if (string2 != null) {
            stringBuilder.append(string2).append('\n');
        }
        stringBuilder.append('\n');
        stringBuilder.append(string3);
        this.fullMessage = stringBuilder.toString();
        this.textStacktrace = new JTextArea(string3);
        this.textStacktrace.setFont(new Font("DialogInput", 0, 12));
        this.textStacktrace.setEditable(false);
        this.textStacktrace.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textStacktrace.setRows(8);
        this.scrollStacktrace = new JScrollPane(this.textStacktrace, 22, 30);
        this.contentPane.add((Component)jLabel, "1, 1, 1, 3");
        this.contentPane.add((Component)this.lblText, "3, 1");
        if (this.lblExceptionText != null) {
            this.contentPane.add((Component)this.lblExceptionText, "3, 3");
        }
        this.contentPane.add((Component)this.boxButtons, "1, 7, 3, 7");
        this.setResizable(false);
        this.getRootPane().getRootPane().setDefaultButton(this.btnOK);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.contentPane);
        this.pack();
        if (Utils.debugMode) {
            log.log(Level.WARNING, "Exception occurred: " + string, exception);
        }
    }

    private void adjustTextLabelSize(JLabel jLabel) {
        Dimension dimension = jLabel.getPreferredSize();
        if (dimension.width > 400) {
            int n = dimension.width / 400 + 1;
            if (n > 10) {
                n = 10;
            }
            dimension.height *= n;
        }
        dimension.width = 400;
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            this.setTimeout(-1);
            this.dispose();
        } else if (object == this.btnDetails) {
            this.setTimeout(-1);
            boolean bl = this.detailState = !this.detailState;
            if (this.detailState) {
                this.contentPane.add(this.strutStacktrace, "1, 4, 3, 4");
                this.contentPane.add((Component)this.scrollStacktrace, "1, 5, 3, 5");
            } else {
                this.contentPane.remove(this.strutStacktrace);
                this.contentPane.remove(this.scrollStacktrace);
            }
            this.btnDetails.setText(Utils._("Details") + (this.detailState ? " <<" : " >>"));
            this.setResizable(this.detailState);
            this.pack();
        } else if (object == this.btnCopy) {
            this.setTimeout(-1);
            StringSelection stringSelection = new StringSelection(this.fullMessage);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        } else if (object == this.timeoutTimer) {
            this.setTimeout(this.timeout - 1);
            if (this.timeout <= 0) {
                this.dispose();
            }
        }
    }

    public void setTimeout(int n) {
        if (this.timeout != n) {
            this.timeout = n;
            if (n > 0) {
                this.btnOK.setText(Utils._("OK") + " (" + n + ")");
                if (this.timeoutTimer == null) {
                    this.timeoutTimer = new Timer(1000, this);
                    this.timeoutTimer.start();
                }
            } else {
                this.btnOK.setText(Utils._("OK"));
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.stop();
                    this.timeoutTimer = null;
                }
            }
        }
    }

    public ExceptionDialog(Dialog dialog, String string, String string2, Exception exception) {
        super(dialog, string, true);
        this.initialize(string2, exception);
        this.setLocationRelativeTo(dialog);
    }

    public ExceptionDialog(Frame frame, String string, String string2, Exception exception) {
        super(frame, string, true);
        this.initialize(string2, exception);
        this.setLocationRelativeTo(frame);
    }

    public static void showExceptionDialog(Component component, String string, Exception exception) {
        ExceptionDialog.showExceptionDialog(component, Utils._("Error"), string, exception, -1);
    }

    public static void showExceptionDialog(Component component, String string, Exception exception, int n) {
        ExceptionDialog.showExceptionDialog(component, Utils._("Error"), string, exception, n);
    }

    public static void showExceptionDialog(Component component, String string, String string2, Exception exception) {
        ExceptionDialog.showExceptionDialog(component, string, string2, exception, -1);
    }

    public static void showExceptionDialog(Component component, String string, String string2, Exception exception, int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            ExceptionDialog exceptionDialog;
            if (!(component instanceof Window)) {
                if (component != null) {
                    component = SwingUtilities.getWindowAncestor(component);
                }
                if (component == null) {
                    component = Launcher2.application.getFrame();
                }
            }
            if (component instanceof Dialog) {
                exceptionDialog = new ExceptionDialog((Dialog)component, string, string2, exception);
            } else if (component instanceof Frame) {
                exceptionDialog = new ExceptionDialog((Frame)component, string, string2, exception);
            } else {
                JOptionPane.showMessageDialog(component, string2 + "\n" + exception.getMessage(), Utils._("Error"), 0);
                return;
            }
            if (n > 0) {
                exceptionDialog.setTimeout(n);
            }
            exceptionDialog.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new DisplayRunnable(component, string, string2, exception, n));
            }
            catch (InterruptedException interruptedException) {
                log.log(Level.WARNING, "Error showing exception dialog.", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                log.log(Level.WARNING, "Error showing exception dialog.", invocationTargetException);
            }
        }
    }

    static class DisplayRunnable
    implements Runnable {
        private Component parent;
        private Exception ex;
        private String msg;
        private String title;
        private int timeout;

        public DisplayRunnable(Component component, String string, String string2, Exception exception, int n) {
            this.parent = component;
            this.ex = exception;
            this.msg = string2;
            this.title = string;
            this.timeout = n;
        }

        public void run() {
            ExceptionDialog.showExceptionDialog(this.parent, this.title, this.msg, this.ex, this.timeout);
        }
    }
}

