/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import yajhfc.Utils;

public class FileChooserRunnable
implements Runnable {
    protected final JFileChooser fileChooser;
    protected final Component parent;
    protected File selection;
    protected final boolean showOpen;
    protected final String title;
    protected final FileFilter[] fileFilters;

    public void run() {
        if (this.title != null) {
            this.fileChooser.setDialogTitle(this.title);
        }
        if (this.fileFilters != null) {
            this.fileChooser.resetChoosableFileFilters();
            if (this.fileFilters.length >= 1) {
                for (FileFilter fileFilter : this.fileFilters) {
                    this.fileChooser.addChoosableFileFilter(fileFilter);
                }
                this.fileChooser.setFileFilter(this.fileFilters[0]);
            }
        }
        if (this.selection != null) {
            this.fileChooser.setSelectedFile(this.selection);
        }
        this.selection = this.showOpen ? (this.fileChooser.showOpenDialog(this.parent) == 0 ? this.fileChooser.getSelectedFile() : null) : (this.fileChooser.showSaveDialog(this.parent) == 0 ? Utils.getSelectedFileFromSaveChooser(this.fileChooser) : null);
    }

    public File getSelection() {
        return this.selection;
    }

    public FileChooserRunnable(Component component, JFileChooser jFileChooser, String string, FileFilter[] fileFilterArray, File file, boolean bl) {
        this.fileChooser = jFileChooser;
        this.showOpen = bl;
        this.parent = component;
        this.title = string;
        this.fileFilters = fileFilterArray;
        this.selection = file;
    }
}

