/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import yajhfc.Utils;

public class JTableTABAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(JTableTABAction.class.getName());
    private JTable table;
    private boolean forwardMode;
    private boolean checkCol;
    private String origKey;
    private static final String nextRowAction = "selectNextRow";
    private static final String prevRowAction = "selectPreviousRow";
    private static final String nextRowActionWrapped = "selectNextRow-YajHFCWrapped";
    private static final String prevRowActionWrapped = "selectPreviousRow-YajHFCWrapped";
    private static final String nextTABAction = "yajhfc-nextTabAction";
    private static final String prevTABAction = "yajhfc-prevTabAction";

    JTableTABAction(JTable jTable, boolean bl, boolean bl2, String string) {
        this.table = jTable;
        this.forwardMode = bl;
        this.checkCol = bl2;
        this.origKey = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.table.getRowCount();
        if (this.forwardMode) {
            if (n == 0 || this.table.getSelectedRow() == n - 1 && (!this.checkCol || this.table.getSelectedColumn() == this.table.getColumnCount() - 1)) {
                Container container = this.table.getFocusCycleRootAncestor();
                container.getFocusTraversalPolicy().getComponentAfter(container, this.table).requestFocusInWindow();
            } else {
                this.table.getActionMap().get(this.origKey).actionPerformed(actionEvent);
            }
        } else if (n == 0 || this.table.getSelectedRow() == 0 && (!this.checkCol || this.table.getSelectedColumn() == 0)) {
            Container container = this.table.getFocusCycleRootAncestor();
            container.getFocusTraversalPolicy().getComponentBefore(container, this.table).requestFocusInWindow();
        } else {
            this.table.getActionMap().get(this.origKey).actionPerformed(actionEvent);
        }
    }

    public static void replaceTABWithNextRow(JTable jTable) {
        InputMap inputMap = jTable.getInputMap(1);
        ActionMap actionMap = jTable.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        JTableTABAction jTableTABAction = new JTableTABAction(jTable, true, false, nextRowAction);
        actionMap.put(nextRowActionWrapped, jTableTABAction);
        inputMap.put(keyStroke, nextRowActionWrapped);
        keyStroke = KeyStroke.getKeyStroke(9, 64);
        jTableTABAction = new JTableTABAction(jTable, false, false, prevRowAction);
        actionMap.put(prevRowActionWrapped, jTableTABAction);
        inputMap.put(keyStroke, prevRowActionWrapped);
    }

    public static void wrapDefTabAction(JTable jTable) {
        JTableTABAction jTableTABAction;
        InputMap inputMap = jTable.getInputMap(1);
        ActionMap actionMap = jTable.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        String string = (String)inputMap.get(keyStroke);
        if (string != null) {
            jTableTABAction = new JTableTABAction(jTable, true, true, string);
            actionMap.put(nextTABAction, jTableTABAction);
            inputMap.put(keyStroke, nextTABAction);
            if (Utils.debugMode) {
                log.fine("Replaced action " + string + " for key " + keyStroke);
            }
        } else {
            log.info("No existing binding for " + keyStroke + " found.");
        }
        keyStroke = KeyStroke.getKeyStroke(9, 64);
        string = (String)inputMap.get(keyStroke);
        if (string != null) {
            jTableTABAction = new JTableTABAction(jTable, false, true, string);
            actionMap.put(prevTABAction, jTableTABAction);
            inputMap.put(keyStroke, prevTABAction);
            if (Utils.debugMode) {
                log.fine("Replaced action " + string + " for key " + keyStroke);
            }
        } else {
            log.info("No existing binding for " + keyStroke + " found.");
        }
    }
}

