/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListListModel<T>
extends AbstractListModel
implements Collection<T> {
    protected List<T> list;

    public ListListModel(List<T> list) {
        this.list = list;
    }

    @Override
    public Object getElementAt(int n) {
        return this.list.get(n);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public void changeNotify(T t) {
        int n = this.list.indexOf(t);
        this.fireContentsChanged(this, n, n);
    }

    public void changeNotify(int n) {
        this.fireContentsChanged(this, n, n);
    }

    @Override
    public boolean add(T t) {
        this.list.add(t);
        int n = this.list.size() - 1;
        this.fireIntervalAdded(this, n, n);
        return true;
    }

    public void add(int n, T t) {
        this.list.add(n, t);
        this.fireIntervalAdded(this, n, n);
    }

    public void remove(int n) {
        this.list.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    @Override
    public void clear() {
        int n = this.list.size() - 1;
        this.list.clear();
        if (n >= 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n = this.list.size();
        if (this.list.addAll(collection)) {
            int n2 = this.list.size() - 1;
            if (n2 >= 0) {
                this.fireIntervalAdded(this, n, n2);
            }
            return true;
        }
        return false;
    }

    public void removeAll(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.remove(nArray[i]);
        }
    }

    public void swap(int n, int n2) {
        Collections.swap(this.list, n, n2);
        this.fireContentsChanged(this, n, n);
        this.fireContentsChanged(this, n2, n2);
    }

    public void sort(Comparator<? super T> comparator) {
        Collections.sort(this.list, comparator);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public void moveUp(int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        if (nArray[0] <= 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot move first element up.");
        }
        for (int n : nArray) {
            Collections.swap(this.list, n, n - 1);
        }
        this.fireContentsChanged(this, nArray[0] - 1, nArray[nArray.length - 1]);
    }

    public void moveDown(int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        if (nArray[nArray.length - 1] >= this.list.size()) {
            throw new ArrayIndexOutOfBoundsException("Cannot move last element down.");
        }
        for (int n : nArray) {
            Collections.swap(this.list, n, n + 1);
        }
        this.fireContentsChanged(this, nArray[0], nArray[nArray.length - 1] + 1);
    }

    public T get(int n) {
        return this.list.get(n);
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        if (this.list != list) {
            int n = this.list.size() - 1;
            if (n >= 0) {
                this.list = Collections.emptyList();
                this.fireIntervalRemoved(this, 0, n);
            }
            this.list = list;
            this.fireIntervalAdded(this, 0, list.size() - 1);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        return this.list.toArray(UArray);
    }

    @Override
    public boolean remove(Object object) {
        int n = this.list.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Object object : this.list.toArray()) {
            if (collection.contains(object)) continue;
            this.remove(object);
            bl = true;
        }
        return bl;
    }
}

