/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.util.ActionJRadioButton;
import yajhfc.util.ActionJRadioButtonMenuItem;
import yajhfc.util.ExceptionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiButtonGroup {
    public String label;
    protected List<Item> items = new ArrayList<Item>();
    protected String selectedActionCommand = null;

    protected abstract void actualActionPerformed(ActionEvent var1);

    public Item addItem(String string, String string2) {
        Item item = new Item(string, string2);
        this.items.add(item);
        return item;
    }

    public String getSelectedActionCommand() {
        return this.selectedActionCommand;
    }

    public void setSelectedActionCommand(String string) {
        if (!string.equals(this.selectedActionCommand)) {
            for (Item item : this.items) {
                item.setSelected(string.equals(item.getActionCommand()));
            }
            this.selectedActionCommand = string;
        }
    }

    public JRadioButtonMenuItem[] createMenuItems() {
        JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            ActionJRadioButtonMenuItem actionJRadioButtonMenuItem = new ActionJRadioButtonMenuItem(this.items.get(i));
            jRadioButtonMenuItemArray[i] = actionJRadioButtonMenuItem;
        }
        return jRadioButtonMenuItemArray;
    }

    public JRadioButton[] createButtons() {
        JRadioButton[] jRadioButtonArray = new JRadioButton[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            jRadioButtonArray[i] = new ActionJRadioButton(this.items.get(i));
        }
        return jRadioButtonArray;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public class Item
    extends AbstractAction {
        public String getActionCommand() {
            return (String)this.getValue("ActionCommandKey");
        }

        public void setSelected(boolean bl) {
            this.putValue("selected", bl);
        }

        public boolean isSelected() {
            Boolean bl = (Boolean)this.getValue("selected");
            return bl != null && bl != false;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            try {
                MultiButtonGroup.this.setSelectedActionCommand(actionEvent.getActionCommand());
                if (actionEvent.getSource() instanceof AbstractButton) {
                    ((AbstractButton)actionEvent.getSource()).setSelected(true);
                }
                MultiButtonGroup.this.actualActionPerformed(actionEvent);
            }
            catch (Exception exception) {
                Object object = null;
                if (actionEvent != null) {
                    object = actionEvent.getSource();
                }
                if (object == null || !(object instanceof Component)) {
                    object = Launcher2.application.getFrame();
                }
                ExceptionDialog.showExceptionDialog((Component)object, Utils._("An Error occurred executing the desired action:"), exception);
            }
        }

        protected Item(String string, String string2) {
            super(string);
            this.putValue("ActionCommandKey", string2);
            this.setSelected(false);
        }
    }
}

