/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class NumberRowViewport
extends JViewport {
    static final Logger log = Logger.getLogger(NumberRowViewport.class.getName());
    protected JTable rowNumberTable;
    protected JTable realTable;

    public NumberRowViewport(JTable jTable, JScrollPane jScrollPane) {
        this.initialize(jTable);
        this.attachToScrollPane(jScrollPane);
    }

    public NumberRowViewport(JTable jTable) {
        this.initialize(jTable);
    }

    protected void initialize(JTable jTable) {
        this.rowNumberTable = new JTable(new RowNumberTableModel(jTable.getModel()));
        this.rowNumberTable.getTableHeader().setResizingAllowed(false);
        this.rowNumberTable.getTableHeader().setReorderingAllowed(false);
        this.rowNumberTable.getColumnModel().getColumn(0).setPreferredWidth(37);
        this.rowNumberTable.setFocusable(false);
        this.setTableColors();
        this.setView(this.rowNumberTable);
        this.setPreferredSize(this.rowNumberTable.getPreferredSize());
        new SelectionSyncer(jTable, this.rowNumberTable);
        this.realTable = jTable;
    }

    private void setTableColors() {
        if (this.rowNumberTable != null) {
            this.rowNumberTable.setBackground(UIManager.getColor("TableHeader.background"));
            this.rowNumberTable.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.rowNumberTable.setFont(UIManager.getFont("TableHeader.font"));
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setTableColors();
    }

    public void attachToScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setRowHeader(this);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", this.rowNumberTable.getTableHeader());
    }

    public void detachFromScrollPane() {
        if (this.getParent() instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)this.getParent();
            jScrollPane.setCorner("UPPER_LEFT_CORNER", null);
            jScrollPane.setRowHeader(null);
        }
    }

    protected void reconfigureTable() {
        this.rowNumberTable.setRowHeight(this.realTable.getRowHeight());
    }

    protected static class SelectionSyncer
    implements ListSelectionListener {
        protected JTable table1;
        protected JTable table2;
        protected boolean inSync = false;

        public SelectionSyncer(JTable jTable, JTable jTable2) {
            this.table1 = jTable;
            this.table2 = jTable2;
            jTable.getSelectionModel().addListSelectionListener(this);
            jTable2.getSelectionModel().addListSelectionListener(this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            ListSelectionModel listSelectionModel;
            if (this.inSync) {
                return;
            }
            ListSelectionModel listSelectionModel2 = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel2 == this.table1.getSelectionModel()) {
                listSelectionModel = this.table2.getSelectionModel();
            } else if (listSelectionModel2 == this.table2.getSelectionModel()) {
                listSelectionModel = this.table1.getSelectionModel();
            } else {
                log.log(Level.WARNING, "Unknown selection: " + listSelectionEvent.toString());
                return;
            }
            this.inSync = true;
            if (listSelectionEvent.getValueIsAdjusting()) {
                listSelectionModel.setValueIsAdjusting(true);
            }
            boolean bl = false;
            int n2 = n = listSelectionEvent.getFirstIndex();
            for (int i = n; i <= listSelectionEvent.getLastIndex(); ++i) {
                if (listSelectionModel2.isSelectedIndex(i)) {
                    if (bl) continue;
                    n2 = i;
                    if (n < i) {
                        listSelectionModel.removeSelectionInterval(n, i - 1);
                    }
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                n = i;
                if (n2 < i) {
                    listSelectionModel.addSelectionInterval(n2, i - 1);
                }
                bl = false;
            }
            if (bl) {
                listSelectionModel.addSelectionInterval(n2, listSelectionEvent.getLastIndex());
            } else {
                listSelectionModel.removeSelectionInterval(n, listSelectionEvent.getLastIndex());
            }
            if (!listSelectionEvent.getValueIsAdjusting()) {
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.inSync = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RowNumberTableModel
    extends AbstractTableModel
    implements TableModelListener {
        protected TableModel realModel;

        @Override
        public String getColumnName(int n) {
            return "   ";
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.realModel.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n + 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Integer.class;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            switch (tableModelEvent.getType()) {
                case -1: 
                case 1: {
                    this.fireTableChanged(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, tableModelEvent.getType()));
                    this.fireTableRowsUpdated(tableModelEvent.getLastRow(), this.getRowCount());
                    break;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() != -1 && tableModelEvent.getLastRow() != Integer.MAX_VALUE) break;
                    this.fireTableDataChanged();
                    NumberRowViewport.this.reconfigureTable();
                }
            }
        }

        public RowNumberTableModel(TableModel tableModel) {
            this.realModel = tableModel;
            tableModel.addTableModelListener(this);
        }
    }
}

