/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import yajhfc.Utils;
import yajhfc.util.CancelAction;

public class PasswordDialog
extends JDialog {
    JPanel jContentFrame;
    JLabel labelPrompt;
    JTextField userField;
    JPasswordField passField;
    JButton btnOK;
    JButton btnCancel;
    public String returnedPassword = null;
    public String returnedUsername = null;

    private void initialize(String string, String string2, boolean bl, final boolean bl2) {
        this.jContentFrame = new JPanel(new BorderLayout());
        this.labelPrompt = new JLabel(string, 0);
        this.labelPrompt.setAlignmentX(0.0f);
        this.passField = new JPasswordField(10);
        this.passField.setAlignmentX(0.0f);
        this.userField = new JTextField(10);
        this.userField.setText(string2);
        this.userField.setEditable(bl);
        this.userField.setAlignmentX(0.0f);
        this.btnOK = new JButton(Utils._("OK"));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                char[] cArray = PasswordDialog.this.passField.getPassword();
                if (!bl2 && cArray.length == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                PasswordDialog.this.returnedPassword = new String(cArray);
                PasswordDialog.this.returnedUsername = PasswordDialog.this.userField.getText();
                PasswordDialog.this.dispose();
            }
        });
        CancelAction cancelAction = new CancelAction(this);
        this.btnCancel = cancelAction.createCancelButton();
        JLabel jLabel = new JLabel(Utils._("Username:"));
        jLabel.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(Utils._("Password:"));
        jLabel.setAlignmentX(0.0f);
        if (!bl2) {
            this.passField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.passwordChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.passwordChanged();
                }

                private void passwordChanged() {
                    PasswordDialog.this.btnOK.setEnabled(PasswordDialog.this.passField.getDocument().getLength() > 0);
                }
            });
            this.btnOK.setEnabled(false);
        }
        Dimension dimension = new Dimension(12, 12);
        this.jContentFrame.add(Box.createRigidArea(dimension), "North");
        this.jContentFrame.add(Box.createRigidArea(dimension), "South");
        this.jContentFrame.add(Box.createRigidArea(dimension), "East");
        this.jContentFrame.add(Box.createRigidArea(dimension), "West");
        dimension = new Dimension(12, 12);
        Box box = Box.createVerticalBox();
        box.add(this.labelPrompt);
        box.add(Box.createRigidArea(dimension));
        box.add(jLabel);
        box.add(this.userField);
        box.add(Box.createRigidArea(dimension));
        box.add(jLabel2);
        box.add(this.passField);
        box.add(Box.createRigidArea(dimension));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(this.btnOK);
        box2.add(Box.createRigidArea(dimension));
        box2.add(this.btnCancel);
        box2.add(Box.createHorizontalGlue());
        box2.setAlignmentX(0.0f);
        box.add(box2);
        this.jContentFrame.add((Component)box, "Center");
        this.add(this.jContentFrame);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.pack();
        if (bl) {
            this.userField.requestFocusInWindow();
            this.userField.setSelectionStart(0);
            this.userField.setSelectionStart(string2.length());
        } else {
            this.passField.requestFocusInWindow();
        }
    }

    public PasswordDialog(Frame frame, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(frame, string, true);
        this.initialize(string2, string3, bl, bl2);
        this.setLocationRelativeTo(frame);
    }

    public PasswordDialog(Dialog dialog, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(dialog, string, true);
        this.initialize(string2, string3, bl, bl2);
        this.setLocationRelativeTo(dialog);
    }

    public static String[] showPasswordDialog(Window window, String string, String string2, String string3, boolean bl) {
        return PasswordDialog.showPasswordDialog(window, string, string2, string3, bl, true);
    }

    public static String[] showPasswordDialog(Window window, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (SwingUtilities.isEventDispatchThread()) {
            return PasswordDialog.showPasswordDialogUnthreaded(window, string, string2, string3, bl, bl2);
        }
        return PasswordDialog.showPasswordDialogThreaded(window, string, string2, string3, bl, bl2);
    }

    static String[] showPasswordDialogUnthreaded(Window window, String string, String string2, String string3, boolean bl, boolean bl2) {
        PasswordDialog passwordDialog;
        if (window instanceof Dialog) {
            passwordDialog = new PasswordDialog((Dialog)window, string, string2, string3, bl, bl2);
        } else if (window instanceof Frame) {
            passwordDialog = new PasswordDialog((Frame)window, string, string2, string3, bl, bl2);
        } else {
            return null;
        }
        passwordDialog.setVisible(true);
        if (passwordDialog.returnedPassword != null) {
            return new String[]{passwordDialog.returnedUsername, passwordDialog.returnedPassword};
        }
        return null;
    }

    private static String[] showPasswordDialogThreaded(Window window, String string, String string2, String string3, boolean bl, boolean bl2) {
        DisplayRunnable displayRunnable = new DisplayRunnable(window, string, string2, string3, bl, bl2);
        try {
            SwingUtilities.invokeAndWait(displayRunnable);
            return displayRunnable.result;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public static class DisplayRunnable
    implements Runnable {
        protected final Window owner;
        protected final String title;
        protected final String prompt;
        protected final boolean editableUsername;
        protected final String userName;
        protected final boolean allowEmptyPassword;
        public String[] result;

        public void run() {
            this.result = PasswordDialog.showPasswordDialogUnthreaded(this.owner, this.title, this.prompt, this.userName, this.editableUsername, this.allowEmptyPassword);
        }

        public DisplayRunnable(Window window, String string, String string2, String string3, boolean bl, boolean bl2) {
            this.owner = window;
            if (!(window instanceof Frame) && !(window instanceof Dialog)) {
                throw new IllegalArgumentException("owner must be of type Dialog or Frame!");
            }
            this.title = string;
            this.prompt = string2;
            this.userName = string3;
            this.editableUsername = bl;
            this.allowEmptyPassword = bl2;
        }
    }
}

