/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import yajhfc.util.ProgressWorker;

public class ProgressContentPane
extends JPanel
implements ProgressWorker.ProgressUI {
    JLabel progressLabel;
    JLabel noteLabel;
    JProgressBar progressBar;

    public ProgressContentPane() {
        super(null);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.progressLabel = new JLabel("Logging in...");
        this.noteLabel = new JLabel();
        this.progressBar = new JProgressBar(0);
        this.add(this.progressLabel);
        this.add(this.noteLabel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.progressBar);
    }

    public void close() {
        SwingUtilities.getWindowAncestor(this).dispose();
    }

    public void setNote(String string) {
        this.noteLabel.setText(string);
        SwingUtilities.getWindowAncestor(this).pack();
    }

    public void setProgress(int n) {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setValue(n);
    }

    public void showDeterminateProgress(String string, String string2, int n, int n2) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
        this.commonProgressSetup(string, string2);
    }

    public boolean supportsIndeterminateProgress() {
        return true;
    }

    public void showIndeterminateProgress(String string, String string2) {
        this.progressBar.setIndeterminate(true);
        this.commonProgressSetup(string, string2);
    }

    protected void commonProgressSetup(String string, String string2) {
        this.progressLabel.setText(string);
        this.setNote(string2);
        SwingUtilities.getWindowAncestor(this).setVisible(true);
    }

    public boolean isShowingIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }
}

