/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import yajhfc.util.AlphaPanel;
import yajhfc.util.ProgressWorker;

public class ProgressPanel
extends JLayeredPane
implements ProgressWorker.ProgressUI {
    protected JPanel progressPanel = new JPanel(null, false);
    protected JProgressBar progressBar;
    protected JLabel progressLabel;
    protected JLabel noteLabel;
    protected JComponent contentComponent;
    protected AlphaPanel alphaPanel;
    protected static final int inset = 6;

    public JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public ProgressPanel() {
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.progressPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.progressPanel.setVisible(false);
        this.progressLabel = new JLabel("Doing something...");
        this.noteLabel = new JLabel();
        this.progressBar = new JProgressBar(0);
        this.progressPanel.add(this.progressLabel);
        this.progressPanel.add(this.noteLabel);
        this.progressPanel.add(Box.createVerticalStrut(6));
        this.progressPanel.add(this.progressBar);
        this.alphaPanel = new AlphaPanel();
        this.add((Component)this.progressPanel, JLayeredPane.MODAL_LAYER);
        this.add((Component)this.alphaPanel, JLayeredPane.MODAL_LAYER - 1);
        this.setLayout(new LayoutManager(){

            public void layoutContainer(Container container) {
                ProgressPanel.this.relayout();
            }

            public Dimension minimumLayoutSize(Container container) {
                return ProgressPanel.this.contentComponent.getMinimumSize();
            }

            public Dimension preferredLayoutSize(Container container) {
                return ProgressPanel.this.contentComponent.getPreferredSize();
            }

            public void removeLayoutComponent(Component component) {
            }

            public void addLayoutComponent(String string, Component component) {
            }
        });
    }

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    public void setContentComponent(JComponent jComponent) {
        if (this.contentComponent != null) {
            this.remove(this.contentComponent);
        }
        this.contentComponent = jComponent;
        this.add((Component)jComponent, JLayeredPane.DEFAULT_LAYER);
    }

    public void relayout() {
        this.relayout(this.isShowingProgress());
    }

    protected void relayout(boolean bl) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.contentComponent.setBounds(0, 0, n, n2);
        if (bl) {
            this.alphaPanel.setBounds(0, 0, n, n2);
            Dimension dimension = this.progressPanel.getPreferredSize();
            int n3 = (n - dimension.width) / 2;
            int n4 = (n2 - dimension.height) / 2;
            this.progressPanel.setBounds(n3, n4, dimension.width, dimension.height);
        }
    }

    public boolean supportsIndeterminateProgress() {
        return true;
    }

    public void showIndeterminateProgress(String string) {
        this.showIndeterminateProgress(string, null);
    }

    public void showIndeterminateProgress(String string, String string2) {
        this.progressBar.setIndeterminate(true);
        this.commonProgressSetup(string, string2);
    }

    protected void commonProgressSetup(String string, String string2) {
        this.progressLabel.setText(string);
        this.setNote(string2);
        if (!this.isShowingProgress()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.contentComponent.setEnabled(false);
            this.relayout(true);
            this.alphaPanel.setVisible(true);
            this.progressPanel.setVisible(true);
        }
    }

    public void hideProgress() {
        this.progressBar.setIndeterminate(false);
        this.progressPanel.setVisible(false);
        this.alphaPanel.setVisible(false);
        this.contentComponent.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isShowingProgress() {
        return this.progressPanel.isVisible();
    }

    public void close() {
        this.hideProgress();
    }

    public void setNote(String string) {
        if (string == null || string.length() == 0) {
            this.noteLabel.setText("");
            this.noteLabel.setVisible(false);
        } else {
            this.noteLabel.setText(string);
            this.noteLabel.setVisible(true);
        }
        if (this.isShowingProgress()) {
            this.relayout(true);
        }
    }

    public void setProgress(int n) {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setValue(n);
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void showDeterminateProgress(String string, String string2, int n, int n2) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
        this.commonProgressSetup(string, string2);
    }

    public boolean isShowingIndeterminate() {
        return this.progressBar.isIndeterminate();
    }
}

