/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ReplacerOutputStream
extends FilterOutputStream {
    private final byte[] bytesToReplace;
    private final byte[] replacement;
    private final byte[] searchBuf;
    private int searchBufPtr;
    private int searchBufLen;
    private static final int searchBufScale = 3;

    public ReplacerOutputStream(OutputStream outputStream, byte[] byArray, byte[] byArray2) {
        super(outputStream);
        this.bytesToReplace = byArray;
        this.replacement = byArray2;
        this.searchBuf = new byte[byArray.length * 3];
        this.searchBufPtr = 0;
        this.searchBufLen = 0;
    }

    public void flush() throws IOException {
        this.flushSearchBuf();
        this.out.flush();
    }

    private void flushSearchBuf() throws IOException {
        if (this.searchBufLen > 0) {
            this.writeFromSearchBuf(this.searchBufPtr - this.searchBufLen, this.searchBufLen);
            this.searchBufPtr = 0;
            this.searchBufLen = 0;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bytesToReplace.length;
        if (n2 <= 2 * n3) {
            this.writeSingleBytes(byArray, n, n2);
        } else {
            int n4;
            this.writeSingleBytes(byArray, n, n3);
            if (this.searchBufLen > n3) {
                this.searchBufLen -= n3;
                this.searchBufPtr = this.getBufPtr(this.searchBufPtr - n3);
                n4 = n;
                this.flushSearchBuf();
            } else {
                n4 = n + n3 - this.searchBufLen;
                this.searchBufLen = 0;
            }
            int n5 = n + n2 - n3;
            for (int i = n4; i < n5; ++i) {
                boolean bl = true;
                for (int j = 0; j < n3; ++j) {
                    if (byArray[i + j] == this.bytesToReplace[j]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (i > n4) {
                    this.out.write(byArray, n4, i - n4);
                }
                this.out.write(this.replacement);
                n4 = i += n3;
            }
            if (n4 < n5) {
                this.out.write(byArray, n4, n5 - n4);
            }
            this.writeSingleBytes(byArray, n5, n3);
        }
    }

    private void writeSingleBytes(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.write(byArray[i]);
        }
    }

    public void write(int n) throws IOException {
        int n2 = this.bytesToReplace.length;
        this.searchBuf[this.searchBufPtr] = (byte)n;
        this.searchBufPtr = this.getBufPtr(this.searchBufPtr + 1);
        if (this.searchBufLen < this.searchBuf.length) {
            ++this.searchBufLen;
        }
        if (this.searchBufLen >= n2) {
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                if (this.bytesToReplace[i] == this.searchBuf[this.getBufPtr(this.searchBufPtr - n2 + i)]) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (this.searchBufLen > n2) {
                    this.writeFromSearchBuf(this.getBufPtr(this.searchBufPtr - this.searchBufLen), this.searchBufLen - n2);
                }
                this.out.write(this.replacement);
                this.searchBufPtr = 0;
                this.searchBufLen = 0;
            } else if (this.searchBufLen == this.searchBuf.length) {
                this.searchBufLen = n2 - 1;
                this.writeFromSearchBuf(this.searchBufPtr, this.searchBuf.length - this.searchBufLen);
            }
        }
    }

    private int getBufPtr(int n) {
        int n2 = n % this.searchBuf.length;
        if (n2 < 0) {
            return this.searchBuf.length + n2;
        }
        return n2;
    }

    private void writeFromSearchBuf(int n, int n2) throws IOException {
        if ((n = this.getBufPtr(n)) + n2 < this.searchBuf.length) {
            this.out.write(this.searchBuf, n, n2);
        } else {
            int n3 = this.searchBuf.length - n;
            this.out.write(this.searchBuf, n, n3);
            this.out.write(this.searchBuf, 0, n2 - n3);
        }
    }
}

