/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import yajhfc.Utils;
import yajhfc.util.ActionToggleButton;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.fmtEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarEditorDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ToolbarEditorDialog.class.getName());
    private static final int border = 5;
    private static final String SEPARATOR_KEY = "---";
    private static final Action separatorAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    public static final Comparator<Action> actionComparator;
    fmtEditor<Action> fmtEditor;
    Action actOK;
    Action actReset;
    JToolBar toolBarToEdit;
    Map<String, Action> availableActions;
    List<Action> selected;
    String defConfig;
    private static final char SEP_CHAR = '|';

    public ToolbarEditorDialog(Frame frame, Map<String, Action> map, JToolBar jToolBar, String string) throws HeadlessException {
        super(frame);
        this.availableActions = map;
        this.toolBarToEdit = jToolBar;
        this.defConfig = string;
        this.initialize();
    }

    public ToolbarEditorDialog(Dialog dialog, Map<String, Action> map, JToolBar jToolBar, String string) throws HeadlessException {
        super(dialog);
        this.availableActions = map;
        this.toolBarToEdit = jToolBar;
        this.defConfig = string;
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Utils._("Customize toolbar"));
        this.setModal(true);
        this.setContentPane(this.createContentPane());
        this.setDefaultCloseOperation(2);
        this.setSize(640, 480);
        Utils.setDefWinPos(this);
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.createFmtEditor();
        this.actOK = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                ToolbarEditorDialog.saveToToolBar(ToolbarEditorDialog.this.toolBarToEdit, ToolbarEditorDialog.this.selected);
                ToolbarEditorDialog.this.dispose();
            }
        };
        this.actOK.putValue("Name", Utils._("OK"));
        this.actReset = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                ToolbarEditorDialog.this.fmtEditor.setNewSelection(ToolbarEditorDialog.parseStringToActionList(ToolbarEditorDialog.this.defConfig, ToolbarEditorDialog.this.availableActions));
            }
        };
        this.actReset.putValue("Name", Utils._("Reset"));
        Box box = Box.createHorizontalBox();
        CancelAction cancelAction = new CancelAction(this);
        box.add(Box.createHorizontalGlue());
        box.add(new JButton(this.actOK));
        box.add(Box.createHorizontalStrut(5));
        box.add(new JButton(this.actReset));
        box.add(Box.createHorizontalStrut(5));
        box.add(cancelAction.createCancelButton());
        box.add(Box.createHorizontalGlue());
        jPanel.add(this.fmtEditor, "Center");
        jPanel.add((Component)box, "South");
        return jPanel;
    }

    private fmtEditor<Action> createFmtEditor() {
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                Icon icon;
                String string2;
                Action action = (Action)object;
                if (action == null) {
                    string2 = "";
                    icon = null;
                    string = null;
                } else {
                    string2 = (String)action.getValue("Name");
                    icon = (Icon)action.getValue("SmallIcon");
                    string = (String)action.getValue("ShortDescription");
                }
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
                jLabel.setIcon(icon);
                jLabel.setToolTipText(string);
                return jLabel;
            }
        };
        this.selected = ToolbarEditorDialog.getActionsFromToolbar(this.toolBarToEdit);
        this.fmtEditor = new fmtEditor<Action>(this.availableActions.values(), this.selected, Collections.emptyList(), (ListCellRenderer)defaultListCellRenderer, actionComparator, separatorAction, Utils._("Selected toolbar buttons:"), Utils._("Available toolbar buttons:"));
        return this.fmtEditor;
    }

    static void saveToToolBar(JToolBar jToolBar, List<Action> list) {
        jToolBar.removeAll();
        for (Action action : list) {
            if (action != separatorAction) {
                if (action.getValue("selected") != null) {
                    ActionToggleButton actionToggleButton = new ActionToggleButton(action);
                    if (action.getValue("SmallIcon") != null) {
                        actionToggleButton.putClientProperty("hideActionText", Boolean.TRUE);
                        actionToggleButton.setText("");
                    }
                    jToolBar.add(actionToggleButton);
                    continue;
                }
                jToolBar.add(action);
                continue;
            }
            jToolBar.addSeparator();
        }
        jToolBar.repaint();
    }

    static List<Action> getActionsFromToolbar(JToolBar jToolBar) {
        ArrayList<Action> arrayList = new ArrayList<Action>(jToolBar.getComponentCount());
        for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
            Component component = jToolBar.getComponent(i);
            if (component instanceof AbstractButton) {
                Action action = ((AbstractButton)component).getAction();
                if (action == null) continue;
                arrayList.add(action);
                continue;
            }
            if (component instanceof JSeparator) {
                arrayList.add(separatorAction);
                continue;
            }
            log.info("Unknown toolbar component: " + component + " (" + component.getClass() + ")");
        }
        return arrayList;
    }

    static List<Action> parseStringToActionList(String string, Map<String, Action> map) {
        String[] stringArray = Utils.fastSplit(string, '|');
        ArrayList<Action> arrayList = new ArrayList<Action>(stringArray.length);
        for (String string2 : stringArray) {
            if (string2.equals(SEPARATOR_KEY)) {
                arrayList.add(separatorAction);
                continue;
            }
            Action action = map.get(string2);
            if (action != null) {
                arrayList.add(action);
                continue;
            }
            log.warning("No action found for key " + string2);
        }
        return arrayList;
    }

    public static String saveConfigToString(JToolBar jToolBar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Action action : ToolbarEditorDialog.getActionsFromToolbar(jToolBar)) {
            stringBuilder.append(action.getValue("ActionCommandKey")).append('|');
        }
        return stringBuilder.toString();
    }

    public static void loadConfigFromString(JToolBar jToolBar, String string, Map<String, Action> map) {
        ToolbarEditorDialog.saveToToolBar(jToolBar, ToolbarEditorDialog.parseStringToActionList(string, map));
    }

    static {
        separatorAction.putValue("ActionCommandKey", SEPARATOR_KEY);
        separatorAction.putValue("Name", SEPARATOR_KEY);
        separatorAction.putValue("ShortDescription", Utils._("Separator"));
        actionComparator = new Comparator<Action>(){

            @Override
            public int compare(Action action, Action action2) {
                String string;
                String string2 = action != null ? (String)action.getValue("Name") : null;
                String string3 = string = action2 != null ? (String)action2.getValue("Name") : null;
                if (string2 == null) {
                    return string == null ? 0 : -1;
                }
                if (string == null) {
                    return 1;
                }
                return string2.compareToIgnoreCase(string);
            }
        };
    }
}

