/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util.pipe.win32;

import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import yajhfc.util.pipe.win32.MyKernel32;

class Win32NamedPipe {
    private static final int TIMEOUT = 0;
    private static final int BUFSIZE = 4096;
    protected WinNT.HANDLE hPipe;
    protected boolean connected = false;

    protected Win32NamedPipe(String string, int n) throws IOException {
        this.openPipe(string, n);
    }

    private void openPipe(String string, int n) throws IOException {
        this.hPipe = MyKernel32.INSTANCE.CreateNamedPipe(string, n, 0, 255, 4096, 4096, 0, null);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)this.hPipe)) {
            this.hPipe = null;
            Win32NamedPipe.throwIOException("CreateNamedPipe failed");
        }
    }

    public boolean ensureConnected() throws IOException {
        if (this.connected) {
            return false;
        }
        this.checkOpen();
        if (MyKernel32.INSTANCE.ConnectNamedPipe(this.hPipe, null)) {
            this.connected = true;
            return true;
        }
        int n = MyKernel32.INSTANCE.GetLastError();
        if (n == 535) {
            this.connected = true;
            return false;
        }
        MyKernel32.INSTANCE.CloseHandle(this.hPipe);
        this.hPipe = null;
        Win32NamedPipe.throwIOException("ConnectNamedPipe failed", n);
        return false;
    }

    protected void checkOpen() throws IOException {
        if (this.hPipe == null) {
            throw new IOException("The pipe has already been closed");
        }
    }

    public void close() {
        if (this.hPipe == null) {
            return;
        }
        if (this.connected) {
            MyKernel32.INSTANCE.DisconnectNamedPipe(this.hPipe);
            this.connected = false;
        }
        MyKernel32.INSTANCE.CloseHandle(this.hPipe);
        this.hPipe = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static void throwIOException(String string) throws IOException {
        Win32NamedPipe.throwIOException(string, MyKernel32.INSTANCE.GetLastError());
    }

    static void throwIOException(String string, int n) throws IOException {
        char[] cArray = new char[512];
        int n2 = MyKernel32.INSTANCE.FormatMessage(4096, null, n, 0, cArray, cArray.length, null);
        String string2 = n2 > 0 ? new String(cArray, 0, n2).trim() : "<Unknown>";
        throw new IOException(string + " (GetLastError=" + n + ": " + string2 + ")");
    }
}

