/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util.pipe.win32;

import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import yajhfc.util.pipe.win32.MyKernel32;
import yajhfc.util.pipe.win32.Win32NamedPipe;

public class Win32NamedPipeInputStream
extends InputStream {
    public static final String LOCAL_PIPE_PREFIX = "\\\\.\\pipe\\";
    protected final Win32NamedPipe pipe;
    protected ByteBuffer singleByteBuf;
    protected final IntByReference bytesRead = new IntByReference();
    private byte[] lastB = null;
    private ByteBuffer lastBuf = null;

    public Win32NamedPipeInputStream(String string) throws IOException {
        this.pipe = new Win32NamedPipe(string, 1);
    }

    public int read() throws IOException {
        int n;
        if (this.singleByteBuf == null) {
            this.singleByteBuf = ByteBuffer.allocate(1);
        }
        if ((n = this.read(this.singleByteBuf)) < 0) {
            return -1;
        }
        return this.singleByteBuf.get(0) & 0xFF;
    }

    private ByteBuffer getBuffer(byte[] byArray, int n, int n2) {
        if (byArray == this.lastB) {
            this.lastBuf.position(n);
            this.lastBuf.limit(n + n2);
            return this.lastBuf;
        }
        this.lastB = byArray;
        this.lastBuf = ByteBuffer.wrap(byArray, n, n2);
        return this.lastBuf;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(this.getBuffer(byArray, n, n2));
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        this.pipe.ensureConnected();
        boolean bl = MyKernel32.INSTANCE.ReadFile(this.pipe.hPipe, byteBuffer, byteBuffer.limit() - byteBuffer.position(), this.bytesRead, null);
        if (bl) {
            int n = this.bytesRead.getValue();
            if (n == 0) {
                return -1;
            }
            return n;
        }
        int n = MyKernel32.INSTANCE.GetLastError();
        if (n == 109) {
            return -1;
        }
        Win32NamedPipe.throwIOException("ReadFile failed", n);
        return -2;
    }

    public void close() throws IOException {
        this.pipe.close();
        this.lastBuf = null;
        this.lastB = null;
    }
}

