/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.virtualcolumnstore;

import java.util.EnumMap;
import java.util.Map;
import yajhfc.model.VirtualColumnType;
import yajhfc.virtualcolumnstore.VirtColPersister;

public abstract class CachingVirtColPersister
extends VirtColPersister {
    protected Map<VirtualColumnType, Integer> columnMap;
    protected Map<String, Object[]> data;
    protected boolean dirty = false;

    public CachingVirtColPersister() {
        this.buildColumnMap();
    }

    protected abstract void checkInitialized();

    public void prepareValues() {
        this.checkInitialized();
    }

    protected VirtualColumnType[] getReverseMap() {
        VirtualColumnType[] virtualColumnTypeArray = new VirtualColumnType[this.columnMap.size()];
        for (Map.Entry<VirtualColumnType, Integer> entry : this.columnMap.entrySet()) {
            virtualColumnTypeArray[entry.getValue().intValue()] = entry.getKey();
        }
        return virtualColumnTypeArray;
    }

    protected int columnToIndex(VirtualColumnType virtualColumnType) {
        return this.columnMap.get((Object)virtualColumnType);
    }

    public synchronized Object getValue(String string, VirtualColumnType virtualColumnType) {
        this.checkInitialized();
        Object[] objectArray = this.data.get(string);
        if (objectArray == null) {
            return null;
        }
        return objectArray[this.columnToIndex(virtualColumnType)];
    }

    public synchronized void setValue(String string, VirtualColumnType virtualColumnType, Object object) {
        int n;
        Object object2;
        this.checkInitialized();
        Object[] objectArray = this.data.get(string);
        if (objectArray == null) {
            objectArray = this.allocateKeyData();
        }
        if (!(object == (object2 = objectArray[n = this.columnToIndex(virtualColumnType)]) || object2 != null && object2.equals(object))) {
            objectArray[n] = object;
            this.data.put(string, objectArray);
            this.dirty = true;
            this.valueChanged(string, virtualColumnType, n, object, object2);
        }
    }

    protected void valueChanged(String string, VirtualColumnType virtualColumnType, int n, Object object, Object object2) {
    }

    protected Object[] allocateKeyData() {
        return new Object[this.columnMap.size()];
    }

    private void buildColumnMap() {
        this.columnMap = new EnumMap<VirtualColumnType, Integer>(VirtualColumnType.class);
        for (VirtualColumnType virtualColumnType : VirtualColumnType.values()) {
            if (!virtualColumnType.isSaveable()) continue;
            this.columnMap.put(virtualColumnType, this.columnMap.size());
        }
    }
}

