/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.virtualcolumnstore;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import yajhfc.Password;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.model.VirtualColumnType;
import yajhfc.phonebook.AbstractConnectionSettings;
import yajhfc.phonebook.jdbc.ConnectionDialog;
import yajhfc.plugin.PluginManager;
import yajhfc.util.DoNotAskAgainDialog;
import yajhfc.virtualcolumnstore.AvailablePersistenceMethod;
import yajhfc.virtualcolumnstore.CachingVirtColPersister;
import yajhfc.virtualcolumnstore.VirtColChangeListener;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCVirtColPersister
extends CachingVirtColPersister {
    static final Logger log = Logger.getLogger(JDBCVirtColPersister.class.getName());
    protected ConnectionSettings settings;
    protected Connection connection;
    protected PreparedStatement selectStmt;
    protected PreparedStatement updateStmt;
    protected PreparedStatement insertStmt;
    protected PreparedStatement lmtsStmt;
    protected int updateStmtKeyIdx;
    protected int insertStmtKeyIdx;
    protected int[] updateStmtVTCIdx;
    protected int[] insertStmtVTCIdx;
    protected ColumnMetaData[] columnMetaData;
    protected long lastLastModified;
    protected ScheduledFuture<?> updateTask;
    protected List<VirtColChangeListener> listeners = new ArrayList<VirtColChangeListener>();
    protected static final Map<String, ConnectionDialog.FieldMapEntry> fieldCaptionMap = new HashMap<String, ConnectionDialog.FieldMapEntry>();
    public static int COMPARE_MAP_INSERT;
    public static int COMPARE_MAP_UPDATE;
    public static int COMPARE_MAP_DELETE;

    @Override
    public void shutdown() {
        this.disconnect();
    }

    @Override
    public void persistValues() {
    }

    @Override
    public synchronized void addVirtColChangeListener(VirtColChangeListener virtColChangeListener) {
        this.listeners.add(virtColChangeListener);
    }

    @Override
    public synchronized void removeVirtColChangeListener(VirtColChangeListener virtColChangeListener) {
        this.listeners.remove(virtColChangeListener);
    }

    protected synchronized void fireColumnsChanged(Set<String> set, Set<String> set2, Set<String> set3) {
        for (VirtColChangeListener virtColChangeListener : this.listeners) {
            virtColChangeListener.columnsChanged(set, set2, set3);
        }
    }

    @Override
    public synchronized void cleanupState(Collection<String> collection) {
        if (collection.size() == 0 || this.connection == null) {
            log.info("cleanupState called with empty list or closed connection");
            return;
        }
        try {
            String string = "DELETE FROM " + this.settings.table + "WHERE " + this.settings.getKeyFieldName() + " = ?";
            if (Utils.debugMode) {
                log.fine("DELETE statement: " + string);
            }
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            for (String string2 : this.data.keySet()) {
                if (collection.contains(string2)) continue;
                if (Utils.debugMode) {
                    log.fine("Deleting key " + string2);
                }
                preparedStatement.setString(1, string2);
                preparedStatement.execute();
                if (!Utils.debugMode) continue;
                log.fine("" + preparedStatement.getUpdateCount() + " rows deleted");
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.WARNING, "Error cleaning up", sQLException);
        }
    }

    @Override
    protected synchronized void checkInitialized() {
        if (this.data == null) {
            try {
                this.data = this.loadValues(true);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error loading data ", exception);
                this.data = new HashMap();
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    JDBCVirtColPersister.this.checkForUpdates();
                }
            };
            this.updateTask = Utils.executorService.scheduleAtFixedRate(runnable, Utils.getFaxOptions().statusUpdateInterval, Utils.getFaxOptions().statusUpdateInterval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void openConnection() throws ClassNotFoundException, SQLException {
        void objectArray2;
        String string;
        String string22;
        String string3;
        Object[] objectArray;
        if (Utils.debugMode) {
            log.fine(String.format("Connecting: driver=%s, URL=%s, username=%s, askForPassword=%s", this.settings.driver, this.settings.dbURL, this.settings.user, this.settings.askForPWD));
        }
        PluginManager.registerJDBCDriver(this.settings.driver);
        if (this.settings.askForPWD) {
            objectArray = Launcher2.application.getDialogUI().showPasswordDialog(Utils._("Database password"), MessageFormat.format(Utils._("Please enter the database password (database: {0}):"), this.settings.dbURL), this.settings.user, false);
            if (objectArray == null) {
                return;
            }
            string3 = objectArray[1];
        } else {
            string3 = this.settings.pwd.getPassword();
        }
        this.connection = DriverManager.getConnection(this.settings.dbURL, this.settings.user, string3);
        this.connection.setAutoCommit(true);
        objectArray = VirtualColumnType.values();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.haveLastModified();
        stringBuilder.append("SELECT ");
        stringBuilder.append(this.settings.getKeyFieldName());
        for (String string22 : objectArray) {
            if (!((VirtualColumnType)((Object)string22)).isSaveable() || ConnectionSettings.isNoField(string = this.settings.getFieldNameForVirtualColumnType((VirtualColumnType)((Object)string22)))) continue;
            stringBuilder.append(", ").append(string);
        }
        if (bl) {
            stringBuilder.append(", ").append(this.settings.lastModifiedField);
        }
        stringBuilder.append("\nFROM ").append(this.settings.table);
        if (Utils.debugMode) {
            log.fine("SELECT statement: " + stringBuilder);
        }
        this.selectStmt = this.connection.prepareStatement(stringBuilder.toString());
        this.lastLastModified = -1L;
        if (bl) {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT ").append("max(");
            stringBuilder.append(this.settings.lastModifiedField);
            stringBuilder.append(')');
            stringBuilder.append("\nFROM ").append(this.settings.table);
            if (Utils.debugMode) {
                log.fine("max last modified SELECT statement: " + stringBuilder);
            }
            this.lmtsStmt = this.connection.prepareStatement(stringBuilder.toString());
        } else {
            this.lmtsStmt = null;
        }
        stringBuilder.setLength(0);
        this.insertStmtVTCIdx = new int[objectArray.length];
        stringBuilder.append("INSERT INTO ").append(this.settings.table);
        stringBuilder.append('(').append(this.settings.getKeyFieldName());
        this.insertStmtKeyIdx = 1;
        int n = 2;
        boolean i = false;
        while (objectArray2 < objectArray.length) {
            String string4;
            String string5 = objectArray[objectArray2];
            this.insertStmtVTCIdx[objectArray2] = -1;
            if (((VirtualColumnType)((Object)string5)).isSaveable() && !ConnectionSettings.isNoField(string4 = this.settings.getFieldNameForVirtualColumnType((VirtualColumnType)((Object)string5)))) {
                stringBuilder.append(", ").append(string4);
                this.insertStmtVTCIdx[objectArray2] = n++;
            }
            ++objectArray2;
        }
        if (bl) {
            stringBuilder.append(", ").append(this.settings.lastModifiedField);
        }
        stringBuilder.append(")\n VALUES (?");
        Object[] bl2 = objectArray;
        int n2 = bl2.length;
        for (int string6 = 0; string6 < n2; ++string6) {
            string22 = bl2[string6];
            if (!((VirtualColumnType)((Object)string22)).isSaveable() || ConnectionSettings.isNoField(string = this.settings.getFieldNameForVirtualColumnType((VirtualColumnType)((Object)string22)))) continue;
            stringBuilder.append(", ?");
        }
        if (bl) {
            stringBuilder.append(", ").append("current_timestamp");
        }
        stringBuilder.append(')');
        if (Utils.debugMode) {
            log.fine("INSERT statement: " + stringBuilder);
        }
        this.insertStmt = this.connection.prepareStatement(stringBuilder.toString());
        stringBuilder.setLength(0);
        this.updateStmtVTCIdx = new int[objectArray.length];
        stringBuilder.append("UPDATE ").append(this.settings.table);
        stringBuilder.append("\nSET ");
        boolean bl3 = true;
        n = 1;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            boolean bl4;
            String string6 = objectArray[n2];
            this.updateStmtVTCIdx[n2] = -1;
            if (!((VirtualColumnType)((Object)string6)).isSaveable() || ConnectionSettings.isNoField(string22 = this.settings.getFieldNameForVirtualColumnType((VirtualColumnType)((Object)string6)))) continue;
            if (bl4) {
                bl4 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string22).append(" = ?");
            this.updateStmtVTCIdx[n2] = n++;
        }
        if (bl) {
            stringBuilder.append(", ").append(this.settings.lastModifiedField).append(" = current_timestamp");
        }
        stringBuilder.append("\nWHERE ").append(this.settings.getKeyFieldName()).append(" = ?");
        this.updateStmtKeyIdx = n;
        if (Utils.debugMode) {
            log.fine("UPDATE statement: " + stringBuilder);
        }
        this.updateStmt = this.connection.prepareStatement(stringBuilder.toString());
        if (ConnectionSettings.isNoField(this.settings.getFieldNameForVirtualColumnType(VirtualColumnType.USER_COMMENT))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DoNotAskAgainDialog.showMessageDialog(JDBCVirtColPersister.class.getName() + ".CommentUnset", Launcher2.application.getFrame(), MessageFormat.format(Utils._("No database field is set to save column \"User comment\". Values will be lost after restart.\nPlease see {0} for more information."), "http://www.yajhfc.de/documentation/knowledge-base/152-database-migration-to-0-6-0"), Utils._("User comment"), 2);
                }
            });
        }
    }

    protected boolean haveLastModified() {
        return !ConnectionSettings.isNoField(this.settings.lastModifiedField);
    }

    protected synchronized void disconnect() {
        if (this.updateTask != null) {
            this.updateTask.cancel(false);
            this.updateTask = null;
        }
        if (this.connection != null) {
            try {
                this.selectStmt.close();
                if (this.lmtsStmt != null) {
                    this.lmtsStmt.close();
                }
                this.insertStmt.close();
                this.updateStmt.close();
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Could not close statement", sQLException);
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Could not close database connection", sQLException);
            }
            this.selectStmt = null;
            this.lmtsStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkLastModified() throws SQLException, ClassNotFoundException {
        if (this.connection == null) {
            this.openConnection();
        }
        log.fine("Checking last modified timestamp...");
        ResultSet resultSet = this.lmtsStmt.executeQuery();
        if (resultSet.next()) {
            Timestamp timestamp = resultSet.getTimestamp(1);
            if (Utils.debugMode) {
                log.fine("Last modified timestamp: " + timestamp);
            }
            if (timestamp == null) {
                return true;
            }
            long l = timestamp.getTime();
            JDBCVirtColPersister jDBCVirtColPersister = this;
            synchronized (jDBCVirtColPersister) {
                if (Utils.debugMode) {
                    log.fine("Last modified: old: " + this.lastLastModified + "; new: " + l);
                }
                return l != this.lastLastModified;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object[]> loadValues(boolean bl) throws SQLException, ClassNotFoundException {
        Object object;
        if (this.connection == null) {
            this.openConnection();
        }
        log.fine("Querying database table...");
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        ResultSet resultSet = this.selectStmt.executeQuery();
        int n = resultSet.findColumn(this.settings.getKeyFieldName());
        int n2 = -1;
        if (this.haveLastModified()) {
            n2 = resultSet.findColumn(this.settings.lastModifiedField);
        }
        VirtualColumnType[] virtualColumnTypeArray = VirtualColumnType.values();
        int[] nArray = new int[virtualColumnTypeArray.length];
        ResultSetMetaData resultSetMetaData = null;
        if (bl) {
            resultSetMetaData = resultSet.getMetaData();
            this.columnMetaData = new ColumnMetaData[virtualColumnTypeArray.length];
        }
        for (int i = 0; i < virtualColumnTypeArray.length; ++i) {
            VirtualColumnType virtualColumnType = virtualColumnTypeArray[i];
            nArray[i] = -1;
            if (!virtualColumnType.isSaveable() || ConnectionSettings.isNoField((String)(object = this.settings.getFieldNameForVirtualColumnType(virtualColumnType)))) continue;
            int n3 = nArray[i] = resultSet.findColumn((String)object);
            if (!bl) continue;
            this.columnMetaData[i] = new ColumnMetaData(resultSetMetaData, n3);
        }
        if (Utils.debugMode) {
            log.fine("keyIdx=" + n + "; vtcIdx=" + Arrays.toString(nArray));
        }
        long l = -1L;
        while (resultSet.next()) {
            long l2;
            Timestamp timestamp;
            object = resultSet.getString(n);
            Object[] objectArray = this.allocateKeyData();
            for (int i = 0; i < virtualColumnTypeArray.length; ++i) {
                Object object2;
                int n4 = nArray[i];
                if (n4 < 0) continue;
                VirtualColumnType virtualColumnType = virtualColumnTypeArray[i];
                Class<?> clazz = virtualColumnType.getDataType();
                if (clazz == String.class) {
                    object2 = resultSet.getString(n4);
                } else if (clazz == Boolean.class) {
                    object2 = resultSet.getBoolean(n4);
                } else if (clazz == Integer.class) {
                    object2 = resultSet.getInt(n4);
                } else if (clazz == Long.class) {
                    object2 = resultSet.getLong(n4);
                } else {
                    log.warning("Unsupported data type: " + clazz);
                    object2 = resultSet.getObject(n4);
                }
                if (resultSet.wasNull()) {
                    object2 = null;
                }
                objectArray[this.columnToIndex((VirtualColumnType)virtualColumnType)] = object2;
            }
            hashMap.put((String)object, objectArray);
            if (n2 < 0 || (timestamp = resultSet.getTimestamp(n2)) == null || (l2 = timestamp.getTime()) <= l) continue;
            l = l2;
        }
        resultSet.close();
        object = this;
        synchronized (object) {
            this.lastLastModified = l;
        }
        return hashMap;
    }

    private void setStatementValues(PreparedStatement preparedStatement, int n, int[] nArray, String string, Object[] objectArray) throws SQLException {
        if (Utils.debugMode) {
            log.finer("keyIdx=" + n + "; vtcIdx=" + Arrays.toString(nArray) + "; key=" + string + "; keyData=" + Arrays.toString(objectArray));
        }
        preparedStatement.setString(n, string);
        VirtualColumnType[] virtualColumnTypeArray = VirtualColumnType.values();
        for (int i = 0; i < virtualColumnTypeArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 0) continue;
            VirtualColumnType virtualColumnType = virtualColumnTypeArray[i];
            Class<?> clazz = virtualColumnType.getDataType();
            Object object = objectArray[this.columnToIndex(virtualColumnType)];
            ColumnMetaData columnMetaData = this.columnMetaData[i];
            if (clazz == String.class) {
                if (object == null) {
                    if (columnMetaData.nullable) {
                        preparedStatement.setNull(n2, columnMetaData.type);
                        continue;
                    }
                    preparedStatement.setString(n2, "");
                    continue;
                }
                String string2 = (String)object;
                if (columnMetaData.length > 0 && string2.length() > columnMetaData.length) {
                    string2 = string2.substring(0, columnMetaData.length);
                }
                preparedStatement.setString(n2, string2);
                continue;
            }
            if (clazz == Boolean.class) {
                if (object == null) {
                    if (columnMetaData.nullable) {
                        preparedStatement.setNull(n2, columnMetaData.type);
                        continue;
                    }
                    preparedStatement.setBoolean(n2, false);
                    continue;
                }
                preparedStatement.setBoolean(n2, (Boolean)object);
                continue;
            }
            if (clazz == Integer.class) {
                if (object == null) {
                    if (columnMetaData.nullable) {
                        preparedStatement.setNull(n2, columnMetaData.type);
                        continue;
                    }
                    preparedStatement.setInt(n2, -1);
                    continue;
                }
                preparedStatement.setInt(n2, (Integer)object);
                continue;
            }
            if (clazz == Long.class) {
                if (object == null) {
                    if (columnMetaData.nullable) {
                        preparedStatement.setNull(n2, columnMetaData.type);
                        continue;
                    }
                    preparedStatement.setLong(n2, -1L);
                    continue;
                }
                preparedStatement.setLong(n2, (Long)object);
                continue;
            }
            log.warning("Unsupported data type: " + clazz);
            preparedStatement.setObject(n2, object);
        }
        if (Utils.debugMode) {
            log.finer(preparedStatement.toString());
        }
    }

    protected synchronized void writeSingleRow(String string, Object[] objectArray) throws SQLException {
        if (Utils.debugMode) {
            log.fine("Trying UPDATE for key " + string);
        }
        this.setStatementValues(this.updateStmt, this.updateStmtKeyIdx, this.updateStmtVTCIdx, string, objectArray);
        this.updateStmt.execute();
        int n = this.updateStmt.getUpdateCount();
        if (Utils.debugMode) {
            log.fine("Updated " + n + " columns");
        }
        if (n == 0) {
            log.fine("0 columns updated, trying INSERT");
            this.setStatementValues(this.insertStmt, this.insertStmtKeyIdx, this.insertStmtVTCIdx, string, objectArray);
            this.insertStmt.execute();
            n = this.insertStmt.getUpdateCount();
            if (Utils.debugMode) {
                log.fine("Inserted " + n + " columns");
            }
        }
    }

    @Override
    protected void valueChanged(final String string, VirtualColumnType virtualColumnType, int n, Object object, Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            Utils.executorService.schedule(new Runnable(){

                public void run() {
                    JDBCVirtColPersister.this.realValueChanged(string);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        } else {
            this.realValueChanged(string);
        }
    }

    protected synchronized void realValueChanged(String string) {
        try {
            this.writeSingleRow(string, (Object[])this.data.get(string));
        }
        catch (SQLException sQLException) {
            log.log(Level.WARNING, "Error saving data for key " + string, sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForUpdates() {
        try {
            log.fine("Checking for updates on the DB...");
            if (this.haveLastModified() && !this.checkLastModified()) {
                return;
            }
            log.fine("No last modified or modification found, doing full diff...");
            Map<String, Object[]> map = this.loadValues(false);
            JDBCVirtColPersister jDBCVirtColPersister = this;
            synchronized (jDBCVirtColPersister) {
                Map<String, Object[]>[] mapArray = JDBCVirtColPersister.compareMaps(this.data, map);
                if (mapArray[COMPARE_MAP_INSERT].size() > 0 || mapArray[COMPARE_MAP_UPDATE].size() > 0 || mapArray[COMPARE_MAP_DELETE].size() > 0) {
                    log.fine("Differences found");
                    if (Utils.debugMode) {
                        log.finer("Inserts: " + mapArray[COMPARE_MAP_INSERT].keySet());
                        log.finer("Updates: " + mapArray[COMPARE_MAP_UPDATE].keySet());
                        log.finer("Deletes: " + mapArray[COMPARE_MAP_DELETE].keySet());
                    }
                    if (mapArray[COMPARE_MAP_DELETE].size() > 0) {
                        for (String object : mapArray[COMPARE_MAP_DELETE].keySet()) {
                            this.data.remove(object);
                        }
                    }
                    if (mapArray[COMPARE_MAP_UPDATE].size() > 0) {
                        for (Map.Entry entry : mapArray[COMPARE_MAP_UPDATE].entrySet()) {
                            this.data.put(entry.getKey(), entry.getValue());
                        }
                    }
                    if (mapArray[COMPARE_MAP_INSERT].size() > 0) {
                        for (Map.Entry entry : mapArray[COMPARE_MAP_INSERT].entrySet()) {
                            this.data.put(entry.getKey(), entry.getValue());
                        }
                    }
                    this.fireColumnsChanged(mapArray[COMPARE_MAP_INSERT].keySet(), mapArray[COMPARE_MAP_UPDATE].keySet(), mapArray[COMPARE_MAP_DELETE].keySet());
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error checking for updates", exception);
        }
    }

    public static Map<String, Object[]>[] compareMaps(Map<String, Object[]> map, Map<String, Object[]> map2) {
        String string;
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        HashMap<String, Object[]> hashMap2 = new HashMap<String, Object[]>(map.size());
        HashMap<String, Object[]> hashMap3 = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> entry : map2.entrySet()) {
            string = entry.getKey();
            Object[] objectArray = map.get(string);
            if (objectArray != null) {
                Object[] objectArray2 = entry.getValue();
                if (Arrays.equals(objectArray, objectArray2)) continue;
                hashMap2.put(string, objectArray2);
                continue;
            }
            hashMap.put(string, entry.getValue());
        }
        for (Map.Entry<String, Object[]> entry : map.entrySet()) {
            string = entry.getKey();
            if (map2.containsKey(string)) continue;
            hashMap3.put(string, entry.getValue());
        }
        return new Map[]{hashMap, hashMap2, hashMap3};
    }

    public JDBCVirtColPersister(ConnectionSettings connectionSettings) {
        this.settings = connectionSettings;
    }

    static {
        fieldCaptionMap.put("faxNameField", new ConnectionDialog.FieldMapEntry(Utils._("Key (fax filename):"), 0));
        fieldCaptionMap.put("isReadField", new ConnectionDialog.FieldMapEntry(Utils._("Read/Unread state:"), 1));
        fieldCaptionMap.put("commentField", new ConnectionDialog.FieldMapEntry(Utils._("Comment:"), 2));
        fieldCaptionMap.put("lastModifiedField", new ConnectionDialog.FieldMapEntry(Utils._("Last modified:"), 3));
        COMPARE_MAP_INSERT = 0;
        COMPARE_MAP_UPDATE = 1;
        COMPARE_MAP_DELETE = 2;
    }

    static class PersistenceMethod
    implements AvailablePersistenceMethod {
        PersistenceMethod() {
        }

        public boolean canConfigure() {
            return true;
        }

        public VirtColPersister createInstance(String string, int n) {
            return new JDBCVirtColPersister(new ConnectionSettings(string));
        }

        public String getDescription() {
            return Utils._("Database table");
        }

        public String getKey() {
            return "jdbc";
        }

        public String toString() {
            return this.getDescription();
        }

        public String showConfigDialog(Window window, String string) {
            ConnectionDialog connectionDialog;
            String string2 = Utils._("JDBC settings to save read/unread state and comment");
            String string3 = Utils._("Please select which database fields correspond to the key, read/unread state and comment");
            ConnectionSettings connectionSettings = new ConnectionSettings(string);
            if (window instanceof Dialog) {
                connectionDialog = new ConnectionDialog((Dialog)window, string2, string3, fieldCaptionMap, false);
            } else if (window instanceof Frame) {
                connectionDialog = new ConnectionDialog((Frame)window, string2, string3, fieldCaptionMap, false);
            } else {
                throw new IllegalArgumentException("parent must be a Dialog or a Frame!");
            }
            if (connectionDialog.promptForNewSettings(connectionSettings)) {
                return connectionSettings.saveToString();
            }
            return null;
        }
    }

    public static class ConnectionSettings
    extends AbstractConnectionSettings {
        public String driver = "";
        public String dbURL = "jdbc:";
        public String user = "";
        public final Password pwd = new Password();
        public boolean askForPWD = false;
        public String table = "";
        public String faxNameField = "";
        public String isReadField = "";
        public String commentField = "";
        public String lastModifiedField = "";

        public String getFieldNameForVirtualColumnType(VirtualColumnType virtualColumnType) {
            switch (virtualColumnType) {
                case READ: {
                    return this.isReadField;
                }
                case USER_COMMENT: {
                    return this.commentField;
                }
            }
            log.severe("Unknown column type " + virtualColumnType.name());
            return null;
        }

        public String getKeyFieldName() {
            return this.faxNameField;
        }

        public ConnectionSettings() {
        }

        public ConnectionSettings(ConnectionSettings connectionSettings) {
            this.copyFrom(connectionSettings);
        }

        public ConnectionSettings(String string) {
            this.loadFromString(string);
        }
    }

    static class ColumnMetaData {
        public final String columnName;
        public final int type;
        public final int length;
        public final boolean nullable;

        public ColumnMetaData(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
            this.columnName = resultSetMetaData.getColumnName(n);
            this.type = resultSetMetaData.getColumnType(n);
            this.length = resultSetMetaData.getPrecision(n);
            this.nullable = resultSetMetaData.isNullable(n) == 1;
        }

        public ColumnMetaData(String string, int n, int n2, boolean bl) {
            this.columnName = string;
            this.type = n;
            this.length = n2;
            this.nullable = bl;
        }
    }
}

