/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.virtualcolumnstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.server.ServerOptions;
import yajhfc.virtualcolumnstore.AvailablePersistenceMethod;
import yajhfc.virtualcolumnstore.JDBCVirtColPersister;
import yajhfc.virtualcolumnstore.LocalVirtColPersister;
import yajhfc.virtualcolumnstore.VirtColChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtColPersister {
    static final Logger log = Logger.getLogger(VirtColPersister.class.getName());
    protected static final String KEY_PREFIX_QUEUE = "/Q/";
    private static AvailablePersistenceMethod DEFAULT_METHOD;
    public static final List<AvailablePersistenceMethod> persistenceMethods;

    public abstract void shutdown();

    public abstract void persistValues();

    public abstract void addVirtColChangeListener(VirtColChangeListener var1);

    public abstract void removeVirtColChangeListener(VirtColChangeListener var1);

    public abstract void cleanupState(Collection<String> var1);

    public <T extends FmtItem> void cleanupStateFromJobs(Collection<FaxJob<T>> ... collectionArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Collection<FaxJob<T>> collection : collectionArray) {
            for (FaxJob<T> faxJob : collection) {
                hashSet.add(VirtColPersister.getKeyForFaxJob(faxJob));
            }
        }
        this.cleanupState(hashSet);
    }

    public abstract void prepareValues();

    public static String getKeyForFaxJob(FaxJob<? extends FmtItem> faxJob) {
        switch (faxJob.getParent().getJobType()) {
            case RECEIVED: {
                return faxJob.getIDValue().toString();
            }
            case SENT: 
            case SENDING: 
            case ARCHIVE: {
                return KEY_PREFIX_QUEUE + faxJob.getIDValue();
            }
        }
        assert (false) : "Should never happen!";
        return "N/A";
    }

    public static Object parseKey(String string) {
        if (string.startsWith(KEY_PREFIX_QUEUE)) {
            return Integer.valueOf(string.substring(KEY_PREFIX_QUEUE.length()));
        }
        return string;
    }

    public <T extends FmtItem> void updateToFaxJob(FaxJob<T> faxJob, boolean bl) {
        String string = VirtColPersister.getKeyForFaxJob(faxJob);
        for (Map.Entry<VirtualColumnType, Integer> entry : faxJob.getParent().getColumns().getVirtualColumnIndexes().entrySet()) {
            VirtualColumnType virtualColumnType = entry.getKey();
            if (!virtualColumnType.isSaveable()) continue;
            faxJob.setData(entry.getValue(), this.getValue(string, virtualColumnType), bl);
        }
    }

    public <T extends FmtItem> void updateToAllFaxJobs(Collection<FaxJob<T>> collection, boolean bl) {
        for (FaxJob<T> faxJob : collection) {
            this.updateToFaxJob(faxJob, bl);
        }
    }

    public <T extends FmtItem> void updateFromFaxJob(FaxJob<T> faxJob) {
        String string = VirtColPersister.getKeyForFaxJob(faxJob);
        for (Map.Entry<VirtualColumnType, Integer> entry : faxJob.getParent().getColumns().getVirtualColumnIndexes().entrySet()) {
            VirtualColumnType virtualColumnType = entry.getKey();
            if (!virtualColumnType.isSaveable()) continue;
            this.setValue(string, virtualColumnType, faxJob.getData(entry.getValue()));
        }
    }

    public <T extends FmtItem> void updateFromAllFaxJobs(Collection<FaxJob<T>> collection) {
        for (FaxJob<T> faxJob : collection) {
            this.updateFromFaxJob(faxJob);
        }
    }

    public Object getValue(FaxJob<? extends FmtItem> faxJob, VirtualColumnType virtualColumnType) {
        return this.getValue(VirtColPersister.getKeyForFaxJob(faxJob), virtualColumnType);
    }

    public abstract Object getValue(String var1, VirtualColumnType var2);

    public void setValue(FaxJob<? extends FmtItem> faxJob, VirtualColumnType virtualColumnType, Object object) {
        this.setValue(VirtColPersister.getKeyForFaxJob(faxJob), virtualColumnType, object);
    }

    public abstract void setValue(String var1, VirtualColumnType var2, Object var3);

    public static VirtColPersister createFromOptions(ServerOptions serverOptions) {
        String string = serverOptions.persistenceMethod;
        try {
            for (AvailablePersistenceMethod availablePersistenceMethod : persistenceMethods) {
                if (!availablePersistenceMethod.getKey().equals(string)) continue;
                String string2 = serverOptions.persistenceConfig;
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
                if (Utils.debugMode) {
                    log.info(String.format("Using persistence method %s with Config \"%s\".", string, string2));
                }
                return availablePersistenceMethod.createInstance(string2, serverOptions.id);
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Could not create persistence object:", exception);
        }
        log.warning(String.format("Could not create instance for persistence method %s, using default.", string));
        return DEFAULT_METHOD.createInstance(null, serverOptions.id);
    }

    static {
        persistenceMethods = new ArrayList<AvailablePersistenceMethod>();
        DEFAULT_METHOD = new LocalVirtColPersister.PersistenceMethod();
        persistenceMethods.add(DEFAULT_METHOD);
        persistenceMethods.add(new JDBCVirtColPersister.PersistenceMethod());
    }
}

