/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.AsciiOutputStream;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.Putter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivePutter
extends Putter {
    private static final Log log = LogFactory.getLog(ActivePutter.class);
    private InetAddress address;
    private int port;
    private ServerSocket server = new ServerSocket(0);
    private int timeout = 30000;

    public ActivePutter(InputStream in) throws IOException {
        this.port = this.server.getLocalPort();
        this.address = this.server.getInetAddress();
        this.istream = in;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean signalClosure = false;
        Socket sock = null;
        OutputStream ostream = null;
        long amount = 0L;
        int buffer_size = 0;
        byte[] buffer = new byte[1024];
        try {
            this.server.setSoTimeout(this.timeout);
            if (this.cancelled) {
                throw new InterruptedIOException("Transfer cancelled");
            }
            sock = this.server.accept();
            this.signalConnectionOpened(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
            this.signalTransferStarted();
            try {
                int len;
                switch (this.type) {
                    case 'A': {
                        ostream = new AsciiOutputStream(sock.getOutputStream());
                        break;
                    }
                    default: {
                        ostream = sock.getOutputStream();
                    }
                }
                switch (this.mode) {
                    case 'Z': {
                        ostream = new DeflaterOutputStream(ostream);
                        break;
                    }
                }
                while ((len = this.istream.read(buffer)) != -1) {
                    ostream.write(buffer, 0, len);
                    amount += (long)len;
                    if ((buffer_size += len) >= 1024) {
                        buffer_size %= 1024;
                        this.signalTransfered(amount);
                    }
                    ActivePutter.yield();
                }
            }
            catch (InterruptedIOException iioe) {
                if (!this.cancelled) {
                    log.error(iioe.getMessage(), iioe);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            finally {
                log.debug("Closing inputstream");
                if (ostream != null) {
                    ostream.close();
                }
                if (!sock.isClosed()) {
                    try {
                        log.debug("Setting socket to 0 lingering");
                        sock.setSoLinger(true, 0);
                        sock.close();
                    }
                    catch (SocketException iioe) {}
                }
                this.signalTransferCompleted();
            }
        }
        catch (Exception ee) {
            this.signalConnectionFailed(ee);
            log.error(ee.getMessage(), ee);
        }
        finally {
            try {
                log.debug("Closing server socket");
                this.server.close();
            }
            catch (IOException iOException) {}
        }
        if (signalClosure && sock != null) {
            this.signalConnectionClosed(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
        }
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }
}

