/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import yajhfc.Utils;

public class DateStyle {
    private final String displayName;
    private final String saveString;
    public static final String FROM_LOCALE = "$LOCALE$";
    public static final String FROM_SYSTEM = "$SYSTEM$";
    private static DateStyle[] availableDateStyles;
    private static DateStyle[] availableTimeStyles;

    public String toString() {
        return this.displayName;
    }

    public String getSaveString() {
        return this.saveString;
    }

    public DateStyle(String string, String string2) {
        this.displayName = string;
        this.saveString = string2;
    }

    public DateStyle(String string) {
        this.saveString = string;
        this.displayName = string;
    }

    public static DateStyle[] getAvailableDateStyles() {
        return availableDateStyles;
    }

    public static DateStyle[] getAvailableTimeStyles() {
        return availableTimeStyles;
    }

    public static DateFormat getDateFormatFromString(String string) {
        if (string.equals(FROM_LOCALE)) {
            return new SimpleDateFormat(Utils._("dd/MM/yyyy"));
        }
        if (string.equals(FROM_SYSTEM)) {
            return DateFormat.getDateInstance(3);
        }
        return new SimpleDateFormat(string);
    }

    public static DateFormat getTimeFormatFromString(String string) {
        if (string.equals(FROM_LOCALE)) {
            return new SimpleDateFormat(Utils._("HH:mm:ss"));
        }
        if (string.equals(FROM_SYSTEM)) {
            return DateFormat.getTimeInstance(2);
        }
        return new SimpleDateFormat(string);
    }

    public static DateFormat getDateTimeFormatFromString(String string, String string2) {
        final DateFormat dateFormat = DateStyle.getDateFormatFromString(string);
        final DateFormat dateFormat2 = DateStyle.getTimeFormatFromString(string2);
        if (dateFormat instanceof SimpleDateFormat && dateFormat2 instanceof SimpleDateFormat) {
            return new SimpleDateFormat(((SimpleDateFormat)dateFormat).toPattern() + ' ' + ((SimpleDateFormat)dateFormat2).toPattern());
        }
        return new DateFormat(){

            public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                dateFormat.format(date, stringBuffer, fieldPosition);
                stringBuffer.append(' ');
                return dateFormat2.format(date, stringBuffer, fieldPosition);
            }

            public Date parse(String string, ParsePosition parsePosition) {
                Date date = dateFormat.parse(string, parsePosition);
                if (date != null) {
                    long l;
                    int n;
                    for (n = parsePosition.getIndex(); n < string.length() && string.charAt(n) == ' '; ++n) {
                    }
                    parsePosition.setIndex(n);
                    Date date2 = dateFormat2.parse(string, parsePosition);
                    if (date2 != null) {
                        l = date2.getTime();
                        l += (long)TimeZone.getDefault().getOffset(l);
                    } else {
                        l = 0L;
                    }
                    return new Date(date.getTime() + l);
                }
                return null;
            }
        };
    }

    static {
        DateStyle dateStyle = new DateStyle(Utils._("(Language default)"), FROM_LOCALE);
        DateStyle dateStyle2 = new DateStyle(Utils._("(System default)"), FROM_SYSTEM);
        availableDateStyles = new DateStyle[]{dateStyle, dateStyle2, new DateStyle("dd/MM/yyyy"), new DateStyle("MM/dd/yyyy"), new DateStyle("dd.MM.yyyy"), new DateStyle("yyyy-MM-dd")};
        availableTimeStyles = new DateStyle[]{dateStyle, dateStyle2, new DateStyle("HH:mm:ss"), new DateStyle("HH.mm.ss"), new DateStyle("hh:mm:ss aa")};
    }
}

