/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.inet.ftp.ServerResponseException;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.HylafaxWorker;
import yajhfc.model.servconn.JobState;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.send.TimeToSendEntry;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditJobWorker
extends ProgressWorker {
    static final Logger log = Logger.getLogger(EditJobWorker.class.getName());
    private FaxJob<? extends FmtItem>[] selJobs;
    private MainWin mw;

    @Override
    protected int calculateMaxProgress() {
        return 20 + 10 * this.selJobs.length;
    }

    @Override
    public void doWork() {
        try {
            MessageFormat messageFormat = new MessageFormat(Utils._("Modifying job {0}"));
            MessageFormat messageFormat2 = new MessageFormat(Utils._("Suspending job {0}"));
            MessageFormat messageFormat3 = new MessageFormat(Utils._("Resuming job {0}"));
            for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                Object object;
                try {
                    String string = messageFormat.format(new Object[]{faxJob.getIDValue().toString()});
                    this.updateNote(string);
                    object = faxJob.getCurrentJobState();
                    if (Utils.debugMode) {
                        log.fine("Job state is " + object);
                    }
                    if (object == JobState.RUNNING) {
                        this.showMessageDialog(MessageFormat.format(Utils._("Job {0} is currently running, cannot modify this job."), faxJob.getIDValue().toString()), Utils._("Modify job parameters"), 2);
                        continue;
                    }
                    if (object != JobState.SUSPENDED) {
                        this.updateNote(messageFormat2.format(new Object[]{faxJob.getIDValue().toString()}));
                        faxJob.suspend();
                        this.updateNote(string);
                    }
                    Map<String, String> map = faxJob.getJobProperties(EditJobDialog.SUPPORTED_PROPERTIES);
                    if (Utils.debugMode) {
                        log.fine("Retrieved properties " + map);
                    }
                    EditJobDialogRunnable editJobDialogRunnable = new EditJobDialogRunnable(this.mw, faxJob, map);
                    SwingUtilities.invokeAndWait(editJobDialogRunnable);
                    HylafaxWorker hylafaxWorker = editJobDialogRunnable.getResult();
                    if (hylafaxWorker == null) {
                        if (object != JobState.SUSPENDED) {
                            this.updateNote(messageFormat3.format(new Object[]{faxJob.getIDValue().toString()}));
                            faxJob.resume();
                        }
                        break;
                    }
                    faxJob.doHylafaxWork(hylafaxWorker);
                    if (object == JobState.SUSPENDED) {
                        this.updateNote(messageFormat2.format(new Object[]{faxJob.getIDValue().toString()}));
                        Thread.sleep(1000L);
                        faxJob.suspend();
                    }
                    this.stepProgressBar(10);
                }
                catch (Exception exception) {
                    object = faxJob == null ? Utils._("Error modifying a fax job") + ":\n" : MessageFormat.format(Utils._("Error modifying the fax job \"{0}\"") + ":\n", faxJob.getIDValue());
                    this.showExceptionDialog((String)object, exception);
                }
            }
        }
        catch (Exception exception) {
            this.showExceptionDialog(Utils._("Error modifying a fax job"), exception);
        }
    }

    @Override
    protected void done() {
        this.mw.refreshTables();
    }

    public static int parseKilltime(String string) throws NumberFormatException {
        int n = Integer.parseInt(string);
        return (n / 10000 * 24 + n / 100 % 100) * 60 + n % 100;
    }

    public static Date parseSendtime(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.parse(string);
    }

    public EditJobWorker(MainWin mainWin, TooltipJTable<? extends FmtItem> tooltipJTable) {
        this.mw = mainWin;
        this.selJobs = tooltipJTable.getSelectedJobs();
        this.progressMonitor = mainWin.getTablePanel();
        this.setCloseOnExit(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EditJobDialogRunnable
    implements Runnable {
        FaxJob<? extends FmtItem> job;
        Map<String, String> properties;
        Window owner;
        HylafaxWorker result;

        public EditJobDialogRunnable(Window window, FaxJob<? extends FmtItem> faxJob, Map<String, String> map) {
            this.owner = window;
            this.job = faxJob;
            this.properties = map;
        }

        @Override
        public void run() {
            EditJobDialog editJobDialog;
            if (this.owner instanceof Frame) {
                editJobDialog = new EditJobDialog((Frame)this.owner, this.job, this.properties);
            } else if (this.owner instanceof Dialog) {
                editJobDialog = new EditJobDialog((Dialog)this.owner, this.job, this.properties);
            } else {
                throw new RuntimeException();
            }
            editJobDialog.setVisible(true);
            this.result = editJobDialog.getResult();
        }

        public HylafaxWorker getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EditJobDialog
    extends JDialog {
        public static String[] SUPPORTED_PROPERTIES = new String[]{"EXTERNAL", "DIALSTRING", "LASTTIME", "SENDTIME", "MAXTRIES"};
        private static int border = 6;
        FaxJob<? extends FmtItem> job;
        Action okAction;
        protected JSpinner spinKillTime;
        protected JSpinner spinMaxTries;
        protected TimeToSendEntry ttsEntry;
        protected JTextField textNumber;
        String origNumber;
        int origKillTime;
        int origMaxTries;
        Date origTTS;
        boolean modalResult = false;

        private static String getTitle(FaxJob<? extends FmtItem> faxJob) {
            return MessageFormat.format(Utils._("Modify parameters of job {0}"), faxJob.getIDValue().toString());
        }

        public EditJobDialog(Dialog dialog, FaxJob<? extends FmtItem> faxJob, Map<String, String> map) {
            super(dialog, EditJobDialog.getTitle(faxJob), true);
            this.initialize(faxJob);
            this.loadValues(map);
        }

        public EditJobDialog(Frame frame, FaxJob<? extends FmtItem> faxJob, Map<String, String> map) {
            super(frame, EditJobDialog.getTitle(faxJob), true);
            this.initialize(faxJob);
            this.loadValues(map);
        }

        private void initialize(FaxJob<? extends FmtItem> faxJob) {
            this.job = faxJob;
            this.okAction = new ExcDialogAbstractAction(){

                protected void actualActionPerformed(ActionEvent actionEvent) {
                    EditJobDialog.this.modalResult = true;
                    EditJobDialog.this.dispose();
                }
            };
            this.okAction.putValue("Name", Utils._("OK"));
            CancelAction cancelAction = new CancelAction(this);
            double[][] dArrayArray = new double[][]{{border, -2.0, border / 2, -1.0, border}, {border, -2.0, border, -2.0, border, -2.0, border, -2.0, border, -1.0, border, -2.0, border}};
            JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
            this.spinKillTime = new JSpinner(new SpinnerNumberModel(180, 0, 142560, 15));
            this.spinMaxTries = new JSpinner(new SpinnerNumberModel(12, 1, 100, 1));
            this.ttsEntry = new TimeToSendEntry();
            this.textNumber = new JTextField();
            ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textNumber);
            Box box = Box.createHorizontalBox();
            Dimension dimension = new Dimension(border, border);
            box.add(Box.createHorizontalGlue());
            box.add(new JButton(this.okAction));
            box.add(Box.createRigidArea(dimension));
            box.add(cancelAction.createCancelButton());
            box.add(Box.createHorizontalGlue());
            Utils.addWithLabelHorz(jPanel, (Component)this.textNumber, Utils._("Fax number") + ":", "3,1,F,C");
            Utils.addWithLabelHorz(jPanel, (Component)this.spinKillTime, Utils._("Cancel job after (minutes):"), "3,3,F,C");
            Utils.addWithLabelHorz(jPanel, (Component)this.spinMaxTries, Utils._("Maximum tries:"), "3,5,F,C");
            Utils.addWithLabelHorz(jPanel, (Component)this.ttsEntry, Utils._("Time to send:"), "3,7,f,c");
            jPanel.add((Component)box, "0,11,4,11,f,f");
            this.setContentPane(jPanel);
            this.pack();
            if (this.getWidth() < 600) {
                this.setSize(600, this.getHeight());
            }
            Utils.setDefWinPos(this);
        }

        public void loadValues(Map<String, String> map) {
            this.origNumber = Utils.firstDefined(map.get("DIALSTRING"), map.get("EXTERNAL"), "");
            this.textNumber.setText(this.origNumber);
            try {
                this.origKillTime = EditJobWorker.parseKilltime(map.get("LASTTIME"));
                this.spinKillTime.setValue(this.origKillTime);
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.WARNING, "Invalid kill time " + map.get("LASTTIME"), numberFormatException);
                this.origKillTime = (Integer)this.spinKillTime.getValue();
            }
            try {
                this.origMaxTries = Integer.parseInt(map.get("MAXTRIES"));
                this.spinMaxTries.setValue(this.origMaxTries);
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.WARNING, "Invalid max tries " + map.get("MAXTRIES"), numberFormatException);
                this.origMaxTries = (Integer)this.spinMaxTries.getValue();
            }
            try {
                this.origTTS = EditJobWorker.parseSendtime(map.get("SENDTIME"));
                this.ttsEntry.setSelection(this.origTTS);
            }
            catch (ParseException parseException) {
                log.log(Level.WARNING, "Invalid send time " + map.get("SENDTIME"), parseException);
                this.origTTS = null;
            }
        }

        public HylafaxWorker getResult() {
            if (!this.modalResult) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.textNumber.getText();
            int n = (Integer)this.spinKillTime.getValue();
            int n2 = (Integer)this.spinMaxTries.getValue();
            Date date = this.ttsEntry.getSelection();
            if (string.equals(this.origNumber)) {
                string = null;
            }
            if (date == null) {
                date = new Date(System.currentTimeMillis() + 5000L);
            } else if (date.equals(this.origTTS)) {
                date = null;
            }
            if (n == this.origKillTime && date == null) {
                n = -1;
            }
            if (n2 != this.origMaxTries) {
                hashMap.put("MAXTRIES", String.valueOf(n2));
            }
            return new EditHylafaxWorker(date, null, n, string, hashMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EditHylafaxWorker
    implements HylafaxWorker {
        public final Date sendTimeDate;
        public final String sendTimeString;
        public final int killTime;
        public final String number;
        public final Map<String, String> customProperties;

        @Override
        public Object work(HylaFAXClient hylaFAXClient, Job job) throws IOException, ServerResponseException {
            if (this.sendTimeDate != null) {
                job.setSendTime(this.sendTimeDate);
            }
            if (this.sendTimeString != null) {
                job.setSendTime(this.sendTimeString);
            }
            if (this.killTime > 0) {
                job.setKilltime(Utils.minutesToHylaTime(this.killTime));
            }
            if (this.number != null) {
                job.setDialstring(this.number);
                job.setProperty("EXTERNAL", this.number);
            }
            if (this.customProperties != null && this.customProperties.size() > 0) {
                for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                    job.setProperty(entry.getKey(), entry.getValue());
                }
            }
            hylaFAXClient.jsubm();
            return null;
        }

        public EditHylafaxWorker(Date date, String string, int n, String string2, Map<String, String> map) {
            this.sendTimeDate = date;
            this.sendTimeString = string;
            this.killTime = n;
            this.number = string2;
            this.customProperties = map;
        }
    }
}

