/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.HylaModem;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.server.ServerOptions;
import yajhfc.ui.YajOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HylaClientManager {
    protected boolean adminMode;
    protected HylaFAXClient client;
    protected ServerOptions myopts;
    protected String password;
    protected String adminPassword;
    protected String userName;
    protected int transactionCounter;
    protected List<HylaModem> realModems = null;
    protected List<HylaModem> modems = null;
    protected boolean showErrorsUsingGUI = true;
    protected static final String modemListFormat = "$$$|%m|%n";
    protected static final String modemListPrefix = "$$$";
    private static final Logger log = Logger.getLogger(HylaClientManager.class.getName());
    private static final int DIALOG_TIMEOUT = 60;

    public HylaClientManager(ServerOptions serverOptions) {
        this.optionsChanged(serverOptions);
    }

    public void optionsChanged(ServerOptions serverOptions) {
        this.forceLogout();
        this.myopts = serverOptions;
        this.realModems = null;
        this.modems = null;
        this.password = !this.myopts.askPassword ? this.myopts.pass.getPassword() : null;
        this.adminPassword = !this.myopts.askAdminPassword ? this.myopts.AdminPassword.getPassword() : null;
        this.userName = !this.myopts.askUsername ? this.myopts.user : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HylaFAXClient beginServerTransaction(YajOptionPane yajOptionPane) {
        ++this.transactionCounter;
        if (Utils.debugMode) {
            log.fine("HylaClientManager -> beginServerTransaction: " + this.transactionCounter);
        }
        if (this.client != null && this.myopts.useDisconnectedMode && this.transactionCounter == 1) {
            HylaFAXClient hylaFAXClient = this.client;
            synchronized (hylaFAXClient) {
                int n;
                Thread.yield();
                try {
                    for (n = 0; this.client != null && n < 500; n += 50) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Utils.debugMode && n >= 500) {
                    log.info("In beginServerTransaction: TIMEOUT waiting for other client");
                }
            }
        }
        if (this.client == null) {
            if (this.transactionCounter != 1) {
                log.warning("Before forceLogin: transactionCounter = " + this.transactionCounter);
            }
            return this.forceLogin(yajOptionPane);
        }
        return this.client;
    }

    public synchronized void endServerTransaction() {
        if (Utils.debugMode) {
            log.fine("HylaClientManager -> endServerTransaction: " + this.transactionCounter);
        }
        --this.transactionCounter;
        if (this.myopts.useDisconnectedMode && this.transactionCounter <= 0) {
            this.forceLogout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HylaFAXClient forceLogin(YajOptionPane yajOptionPane) {
        if (Utils.debugMode) {
            log.fine("HylaClientManager -> forceLogin");
        }
        if (this.client == null) {
            String[] stringArray;
            if (this.userName == null) {
                stringArray = yajOptionPane.showPasswordDialog(Utils._("Log in"), Utils._("Please enter the credentials to log into the HylaFAX server:"), this.myopts.user, true, true);
                if (stringArray == null) {
                    return null;
                }
                this.userName = stringArray[0];
                this.password = stringArray[1];
            }
            this.client = new HylaFAXClient();
            stringArray = this.client;
            synchronized (this.client) {
                this.client.setSocketTimeout(this.myopts.getParent().socketTimeout);
                this.client.setCharacterEncoding(this.myopts.hylaFAXCharacterEncoding);
                try {
                    this.client.open(this.myopts.host, this.myopts.port);
                    if (Utils.debugMode) {
                        log.info("Greeting was: " + this.client.getGreeting());
                    }
                    while (this.client.user(this.userName)) {
                        if (this.password == null || this.password.length() == 0) {
                            String[] stringArray2 = yajOptionPane.showPasswordDialog(Utils._("User password"), Utils._("Please enter the user password:"), this.userName, false, false);
                            if (stringArray2 == null || stringArray2[1].length() == 0) {
                                this.client.quit();
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return null;
                            }
                            try {
                                this.client.pass(stringArray2[1]);
                                this.password = stringArray2[1];
                                break;
                            }
                            catch (ServerResponseException serverResponseException) {
                                yajOptionPane.showExceptionDialog(Utils._("An error occured in response to the password:"), serverResponseException);
                                continue;
                            }
                        }
                        this.client.pass(this.password);
                        break;
                    }
                    if (this.adminMode) {
                        boolean bl = false;
                        if (this.adminPassword == null || this.adminPassword.length() == 0) {
                            String[] stringArray3;
                            while ((stringArray3 = yajOptionPane.showPasswordDialog(Utils._("Admin password"), Utils._("Please enter the administrative password:"), this.userName, false, false)) != null && stringArray3[1].length() != 0) {
                                try {
                                    this.client.admin(stringArray3[1]);
                                    this.adminPassword = stringArray3[1];
                                    bl = true;
                                }
                                catch (ServerResponseException serverResponseException) {
                                    yajOptionPane.showExceptionDialog(Utils._("An error occured in response to the password:"), serverResponseException);
                                    bl = false;
                                }
                                if (!bl) continue;
                                break;
                            }
                        } else {
                            this.client.admin(this.adminPassword);
                            bl = true;
                        }
                        this.adminMode = bl;
                    }
                    this.client.setPassive(this.myopts.pasv);
                    this.client.tzone(this.myopts.tzone.getTimezone());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.client;
                }
                catch (ServerResponseException serverResponseException) {
                    if (this.showErrorsUsingGUI) {
                        yajOptionPane.showExceptionDialog(Utils._("The HylaFAX server responded with an error:"), serverResponseException, 60);
                    } else {
                        log.log(Level.WARNING, "The HylaFAX server responded with an error:", serverResponseException);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                catch (UnknownHostException unknownHostException) {
                    if (this.showErrorsUsingGUI) {
                        yajOptionPane.showExceptionDialog(Utils._("The server's host name was not found:"), unknownHostException, 60);
                    } else {
                        log.log(Level.WARNING, "The server's host name was not found:", unknownHostException);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                catch (Exception exception) {
                    if (this.showErrorsUsingGUI) {
                        yajOptionPane.showExceptionDialog(Utils._("An error occured connecting to the server:"), exception, 60);
                    } else {
                        log.log(Level.WARNING, "An error occured connecting to the server:", exception);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
        }
        return this.client;
    }

    public synchronized void forceLogout() {
        if (Utils.debugMode) {
            log.fine("HylaClientManager -> forceLogout");
        }
        if (this.transactionCounter != 0) {
            log.warning("In forceLogout: transactionCounter = " + this.transactionCounter);
            this.transactionCounter = 0;
        }
        if (this.client != null) {
            block5: {
                try {
                    this.client.quit();
                }
                catch (Exception exception) {
                    if (!Utils.debugMode) break block5;
                    log.log(Level.INFO, "On client.quit():", exception);
                }
            }
            this.client = null;
        }
    }

    public boolean isAdminMode() {
        return this.adminMode;
    }

    public synchronized void setAdminMode(boolean bl) {
        if (bl != this.adminMode) {
            this.adminMode = bl;
            this.forceLogout();
        }
    }

    public synchronized List<HylaModem> getModems() {
        if (this.modems == null) {
            this.modems = new ArrayList<HylaModem>();
            if (this.myopts.useCustomModems) {
                for (String string : this.myopts.customModems) {
                    this.modems.add(new HylaModem(string));
                }
            } else {
                this.modems.addAll(HylaModem.defaultModems);
                this.modems.addAll(this.getRealModems());
            }
        }
        return this.modems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<HylaModem> getRealModems() {
        if (this.realModems == null) {
            Vector vector;
            HylaFAXClient hylaFAXClient = this.beginServerTransaction(Launcher2.application.getDialogUI());
            if (hylaFAXClient == null) {
                this.realModems = Collections.emptyList();
                return this.realModems;
            }
            try {
                HylaFAXClient hylaFAXClient2 = hylaFAXClient;
                synchronized (hylaFAXClient2) {
                    String string = hylaFAXClient.mdmfmt();
                    hylaFAXClient.mdmfmt(modemListFormat);
                    vector = hylaFAXClient.getList("status");
                    hylaFAXClient.mdmfmt(string);
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error fetching modem list: ", exception);
                List<HylaModem> list = this.realModems = Collections.emptyList();
                return list;
            }
            finally {
                this.endServerTransaction();
            }
            this.realModems = new ArrayList<HylaModem>();
            for (String string : vector) {
                String string2 = string;
                if (!string2.startsWith(modemListPrefix)) continue;
                String[] stringArray = Utils.fastSplit(string2, '|');
                if (stringArray.length < 2) {
                    log.log(Level.WARNING, "Invalid modem \"" + string2 + "\".");
                    continue;
                }
                this.realModems.add(new HylaModem(stringArray[1], stringArray.length >= 3 ? stringArray[2] : ""));
            }
        }
        return this.realModems;
    }

    public String getUser() {
        return this.userName;
    }

    public void setShowErrorsUsingGUI(boolean bl) {
        this.showErrorsUsingGUI = bl;
    }

    public boolean isShowErrorsUsingGUI() {
        return this.showErrorsUsingGUI;
    }
}

