/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

public class JavaVersionParser {
    public int javaMajor = -1;
    public int javaMinor = -1;
    public String stringVersion;

    public JavaVersionParser() {
        this.parseVersion();
    }

    public void parseVersion() {
        this.parseVersion(System.getProperty("java.version"));
    }

    public void parseVersion(String string) {
        this.javaMinor = -1;
        this.javaMajor = -1;
        this.stringVersion = string;
        try {
            if (string != null) {
                int n = string.indexOf(46);
                if (n < 0) {
                    this.javaMajor = Integer.parseInt(string);
                } else {
                    int n2 = string.indexOf(46, n + 1);
                    if (n2 < 0) {
                        n2 = string.length();
                    }
                    this.javaMajor = JavaVersionParser.parseIntPrefix(string.substring(0, n));
                    this.javaMinor = JavaVersionParser.parseIntPrefix(string.substring(n + 1, n2));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Could not determine Java version.\n Reason:");
            numberFormatException.printStackTrace();
        }
    }

    public boolean isLessThan(int n, int n2) {
        return this.javaMajor < n || this.javaMajor == n && this.javaMinor < n2;
    }

    public String toString() {
        return this.stringVersion + " (Java " + this.javaMajor + '.' + this.javaMinor + ')';
    }

    public static int parseIntPrefix(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') {
                return n;
            }
            n = n * 10 + (c - 48);
        }
        return n;
    }
}

