/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import com.google.gson.JsonObject;
import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import yajhfc.AboutDialog;
import yajhfc.DesktopManager;
import yajhfc.EditJobWorker;
import yajhfc.FaxOptions;
import yajhfc.HylaClientManager;
import yajhfc.HylaModem;
import yajhfc.IDAndNameOptions;
import yajhfc.LogViewWorker;
import yajhfc.MainWinSearchWin;
import yajhfc.PlatformInfo;
import yajhfc.UpdateChecker;
import yajhfc.Utils;
import yajhfc.export.ExportAction;
import yajhfc.file.FormattedFile;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.filters.AndFilter;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterCreator;
import yajhfc.filters.OrFilter;
import yajhfc.filters.StringFilter;
import yajhfc.filters.StringFilterOperator;
import yajhfc.filters.ui.CustomFilterDialog;
import yajhfc.launch.MainApplicationFrame;
import yajhfc.logconsole.LogConsole;
import yajhfc.macosx.MacOSXSupport;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.IconMap;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.TableType;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.model.servconn.ConnectionState;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.FaxListConnectionListener;
import yajhfc.model.servconn.FaxListConnectionType;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.defimpl.SwingFaxListConnectionListener;
import yajhfc.model.servconn.srfax.SRFaxSentIds;
import yajhfc.model.table.FaxListTableModel;
import yajhfc.model.table.ReadStateFaxListTableModel;
import yajhfc.model.table.UnreadItemEvent;
import yajhfc.model.table.UnreadItemListener;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.options.OptionsWin;
import yajhfc.phonebook.convrules.DefaultPBEntryFieldContainer;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;
import yajhfc.print.FaxTablePrinter;
import yajhfc.send.SendController;
import yajhfc.send.SendWinControl;
import yajhfc.send.ServerFileTFLItem;
import yajhfc.server.Server;
import yajhfc.server.ServerManager;
import yajhfc.server.ServerOptions;
import yajhfc.tray.TrayFactory;
import yajhfc.tray.YajHFCTrayIcon;
import yajhfc.ui.YajOptionPane;
import yajhfc.ui.swing.SwingYajOptionPane;
import yajhfc.util.AbstractQuickSearchHelper;
import yajhfc.util.AcceleratorKeyDialog;
import yajhfc.util.AcceleratorKeys;
import yajhfc.util.ActionJCheckBoxMenuItem;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.FileChooserRunnable;
import yajhfc.util.JTableTABAction;
import yajhfc.util.MultiButtonGroup;
import yajhfc.util.NumberRowViewport;
import yajhfc.util.ProgressPanel;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SRFaxAPI;
import yajhfc.util.SafeJFileChooser;
import yajhfc.util.ToolbarEditorDialog;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainWin
extends JFrame
implements MainApplicationFrame {
    static final Logger log = Logger.getLogger(MainWin.class.getName());
    protected JPanel jContentPane = null;
    protected JToolBar toolbar;
    protected JToolBar quickSearchbar;
    protected QuickSearchHelper quickSearchHelper = new QuickSearchHelper();
    protected JTabbedPane tabMain = null;
    protected JScrollPane scrollRecv = null;
    protected JScrollPane scrollSent = null;
    protected JScrollPane scrollSending = null;
    protected TooltipJTable<RecvFormat> tableRecv = null;
    protected TooltipJTable<JobFormat> tableSent = null;
    protected TooltipJTable<JobFormat> tableSending = null;
    protected ReadStateFaxListTableModel<RecvFormat> recvTableModel = null;
    protected FaxListTableModel<JobFormat> sentTableModel = null;
    protected FaxListTableModel<JobFormat> sendingTableModel = null;
    protected NumberRowViewport recvRowNumbers;
    protected NumberRowViewport sentRowNumbers;
    protected NumberRowViewport sendingRowNumbers;
    protected JTextPane textStatus = null;
    protected JSplitPane statusSplitter;
    protected JMenuBar jJMenuBar = null;
    protected JMenu menuFax = null;
    protected JMenu menuView = null;
    protected JMenu menuExtras = null;
    protected JMenu helpMenu = null;
    protected JMenu menuTable;
    protected FaxOptions myopts = null;
    protected MouseListener tblMouseListener;
    protected DefaultTableCellRenderer hylaDateRenderer;
    protected JPopupMenu tblPopup;
    protected ProgressPanel tablePanel;
    protected MenuViewListener menuViewListener;
    protected TooltipJTable<QueueFileFormat> tableArchive;
    protected JScrollPane scrollArchive;
    protected FaxListTableModel<QueueFileFormat> archiveTableModel;
    protected NumberRowViewport archiveRowNumbers;
    protected Action actSend;
    protected Action actShow;
    protected Action actDelete;
    protected Action actOptions;
    protected Action actExit;
    protected Action actAbout;
    protected Action actPhonebook;
    protected Action actReadme;
    protected Action actPoll;
    protected Action actFaxRead;
    protected Action actFaxSave;
    protected Action actForward;
    protected Action actAdminMode;
    protected Action actRefresh;
    protected Action actResend;
    protected Action actPrintTable;
    protected Action actSuspend;
    protected Action actResume;
    protected Action actClipCopy;
    protected Action actShowRowNumbers;
    protected Action actAdjustColumns;
    protected Action actReconnect;
    protected Action actEditToolbar;
    protected Action actSaveAsPDF;
    protected Action actSaveAsTIFF;
    protected Action actUpdateCheck;
    protected Action actAnswerCall;
    protected Action actSearchFax;
    protected Action actViewLog;
    protected Action actLogConsole;
    protected Action actExport;
    protected Action actShowToolbar;
    protected Action actShowQuickSearchBar;
    protected Action actServerSelectionPopup;
    protected Action actEditAccelerators;
    protected Action actMarkFailedJobs;
    protected Action actSelectAll;
    protected Action actEditJob;
    protected Action actEditComment;
    protected StatusBarResizeAction actAutoSizeStatus;
    protected ActionEnabler actChecker;
    protected Map<String, Action> availableActions = new HashMap<String, Action>();
    protected YajHFCTrayIcon trayIcon = null;
    protected ServerMenu serverMenu;
    protected JPopupMenu toolbarPopup;
    protected Server currentServer;
    protected FaxListConnection connection;
    protected SendReadyState sendReady = SendReadyState.NeedToWait;
    boolean hideMenusForMac = false;
    protected boolean userInitiatedLogout = false;
    protected YajOptionPane dialogUI = new SwingYajOptionPane(this);
    private final FaxListConnectionListener connListener = new SwingFaxListConnectionListener(true, true, false){

        protected void serverStatusChangedSwing(String string) {
            MainWin.this.textStatus.setText(string);
        }

        protected void connectionStateChangeSwing(ConnectionState connectionState, ConnectionState connectionState2) {
            if (connectionState2 == ConnectionState.DISCONNECTED) {
                MainWin.this.setDisconnectedUI();
                if (MainWin.this.tablePanel.isShowingProgress()) {
                    MainWin.this.tablePanel.hideProgress();
                }
                if (!MainWin.this.userInitiatedLogout && MainWin.this.myopts.autoReconnect) {
                    MainWin.this.setupReconnectTimer();
                }
                MainWin.this.userInitiatedLogout = false;
            }
        }
    };
    private static final int RECONNECT_DELAY = 30;
    Timer reconnectTimer;

    private void createActions(boolean bl) {
        this.actOptions = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                SendReadyState sendReadyState = MainWin.this.sendReady;
                MainWin.this.sendReady = SendReadyState.NeedToWait;
                OptionsWin optionsWin = new OptionsWin(MainWin.this.myopts, MainWin.this);
                optionsWin.setModal(true);
                Utils.unsetWaitCursorOnOpen(null, optionsWin);
                optionsWin.setVisible(true);
                if (optionsWin.getModalResult()) {
                    MainWin.this.optionsChanged();
                    Utils.storeOptionsToFile();
                } else {
                    MainWin.this.sendReady = sendReadyState;
                }
            }
        };
        this.actOptions.putValue("Name", Utils._("Options") + "...");
        this.actOptions.putValue("ShortDescription", Utils._("Shows the Options dialog"));
        this.actOptions.putValue("SmallIcon", Utils.loadIcon("general/Preferences"));
        this.putAvailableAction("Options", this.actOptions);
        this.actSend = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                SendWinControl sendWinControl = SendController.createSendWindow(MainWin.this, MainWin.this.currentServer, false, false);
                Utils.unsetWaitCursorOnOpen(null, sendWinControl.getWindow());
                sendWinControl.setVisible(true);
                if (sendWinControl.getModalResult()) {
                    MainWin.this.refreshTables();
                }
            }
        };
        this.actSend.putValue("Name", Utils._("Send") + "...");
        this.actSend.putValue("ShortDescription", Utils._("Shows the send fax dialog"));
        this.actSend.putValue("SmallIcon", Utils.loadIcon("general/SendMail"));
        this.putAvailableAction("Send", this.actSend);
        this.actPoll = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                SendWinControl sendWinControl = SendController.createSendWindow(MainWin.this, MainWin.this.currentServer, true, true);
                Utils.unsetWaitCursorOnOpen(null, sendWinControl.getWindow());
                sendWinControl.setVisible(true);
            }
        };
        this.actPoll.putValue("Name", Utils._("Poll") + "...");
        this.actPoll.putValue("ShortDescription", Utils._("Shows the poll fax dialog"));
        this.actPoll.putValue("SmallIcon", Utils.loadIcon("general/Import"));
        this.putAvailableAction("Poll", this.actPoll);
        this.actDelete = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                String string = tooltipJTable == MainWin.this.tableSending ? Utils._("Do you really want to cancel the selected fax jobs?") : Utils._("Do you really want to delete the selected faxes?");
                if (JOptionPane.showConfirmDialog(MainWin.this, string, Utils._("Delete faxes"), 0) == 0) {
                    DeleteWorker deleteWorker = new DeleteWorker(tooltipJTable);
                    deleteWorker.startWork(MainWin.this, Utils._("Deleting faxes"));
                }
            }
        };
        this.actDelete.putValue("Name", Utils._("Delete"));
        this.actDelete.putValue("ShortDescription", Utils._("Deletes the selected fax"));
        this.actDelete.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
        this.putAvailableAction("Delete", this.actDelete);
        this.actShow = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                ShowWorker showWorker = new ShowWorker(tooltipJTable);
                showWorker.startWork(MainWin.this, Utils._("Viewing faxes"));
            }
        };
        this.actShow.putValue("Name", Utils._("Show") + "...");
        this.actShow.putValue("ShortDescription", Utils._("Displays the selected fax"));
        this.actShow.putValue("SmallIcon", Utils.loadIcon("general/Zoom"));
        this.putAvailableAction("Show", this.actShow);
        this.actExit = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                MainWin.this.dispose();
            }
        };
        this.actExit.putValue("Name", Utils._("Exit"));
        this.actExit.putValue("ShortDescription", Utils._("Exits the application"));
        this.actExit.putValue("SmallIcon", Utils.loadIcon("general/Stop"));
        this.putAvailableAction("Exit", this.actExit);
        this.actAbout = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                AboutDialog aboutDialog = new AboutDialog(MainWin.this);
                aboutDialog.setMode(AboutDialog.Mode.ABOUT);
                Utils.unsetWaitCursorOnOpen(null, aboutDialog);
                aboutDialog.setVisible(true);
            }
        };
        this.actAbout.putValue("Name", Utils._("About") + "...");
        this.actAbout.putValue("ShortDescription", Utils._("Shows the about dialog"));
        this.actAbout.putValue("SmallIcon", Utils.loadIcon("general/About"));
        this.putAvailableAction("About", this.actAbout);
        this.actPhonebook = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                NewPhoneBookWin newPhoneBookWin = new NewPhoneBookWin(MainWin.this);
                newPhoneBookWin.setModal(true);
                Utils.unsetWaitCursorOnOpen(null, newPhoneBookWin);
                newPhoneBookWin.setVisible(true);
            }
        };
        this.actPhonebook.putValue("Name", Utils._("Phone book") + "...");
        this.actPhonebook.putValue("ShortDescription", Utils._("Display/edit the phone book"));
        this.actPhonebook.putValue("SmallIcon", Utils.loadIcon("general/Bookmarks"));
        this.putAvailableAction("Phonebook", this.actPhonebook);
        this.actReadme = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                AboutDialog aboutDialog = new AboutDialog(MainWin.this);
                aboutDialog.setMode(AboutDialog.Mode.READMES);
                Utils.unsetWaitCursorOnOpen(null, aboutDialog);
                aboutDialog.setVisible(true);
            }
        };
        this.actReadme.putValue("Name", Utils._("Documentation") + "...");
        this.actReadme.putValue("ShortDescription", Utils._("Shows the README files"));
        this.actReadme.putValue("SmallIcon", Utils.loadIcon("general/Help"));
        this.putAvailableAction("Readme", this.actReadme);
        this.actFaxRead = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                boolean bl;
                Boolean bl2 = (Boolean)this.getValue("selected");
                if (bl2 == null) {
                    bl = true;
                } else {
                    boolean bl3 = bl = bl2 == false;
                }
                if (MainWin.this.tabMain.getSelectedComponent() == MainWin.this.scrollRecv) {
                    int n = Integer.MAX_VALUE;
                    int n2 = Integer.MIN_VALUE;
                    for (int n3 : MainWin.this.tableRecv.getSelectedRows()) {
                        MainWin.this.tableRecv.getJobForRow(n3).setRead(bl);
                        if (n3 < n) {
                            n = n3;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                    if (n2 >= 0) {
                        MainWin.this.tableRecv.getSorter().fireTableRowsUpdated(n, n2);
                    }
                    this.putValue("selected", bl);
                }
            }
        };
        this.actFaxRead.putValue("Name", Utils._("Marked as read"));
        this.actFaxRead.putValue("ShortDescription", Utils._("Marks the selected fax as read/unread"));
        this.actFaxRead.putValue("selected", true);
        this.putAvailableAction("FaxRead", this.actFaxRead);
        this.actFaxSave = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                if (tooltipJTable.getSelectedRowCount() == 0) {
                    return;
                }
                if (tooltipJTable.getSelectedRowCount() > 1) {
                    SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
                    safeJFileChooser.setDialogTitle(Utils._("Select a directory to save the faxes in"));
                    safeJFileChooser.setApproveButtonText(Utils._("Select"));
                    safeJFileChooser.setFileSelectionMode(1);
                    if (Utils.getFaxOptions().lastSavePath.length() > 0) {
                        safeJFileChooser.setSelectedFile(new File(Utils.getFaxOptions().lastSavePath));
                    }
                    if (safeJFileChooser.showOpenDialog(MainWin.this) == 0) {
                        MultiSaveWorker multiSaveWorker = new MultiSaveWorker(tooltipJTable, safeJFileChooser.getSelectedFile(), false);
                        multiSaveWorker.startWork(MainWin.this, Utils._("Saving faxes"));
                        Utils.getFaxOptions().lastSavePath = safeJFileChooser.getSelectedFile().getPath();
                    }
                } else {
                    MultiSaveWorker multiSaveWorker = new MultiSaveWorker(tooltipJTable, null, true);
                    multiSaveWorker.startWork(MainWin.this, Utils._("Saving faxes"));
                }
            }
        };
        this.actFaxSave.putValue("Name", Utils._("Save fax..."));
        this.actFaxSave.putValue("ShortDescription", Utils._("Saves the selected fax on disk"));
        this.actFaxSave.putValue("SmallIcon", Utils.loadIcon("general/SaveAs"));
        this.putAvailableAction("FaxSave", this.actFaxSave);
        this.actForward = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (MainWin.this.tabMain.getSelectedComponent() != MainWin.this.scrollRecv || MainWin.this.tableRecv.getSelectedRow() < 0) {
                    return;
                }
                ArrayList<FaxDocument> arrayList = new ArrayList<FaxDocument>();
                try {
                    for (int n : MainWin.this.tableRecv.getSelectedRows()) {
                        arrayList.addAll(MainWin.this.tableRecv.getJobForRow(n).getDocuments());
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog(MainWin.this, Utils._("Couldn't get a filename for the fax:"), exception);
                    return;
                }
                Object object = SendController.createSendWindow(MainWin.this, MainWin.this.currentServer, false, true);
                for (FaxDocument faxDocument : arrayList) {
                    object.getDocuments().add(new ServerFileTFLItem(faxDocument));
                }
                object.setVisible(true);
                MainWin.this.refreshTables();
            }
        };
        this.actForward.putValue("Name", Utils._("Forward fax..."));
        this.actForward.putValue("ShortDescription", Utils._("Forwards the fax"));
        this.actForward.putValue("SmallIcon", Utils.loadIcon("general/Redo"));
        this.putAvailableAction("Forward", this.actForward);
        this.actAdminMode = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                this.putValue("selected", bl2);
                MainWin.this.doLogout(true);
                Utils.unsetWaitCursor(null);
            }
        };
        this.actAdminMode.putValue("Name", Utils._("Admin mode"));
        this.actAdminMode.putValue("ShortDescription", Utils._("Connect to the server in admin mode (e.g. to delete faxes)"));
        this.actAdminMode.putValue("selected", bl);
        this.putAvailableAction("AdminMode", this.actAdminMode);
        this.actRefresh = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                MainWin.this.refreshStatus();
                MainWin.this.refreshTables();
                Utils.unsetWaitCursor(null);
            }
        };
        this.actRefresh.putValue("Name", Utils._("Refresh"));
        this.actRefresh.putValue("ShortDescription", Utils._("Refresh tables and server status"));
        this.actRefresh.putValue("SmallIcon", Utils.loadIcon("general/Refresh"));
        this.putAvailableAction("Refresh", this.actRefresh);
        this.actResend = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                if (tooltipJTable.getSelectedRow() < 0) {
                    return;
                }
                Utils.setWaitCursor(null);
                final FaxJob[] faxJobArray = tooltipJTable.getSelectedJobs();
                ProgressWorker progressWorker = new ProgressWorker(){
                    List<PBEntryFieldContainer> recipients;
                    List<Collection<FaxDocument>> files;
                    List<String> subjects;
                    boolean success;
                    {
                        this.recipients = new ArrayList<PBEntryFieldContainer>(faxJobArray.length);
                        this.files = new ArrayList<Collection<FaxDocument>>(faxJobArray.length);
                        this.subjects = new ArrayList<String>(faxJobArray.length);
                        this.success = false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void doWork() {
                        try {
                            MessageFormat messageFormat = new MessageFormat(Utils._("Getting information for job {0}..."));
                            ServerOptions serverOptions = MainWin.this.connection.getOptions();
                            if (serverOptions.faxListConnectionType == FaxListConnectionType.SRFAX) {
                                for (FaxJob faxJob : faxJobArray) {
                                    this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                                    String string = faxJob.toString().substring(faxJob.toString().indexOf(":") + 1);
                                    String string2 = string.substring(string.indexOf("|") + 1);
                                    String string3 = "&sDirection=OUT&sFaxFileName=" + string + "&sFaxDetailsID=" + string2;
                                    JsonObject jsonObject = SRFaxAPI.sendPost("Get_FaxStatus&sFaxDetailsID=" + string2, serverOptions.user, serverOptions.pass.getPassword());
                                    if (jsonObject.get("Status").getAsString().compareTo("Failed") == 0) {
                                        MainWin.this.dialogUI.showMessageDialog(jsonObject.get("Result").getAsString(), Utils._("SRFax Server Error"), 1);
                                        continue;
                                    }
                                    JsonObject jsonObject2 = SRFaxAPI.sendPost("Forward_Fax&sCallerID=" + serverOptions.SRFaxNumber + "&sSenderEmail=" + serverOptions.SRFaxEmail + "&sFaxType=SINGLE&sToFaxNumber=" + jsonObject.get("Result").getAsJsonObject().get("ToFaxNumber") + string3, serverOptions.user, serverOptions.pass.getPassword());
                                    if (jsonObject2.get("Status").getAsString().compareTo("Failed") == 0) {
                                        MainWin.this.dialogUI.showMessageDialog(jsonObject2.get("Result").getAsString(), Utils._("SRFax Server Error"), 1);
                                        continue;
                                    }
                                    SRFaxSentIds.getInstance().ids.add(serverOptions.user + "@" + jsonObject2.get("Result").getAsString());
                                    faxJob.delete();
                                }
                                Utils.unsetWaitCursor(null);
                                return;
                            }
                            MainWin.this.connection.beginMultiOperation();
                            String string = MainWin.this.connection.getOptions().numberPrefix;
                            try {
                                for (FaxJob faxJob : faxJobArray) {
                                    this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                                    Map<String, String> map = faxJob.getJobProperties("EXTERNAL", "DIALSTRING", "TOUSER", "TOCOMPANY", "TOLOCATION", "TOVOICE", "REGARDING");
                                    if (map == null || map.size() <= 0) continue;
                                    String string4 = map.get("DIALSTRING");
                                    if (string4 == null) {
                                        string4 = map.get("EXTERNAL");
                                    }
                                    if (string.length() > 0 && string4 != null && string4.startsWith(string)) {
                                        string4 = string4.substring(string.length());
                                    }
                                    String string5 = map.get("TOUSER");
                                    String string6 = map.get("TOCOMPANY");
                                    String string7 = map.get("TOLOCATION");
                                    String string8 = map.get("TOVOICE");
                                    String string9 = map.get("REGARDING");
                                    this.files.add(faxJob.getDocuments());
                                    this.recipients.add(new DefaultPBEntryFieldContainer(string4, string5, string6, string7, string8));
                                    this.subjects.add(string9);
                                }
                                this.updateNote(Utils._("Opening send dialog..."));
                                this.success = true;
                            }
                            catch (Exception exception) {
                                Utils.unsetWaitCursor(null);
                                ExceptionDialog.showExceptionDialog(MainWin.this, Utils._("Could not get all of the job information necessary to resend the fax:"), exception);
                                return;
                            }
                            finally {
                                MainWin.this.connection.endMultiOperation();
                            }
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog(MainWin.this, Utils._("Error resending faxes:"), exception);
                        }
                    }

                    protected void done() {
                        if (this.success) {
                            for (int i = 0; i < this.recipients.size(); ++i) {
                                SendWinControl sendWinControl = SendController.createSendWindow(MainWin.this, MainWin.this.currentServer, false, true);
                                sendWinControl.getRecipients().add(this.recipients.get(i));
                                for (FaxDocument faxDocument : this.files.get(i)) {
                                    sendWinControl.getDocuments().add(new ServerFileTFLItem(faxDocument));
                                }
                                if (this.subjects.get(i) != null) {
                                    sendWinControl.setSubject(this.subjects.get(i));
                                }
                                Utils.unsetWaitCursorOnOpen(null, sendWinControl.getWindow());
                                sendWinControl.setVisible(true);
                            }
                        } else {
                            Utils.unsetWaitCursor(null);
                        }
                    }
                };
                progressWorker.setProgressMonitor(MainWin.this.tablePanel);
                progressWorker.setCloseOnExit(true);
                progressWorker.startWork(MainWin.this, Utils._("Resending fax..."));
            }
        };
        this.actResend.putValue("Name", Utils._("Resend fax..."));
        this.actResend.putValue("ShortDescription", Utils._("Resend the fax"));
        this.actResend.putValue("SmallIcon", Utils.loadIcon("general/Export"));
        this.putAvailableAction("Resend", this.actResend);
        this.actPrintTable = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                FaxTablePrinter.printFaxTable(MainWin.this, tooltipJTable, MainWin.this.tabMain.getToolTipTextAt(MainWin.this.tabMain.getSelectedIndex()));
            }
        };
        this.actPrintTable.putValue("Name", Utils._("Print") + "...");
        this.actPrintTable.putValue("ShortDescription", Utils._("Prints the currently displayed table"));
        this.actPrintTable.putValue("SmallIcon", Utils.loadIcon("general/Print"));
        this.putAvailableAction("PrintTable", this.actPrintTable);
        this.actSuspend = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                SuspendWorker suspendWorker = new SuspendWorker(tooltipJTable);
                suspendWorker.startWork(MainWin.this, Utils._("Suspending jobs"));
            }
        };
        this.actSuspend.putValue("Name", Utils._("Suspend"));
        this.actSuspend.putValue("ShortDescription", Utils._("Suspends the transfer of the selected fax"));
        this.actSuspend.putValue("SmallIcon", Utils.loadIcon("media/Pause"));
        this.putAvailableAction("Suspend", this.actSuspend);
        this.actEditJob = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                EditJobWorker editJobWorker = new EditJobWorker(MainWin.this, tooltipJTable);
                editJobWorker.startWork(MainWin.this, Utils._("Modifying job parameters"));
            }
        };
        this.actEditJob.putValue("Name", Utils._("Modify job parameters") + "...");
        this.actEditJob.putValue("ShortDescription", Utils._("Allows to modify some job parameters"));
        this.actEditJob.putValue("SmallIcon", Utils.loadIcon("general/Edit"));
        this.putAvailableAction("EditJob", this.actEditJob);
        this.actResume = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                ResumeWorker resumeWorker = new ResumeWorker(tooltipJTable);
                resumeWorker.startWork(MainWin.this, Utils._("Resuming jobs"));
            }
        };
        this.actResume.putValue("Name", Utils._("Resume"));
        this.actResume.putValue("ShortDescription", Utils._("Resumes the transfer of the selected fax"));
        this.actResume.putValue("SmallIcon", Utils.loadIcon("media/Play"));
        this.putAvailableAction("Resume", this.actResume);
        this.actClipCopy = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                tooltipJTable.getTransferHandler().exportToClipboard(tooltipJTable, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
        };
        this.actClipCopy.putValue("Name", Utils._("Copy"));
        this.actClipCopy.putValue("ShortDescription", Utils._("Copies the selected table items to the clipboard"));
        this.actClipCopy.putValue("SmallIcon", Utils.loadIcon("general/Copy"));
        this.putAvailableAction("ClipCopy", this.actClipCopy);
        this.actShowRowNumbers = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                MainWin.this.recvRowNumbers.setVisible(bl2);
                MainWin.this.sentRowNumbers.setVisible(bl2);
                MainWin.this.sendingRowNumbers.setVisible(bl2);
                this.putValue("selected", bl2);
            }
        };
        this.actShowRowNumbers.putValue("Name", Utils._("Show row numbers"));
        this.actShowRowNumbers.putValue("ShortDescription", Utils._("Show row numbers"));
        this.actShowRowNumbers.putValue("selected", this.myopts.showRowNumbers);
        this.putAvailableAction("ShowRowNumbers", this.actShowRowNumbers);
        this.actMarkFailedJobs = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                MainWin.this.myopts.markFailedJobs = bl2;
                MainWin.this.getSelectedTable().repaint();
                this.putValue("selected", bl2);
            }
        };
        this.actMarkFailedJobs.putValue("Name", Utils._("Mark failed jobs"));
        this.actMarkFailedJobs.putValue("selected", this.myopts.markFailedJobs);
        this.putAvailableAction("MarkFailedJobs", this.actMarkFailedJobs);
        this.actAdjustColumns = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                int n = bl2 ? 2 : 0;
                MainWin.this.tableRecv.setAutoResizeMode(n);
                MainWin.this.tableSent.setAutoResizeMode(n);
                MainWin.this.tableSending.setAutoResizeMode(n);
                if (MainWin.this.tableArchive != null) {
                    MainWin.this.tableArchive.setAutoResizeMode(n);
                }
                this.putValue("selected", bl2);
            }
        };
        this.actAdjustColumns.putValue("Name", Utils._("Adjust column widths"));
        this.actAdjustColumns.putValue("ShortDescription", Utils._("Adjust column widths to fit the window size"));
        this.actAdjustColumns.putValue("selected", this.myopts.adjustColumnWidths);
        this.putAvailableAction("AdjustColumns", this.actAdjustColumns);
        this.actReconnect = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                if (MainWin.this.connection.getConnectionState() != ConnectionState.DISCONNECTED) {
                    MainWin.this.doLogout(false);
                } else {
                    MainWin.this.reconnectToServer(null, true);
                }
                Utils.unsetWaitCursor(null);
            }
        };
        this.actReconnect.putValue("ShortDescription", Utils._("Connect or disconnect to the HylaFAX server"));
        this.putAvailableAction("Reconnect", this.actReconnect);
        this.setActReconnectState(true);
        this.actEditToolbar = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                ToolbarEditorDialog toolbarEditorDialog = new ToolbarEditorDialog((Frame)MainWin.this, MainWin.this.availableActions, MainWin.this.toolbar, "Send|---|Show|Delete|---|Refresh|---|Phonebook|---|Resume|Suspend");
                toolbarEditorDialog.setVisible(true);
            }
        };
        this.actEditToolbar.putValue("Name", Utils._("Customize toolbar") + "...");
        this.actEditToolbar.putValue("ShortDescription", Utils._("Customize the toolbar"));
        this.putAvailableAction("EditToolbar", this.actEditToolbar);
        this.actEditAccelerators = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                AcceleratorKeyDialog acceleratorKeyDialog = new AcceleratorKeyDialog((Frame)MainWin.this, MainWin.this.availableActions.values(), AcceleratorKeys.DEFAULT_MAINWIN_MAPPING);
                acceleratorKeyDialog.setVisible(true);
                if (acceleratorKeyDialog.modalResult) {
                    AcceleratorKeys.saveToMap(MainWin.this.myopts.keyboardAccelerators, MainWin.this.availableActions);
                }
            }
        };
        this.actEditAccelerators.putValue("Name", Utils._("Edit keyboard shortcuts") + "...");
        this.actEditAccelerators.putValue("ShortDescription", Utils._("Customize the keyboard shortcuts"));
        this.putAvailableAction("EditAccelerators", this.actEditAccelerators);
        this.actUpdateCheck = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                UpdateChecker.doGUIUpdateCheck(MainWin.this, MainWin.this.tablePanel);
            }
        };
        this.actUpdateCheck.putValue("Name", Utils._("Check for update") + "...");
        this.actUpdateCheck.putValue("ShortDescription", Utils._("Checks if there is a newer version of YajHFC available"));
        this.putAvailableAction("UpdateCheck", this.actUpdateCheck);
        this.actAnswerCall = new ExcDialogAbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actualActionPerformed(ActionEvent actionEvent) {
                HylaClientManager hylaClientManager = MainWin.this.connection.getClientManager();
                if (hylaClientManager == null) {
                    JOptionPane.showMessageDialog(MainWin.this, Utils._("Answering a phone call requires a direct connection to the HylaFAX server which is not available."), Utils._("Answer call"), 1);
                    return;
                }
                if (hylaClientManager.isAdminMode()) {
                    ArrayList<HylaModem> arrayList = new ArrayList<HylaModem>();
                    for (HylaModem object2 : hylaClientManager.getRealModems()) {
                        if (object2.getInternalName().equals("any")) continue;
                        arrayList.add(object2);
                    }
                    if (arrayList.size() == 0) {
                        JOptionPane.showMessageDialog(MainWin.this, Utils._("No valid modem found."), Utils._("Answer call"), 1);
                        return;
                    }
                    Object object3 = JOptionPane.showInputDialog(MainWin.this, Utils._("Please select which modem shall answer a phone call:"), Utils._("Answer call"), 3, null, arrayList.toArray(), arrayList.get(0));
                    if (object3 == null) {
                        return;
                    }
                    HylaFAXClient hylaFAXClient = hylaClientManager.beginServerTransaction(MainWin.this.dialogUI);
                    if (hylaFAXClient == null) {
                        return;
                    }
                    try {
                        hylaFAXClient.answer(((HylaModem)object3).getInternalName() + " fax");
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(MainWin.this, Utils._("Error answering the phone call:"), exception);
                    }
                    finally {
                        hylaClientManager.endServerTransaction();
                    }
                } else {
                    JOptionPane.showMessageDialog(MainWin.this, Utils._("Answering a phone call requires administrative privileges.\nPlease enable admin mode first."), Utils._("Answer call"), 1);
                }
            }
        };
        this.actAnswerCall.putValue("Name", Utils._("Answer call") + "...");
        this.actAnswerCall.putValue("ShortDescription", Utils._("Manually answer a phone call with a modem"));
        this.putAvailableAction("AnswerCall", this.actAnswerCall);
        this.actSearchFax = new ExcDialogAbstractAction(){
            private MainWinSearchWin searchWin = null;

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (this.searchWin == null) {
                    this.searchWin = new MainWinSearchWin(MainWin.this);
                }
                this.searchWin.setVisible(true);
            }
        };
        this.actSearchFax.putValue("Name", Utils._("Search fax") + "...");
        this.actSearchFax.putValue("ShortDescription", Utils._("Searches for a fax"));
        this.actSearchFax.putValue("SmallIcon", Utils.loadIcon("general/Find"));
        this.putAvailableAction("SearchFax", this.actSearchFax);
        this.actViewLog = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(null);
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                if (tooltipJTable.getSelectedRowCount() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                TableType tableType = tooltipJTable.getRealModel().getTableType();
                switch (tableType) {
                    case SENT: 
                    case SENDING: 
                    case ARCHIVE: {
                        break;
                    }
                    default: {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                ArrayList<FaxJob<? extends FmtItem>> arrayList = new ArrayList<FaxJob<? extends FmtItem>>(tooltipJTable.getSelectedRowCount());
                for (int n : tooltipJTable.getSelectedRows()) {
                    arrayList.add(tooltipJTable.getJobForRow(n));
                }
                Object object = new LogViewWorker(MainWin.this.connection, arrayList, MainWin.this.tablePanel);
                ((ProgressWorker)object).setCloseOnExit(true);
                ((ProgressWorker)object).startWork(MainWin.this, Utils._("Viewing logs"));
                Utils.unsetWaitCursor(null);
            }
        };
        this.actViewLog.putValue("Name", Utils._("View log") + "...");
        this.actViewLog.putValue("ShortDescription", Utils._("Displays the communication log of the selected fax"));
        this.actViewLog.putValue("SmallIcon", Utils.loadIcon("general/History"));
        this.putAvailableAction("ViewLog", this.actViewLog);
        this.actLogConsole = new ExcDialogAbstractAction(){
            LogConsole logCons;

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (this.logCons == null) {
                    Utils.setWaitCursor(null);
                    this.logCons = new LogConsole();
                    this.logCons.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            logCons = null;
                        }
                    });
                    Utils.unsetWaitCursorOnOpen(null, this.logCons);
                    this.logCons.setVisible(true);
                } else {
                    this.logCons.toFront();
                }
            }
        };
        this.actLogConsole.putValue("Name", Utils._("Log console") + "...");
        this.actLogConsole.putValue("ShortDescription", Utils._("Displays the YajHFC log in real time"));
        this.putAvailableAction("LogConsole", this.actLogConsole);
        this.actShowToolbar = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                MainWin.this.toolbar.setVisible(bl2);
                MainWin.this.myopts.showToolbar = bl2;
                this.putValue("selected", bl2);
            }
        };
        this.actShowToolbar.putValue("Name", Utils._("Show Toolbar"));
        this.actShowToolbar.putValue("ShortDescription", Utils._("Shows or hides the toolbar."));
        this.actShowToolbar.putValue("selected", this.myopts.showToolbar);
        this.putAvailableAction("ShowToolbar", this.actShowToolbar);
        this.actShowQuickSearchBar = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? false : bl == false;
                MainWin.this.quickSearchbar.setVisible(bl2);
                MainWin.this.myopts.showQuickSearchbar = bl2;
                this.putValue("selected", bl2);
            }
        };
        this.actShowQuickSearchBar.putValue("Name", Utils._("Show Quick Search bar"));
        this.actShowQuickSearchBar.putValue("ShortDescription", Utils._("Show or hides the Quick Search toolbar."));
        this.actShowQuickSearchBar.putValue("selected", this.myopts.showQuickSearchbar);
        this.putAvailableAction("ShowQuickSearchBar", this.actShowQuickSearchBar);
        this.actServerSelectionPopup = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof Component) {
                    Component component = (Component)actionEvent.getSource();
                    Utils.clonePopupFromMenu(MainWin.this.serverMenu.getMenu()).show(component, 0, component.getHeight());
                }
            }
        };
        this.actServerSelectionPopup.putValue("Name", "...");
        this.actServerSelectionPopup.putValue("ShortDescription", Utils._("Shows/Changes the current server."));
        this.putAvailableAction("ServerSelectionPopup", this.actServerSelectionPopup);
        this.actSelectAll = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                if (tooltipJTable.getRowCount() > 0) {
                    tooltipJTable.getSelectionModel().addSelectionInterval(0, tooltipJTable.getRowCount() - 1);
                }
            }
        };
        this.actSelectAll.putValue("Name", Utils._("Select All"));
        this.actSelectAll.putValue("ShortDescription", Utils._("Selects all rows"));
        this.putAvailableAction("SelectAll", this.actSelectAll);
        this.actEditComment = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
                int n = tooltipJTable.getRealModel().getColumns().getVirtualColumnIndex(VirtualColumnType.USER_COMMENT);
                if (n < 0) {
                    return;
                }
                FaxJob<? extends FmtItem>[] faxJobArray = tooltipJTable.getSelectedJobs();
                String string = null;
                for (FaxJob<? extends FmtItem> faxJobArray2 : faxJobArray) {
                    String string2 = (String)faxJobArray2.getData(n);
                    if (string2 == null || string2.length() <= 0) continue;
                    string = string2;
                    break;
                }
                if (string == null) {
                    string = "";
                }
                JTextArea jTextArea = new JTextArea(4, 60);
                jTextArea.setLineWrap(true);
                jTextArea.setEditable(true);
                ClipboardPopup.DEFAULT_POPUP.addToComponent(jTextArea);
                jTextArea.setText(string);
                Object[] objectArray = new Object[]{new JScrollPane(jTextArea, 20, 31)};
                if (JOptionPane.showConfirmDialog(MainWin.this, objectArray, Utils._("Edit user comment"), 2, -1) == 0) {
                    String string3 = jTextArea.getText();
                    for (FaxJob<? extends FmtItem> faxJob : faxJobArray) {
                        faxJob.setData(n, (Object)string3);
                    }
                }
            }
        };
        this.actEditComment.putValue("Name", Utils._("Edit user comment") + "...");
        this.actEditComment.putValue("ShortDescription", Utils._("Edit this job's user comment"));
        this.putAvailableAction("EditComment", this.actEditComment);
        this.actAutoSizeStatus = new StatusBarResizeAction();
        this.actAutoSizeStatus.putValue("Name", Utils._("Auto-size status bar"));
        this.actAutoSizeStatus.putValue("ShortDescription", Utils._("Automatically resize the status bar"));
        this.putAvailableAction("AutoSizeStatus", this.actAutoSizeStatus);
        this.actSaveAsPDF = new SaveToFormatAction(MultiFileConvFormat.PDF);
        this.putAvailableAction("SaveAsPDF", this.actSaveAsPDF);
        this.actSaveAsTIFF = new SaveToFormatAction(MultiFileConvFormat.TIFF);
        this.putAvailableAction("SaveAsTIFF", this.actSaveAsTIFF);
        this.actExport = new ExportAction(this);
        this.putAvailableAction("ExportTable", this.actExport);
        for (PluginUI pluginUI : PluginManager.pluginUIs) {
            try {
                Map<String, Action> map = pluginUI.createToolbarActions();
                if (map == null) continue;
                String string = pluginUI.getUniqueName();
                for (Map.Entry<String, Action> entry : map.entrySet()) {
                    this.putAvailableAction(string + '.' + entry.getKey(), entry.getValue());
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error initializing plugin " + pluginUI, exception);
            }
        }
        this.menuViewListener = new MenuViewListener();
        this.actChecker = new ActionEnabler();
        AcceleratorKeys.loadFromMap(this.myopts.keyboardAccelerators, this.availableActions);
    }

    private void putAvailableAction(String string, Action action) {
        if (this.availableActions.put(string, action) != null) {
            log.severe("Action " + string + " already existed!");
        }
        action.putValue("ActionCommandKey", string);
    }

    void putAvailableAction(Action action) {
        String string = (String)action.getValue("ActionCommandKey");
        if (this.availableActions.put(string, action) != null) {
            log.severe("Action " + string + " already existed!");
        }
    }

    public TooltipJTable<? extends FmtItem> getSelectedTable() {
        return (TooltipJTable)((JScrollPane)this.tabMain.getSelectedComponent()).getViewport().getView();
    }

    public TooltipJTable<? extends FmtItem> getTableByIndex(int n) {
        return (TooltipJTable)((JScrollPane)this.tabMain.getComponent(n)).getViewport().getView();
    }

    public ProgressPanel getTablePanel() {
        return this.tablePanel;
    }

    public String getSelectedTableDescription() {
        return this.tabMain.getToolTipTextAt(this.tabMain.getSelectedIndex());
    }

    void setActReconnectState(boolean bl) {
        this.actReconnect.putValue("Name", bl ? Utils._("Connect") : Utils._("Disconnect"));
        this.actReconnect.putValue("SmallIcon", Utils.loadCustomIcon(bl ? "disconnected.png" : "connected.png"));
    }

    public JPopupMenu getTablePopupMenu() {
        if (this.tblPopup == null) {
            this.tblPopup = new JPopupMenu(Utils._("Fax"));
            this.tblPopup.add(new JMenuItem(this.actShow));
            this.tblPopup.add(new JMenuItem(this.actFaxSave));
            this.tblPopup.add(new JMenuItem(this.actSaveAsPDF));
            this.tblPopup.add(new JMenuItem(this.actSaveAsTIFF));
            this.tblPopup.add(new JMenuItem(this.actViewLog));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new JMenuItem(this.actClipCopy));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new JMenuItem(this.actForward));
            this.tblPopup.add(new JMenuItem(this.actResend));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new JMenuItem(this.actDelete));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new JMenuItem(this.actSuspend));
            this.tblPopup.add(new JMenuItem(this.actResume));
            this.tblPopup.add(new JMenuItem(this.actEditJob));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new ActionJCheckBoxMenuItem(this.actFaxRead));
            this.tblPopup.add(new JMenuItem(this.actEditComment));
            this.tblPopup.addSeparator();
            this.tblPopup.add(new JMenuItem(this.actSelectAll));
        }
        return this.tblPopup;
    }

    public void refreshTables() {
        this.tablePanel.showIndeterminateProgress(Utils._("Fetching fax list..."));
        this.connection.addFaxListConnectionListener(new RefreshCompleteHider(this.tablePanel, this.connection));
        Utils.executorService.submit(new Runnable(){

            public void run() {
                MainWin.this.connection.refreshFaxLists();
            }
        });
    }

    public void refreshStatus() {
        Utils.executorService.submit(new Runnable(){

            public void run() {
                MainWin.this.connection.refreshStatus();
            }
        });
    }

    @Override
    public SendReadyState getSendReadyState() {
        return this.sendReady;
    }

    public void setSelectedTab(int n) {
        if (n >= 0 && n < this.getTabMain().getTabCount()) {
            this.getTabMain().setSelectedIndex(n);
        }
    }

    private MouseListener getTblMouseListener() {
        if (this.tblMouseListener == null) {
            this.tblMouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JTable jTable;
                    int n;
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = (jTable = (JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint())) >= 0 && jTable.getSelectedRow() == n) {
                        MainWin.this.actShow.actionPerformed(null);
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }

                private void maybeShowPopup(MouseEvent mouseEvent) {
                    JTable jTable;
                    int n;
                    if (mouseEvent.isPopupTrigger() && (n = (jTable = (JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint())) >= 0) {
                        if (!jTable.isRowSelected(n)) {
                            jTable.setRowSelectionInterval(n, n);
                        }
                        MainWin.this.getTablePopupMenu().show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
        }
        return this.tblMouseListener;
    }

    private DefaultTableCellRenderer getHylaDateRenderer() {
        if (this.hylaDateRenderer == null) {
            this.hylaDateRenderer = new DefaultTableCellRenderer(){
                private final StringBuffer formatBuffer = new StringBuffer();
                private final FieldPosition dummyPos = new FieldPosition(0);

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (object != null) {
                        int n3 = jTable.getColumnModel().getColumn(n2).getModelIndex();
                        FaxListTableModel faxListTableModel = ((TooltipJTable)jTable).getRealModel();
                        this.formatBuffer.setLength(0);
                        object = ((FmtItem)faxListTableModel.getColumns().get(n3)).getDisplayDateFormat().format(object, this.formatBuffer, this.dummyPos).toString();
                    }
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }
        return this.hylaDateRenderer;
    }

    private JPopupMenu getToolbarPopup() {
        if (this.toolbarPopup == null) {
            this.toolbarPopup = new JPopupMenu();
            this.toolbarPopup.add(new ActionJCheckBoxMenuItem(this.actShowToolbar));
            this.toolbarPopup.add(new ActionJCheckBoxMenuItem(this.actShowQuickSearchBar));
            this.toolbarPopup.addSeparator();
            this.toolbarPopup.add(new JMenuItem(this.actEditToolbar));
        }
        return this.toolbarPopup;
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setVisible(this.myopts.showToolbar);
            this.toolbar.setComponentPopupMenu(this.getToolbarPopup());
            ToolbarEditorDialog.loadConfigFromString(this.toolbar, this.myopts.toolbarConfig, this.availableActions);
        }
        return this.toolbar;
    }

    public JMenu getMenuView() {
        if (this.menuView == null) {
            this.menuView = new JMenu(Utils._("View"));
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.menuViewListener.createMenuItems()) {
                this.menuView.add(jRadioButtonMenuItem);
            }
            this.menuView.addSeparator();
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actMarkFailedJobs));
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actShowRowNumbers));
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actAdjustColumns));
            this.menuView.addSeparator();
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actAutoSizeStatus));
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actShowToolbar));
            this.menuView.add(new ActionJCheckBoxMenuItem(this.actShowQuickSearchBar));
            this.menuView.addSeparator();
            this.menuView.add(new JMenuItem(this.actRefresh));
            this.getTabMain().addChangeListener(this.menuViewListener);
        }
        return this.menuView;
    }

    public void initialize(boolean bl, String string) {
        this.myopts = Utils.getFaxOptions();
        this.createActions(bl);
        if (string != null) {
            ServerOptions serverOptions = IDAndNameOptions.getItemFromCommandLineCoding(this.myopts.servers, string);
            if (serverOptions != null) {
                this.setCurrentServerByID(serverOptions.id);
            } else {
                this.setCurrentServerByID(this.myopts.lastServerID);
            }
        } else {
            this.setCurrentServerByID(this.myopts.lastServerID);
        }
        this.setFaxListConnectionFromServer();
        this.initializePlatformSpecifics();
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(644, 466);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Yet Another Java HylaFAX Client (YajHFC)");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                MainWin.this.sendReady = SendReadyState.NotReady;
                MainWin.this.saveWindowSettings();
                if (MainWin.this.connection.getConnectionState() == ConnectionState.CONNECTED) {
                    MainWin.this.doLogout(false, new Runnable(){

                        public void run() {
                            Thread.yield();
                            System.exit(0);
                        }
                    });
                } else {
                    Thread.yield();
                    System.exit(0);
                }
            }
        });
        Utils.setDefaultIcons(this);
        this.reloadTableColumnSettings();
        this.menuViewListener.loadFromOptions(this.myopts);
        if (this.myopts.mainWinBounds != null) {
            this.setBounds(this.myopts.mainWinBounds);
        } else {
            Utils.setDefWinPos(this);
        }
        this.tabMain.setSelectedIndex(this.myopts.mainwinLastTab);
        this.actChecker.doEnableCheck();
        this.showOrHideTrayIcon();
        this.setDisconnectedUI();
        for (PluginUI pluginUI : PluginManager.pluginUIs) {
            try {
                pluginUI.configureMainWin(this);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error initializing plugin " + pluginUI, exception);
            }
        }
        if (this.myopts.automaticallyCheckForUpdate) {
            UpdateChecker.startSilentUpdateCheck();
        }
    }

    @Override
    public void saveWindowSettings() {
        this.saveTableColumnSettings();
        this.myopts.lastServerID = this.currentServer.getID();
        this.menuViewListener.saveToOptions(this.myopts);
        this.myopts.mainwinLastTab = this.getTabMain().getSelectedIndex();
        this.myopts.mainWinBounds = this.getBounds();
        Boolean bl = (Boolean)this.actShowRowNumbers.getValue("selected");
        this.myopts.showRowNumbers = bl != null && bl != false;
        bl = (Boolean)this.actAdjustColumns.getValue("selected");
        this.myopts.adjustColumnWidths = bl != null && bl != false;
        this.myopts.toolbarConfig = ToolbarEditorDialog.saveConfigToString(this.toolbar);
        this.myopts.statusBarSize = this.actAutoSizeStatus.isSelected() ? -1 : this.statusSplitter.getHeight() - this.statusSplitter.getDividerLocation();
    }

    void initializePlatformSpecifics() {
        if (PlatformInfo.IS_MACOSX) {
            MacOSXSupport macOSXSupport = MacOSXSupport.getInstance();
            if (macOSXSupport != null) {
                macOSXSupport.setApplicationMenuActions(this, this.actOptions, this.actAbout, this.actExit);
                this.hideMenusForMac = this.myopts.adjustMenusForMacOSX;
                macOSXSupport.setDockIconImage(Toolkit.getDefaultToolkit().getImage(MainWin.class.getResource("logo-large.png")));
            }
            this.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        }
    }

    void showOrHideTrayIcon() {
        if (this.myopts.showTrayIcon) {
            if (this.trayIcon == null && TrayFactory.trayIsAvailable()) {
                this.trayIcon = new YajHFCTrayIcon(this, this.recvTableModel, this.actSend, this.actReconnect, null, this.actExit, null, this.actAbout);
            }
            if (this.trayIcon != null && this.trayIcon.isValid()) {
                this.setDefaultCloseOperation(this.myopts.minimizeToTrayOnMainWinClose ? 1 : 2);
                this.trayIcon.setMinimizeToTray(this.myopts.minimizeToTray);
                TrayFactory.checkForProblematicPlatformAsync();
            } else {
                this.trayIcon = null;
                this.setDefaultCloseOperation(2);
            }
        } else {
            if (this.trayIcon != null) {
                this.trayIcon.dispose();
                this.trayIcon = null;
            }
            this.setDefaultCloseOperation(2);
        }
    }

    public boolean hasTrayIcon() {
        return this.trayIcon != null;
    }

    private void saveTableColumnSettings() {
        if (this.connection.getConnectionState() == ConnectionState.CONNECTED) {
            this.myopts.recvColState = this.getTableRecv().getColumnCfgString();
            this.myopts.sentColState = this.getTableSent().getColumnCfgString();
            this.myopts.sendingColState = this.getTableSending().getColumnCfgString();
            if (this.tableArchive != null) {
                this.myopts.archiveColState = this.tableArchive.getColumnCfgString();
            }
        }
    }

    void doLogout(boolean bl) {
        this.doLogout(bl, null);
    }

    void doLogout(final boolean bl, final Runnable runnable) {
        try {
            log.fine("Logging out...");
            this.stopReconnectTimer();
            SendReadyState sendReadyState = this.sendReady = bl ? SendReadyState.NeedToWait : SendReadyState.NotReady;
            if (Utils.debugMode) {
                log.fine("Logout ConnectionState is: " + (Object)((Object)this.connection.getConnectionState()));
            }
            if (this.connection.getConnectionState() == ConnectionState.CONNECTED) {
                this.saveTableColumnSettings();
                this.tablePanel.showIndeterminateProgress(Utils._("Logging out..."));
                this.userInitiatedLogout = true;
                Utils.executorService.submit(new Runnable(){

                    public void run() {
                        MainWin.this.connection.disconnect();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (runnable != null) {
                                    runnable.run();
                                }
                                if (bl) {
                                    MainWin.this.reconnectToServer(null, true);
                                } else {
                                    MainWin.this.tablePanel.hideProgress();
                                }
                            }
                        });
                    }
                });
            } else {
                this.setDisconnectedUI();
                if (runnable != null) {
                    runnable.run();
                }
                if (bl) {
                    this.reconnectToServer(null, true);
                }
            }
            log.fine("Successfully initiated log out");
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error logging out:", exception);
        }
    }

    protected void setDisconnectedUI() {
        this.getTextStatus().setBackground(this.getDefStatusBackground());
        this.getTextStatus().setText(Utils._("Disconnected."));
        this.actSend.setEnabled(false);
        this.actPoll.setEnabled(false);
        this.menuView.setEnabled(false);
        this.actAnswerCall.setEnabled(false);
        this.setActReconnectState(true);
        this.setTitle("Disconnected - Yet Another Java HylaFAX Client (YajHFC)");
        if (this.trayIcon != null) {
            this.trayIcon.setConnectedState(false);
        }
        this.setEnabled(true);
    }

    void reloadTableColumnSettings() {
        this.tableRecv.setColumnCfgString(this.myopts.recvColState);
        this.tableSent.setColumnCfgString(this.myopts.sentColState);
        this.tableSending.setColumnCfgString(this.myopts.sendingColState);
        if (this.currentServer.getOptions().showArchive && this.tableArchive != null) {
            this.tableArchive.setColumnCfgString(this.myopts.archiveColState);
        }
    }

    public void reconnectToServer(Runnable runnable, boolean bl) {
        this.stopReconnectTimer();
        if (this.currentServer.getOptions().host == null || this.currentServer.getOptions().host.length() == 0) {
            this.actOptions.actionPerformed(null);
            return;
        }
        this.setEnabled(false);
        this.tablePanel.showIndeterminateProgress(Utils._("Logging in..."));
        this.userInitiatedLogout = false;
        Utils.executorService.submit(new LoginThread((Boolean)this.actAdminMode.getValue("selected"), runnable, bl));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.tablePanel = new ProgressPanel();
            this.tablePanel.setContentComponent(this.getStatusSplitter());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.tablePanel, "Center");
            this.quickSearchbar = this.quickSearchHelper.getQuickSearchBar(this.actSearchFax);
            jPanel.add((Component)this.quickSearchbar, "North");
            this.quickSearchbar.setVisible(this.myopts.showQuickSearchbar);
            this.quickSearchbar.setComponentPopupMenu(this.getToolbarPopup());
            this.jContentPane.add((Component)jPanel, "Center");
            this.jContentPane.add((Component)this.getToolbar(), "North");
        }
        return this.jContentPane;
    }

    private JSplitPane getStatusSplitter() {
        if (this.statusSplitter == null) {
            this.statusSplitter = new JSplitPane(0, this.getTabMain(), new JScrollPane(this.getTextStatus(), 20, 31));
            this.statusSplitter.setOneTouchExpandable(true);
            this.statusSplitter.setResizeWeight(1.0);
            this.statusSplitter.setBorder(null);
            this.textStatus.getDocument().addDocumentListener(this.actAutoSizeStatus);
            this.statusSplitter.addPropertyChangeListener("dividerLocation", this.actAutoSizeStatus);
            this.addWindowListener(this.actAutoSizeStatus);
        }
        return this.statusSplitter;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getMenuFax());
            this.jJMenuBar.add(this.getMenuTable());
            this.jJMenuBar.add(this.getServerMenu().getMenu());
            this.jJMenuBar.add(this.getMenuView());
            this.jJMenuBar.add(this.getMenuExtras());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(Utils._("Help"));
            this.helpMenu.add(new JMenuItem(this.actReadme));
            this.helpMenu.addSeparator();
            this.helpMenu.add(new JMenuItem(this.actUpdateCheck));
            this.helpMenu.add(new JMenuItem(this.actLogConsole));
            if (!this.hideMenusForMac) {
                this.helpMenu.add(new JMenuItem(this.actAbout));
            }
        }
        return this.helpMenu;
    }

    public JTabbedPane getTabMain() {
        if (this.tabMain == null) {
            this.tabMain = new JTabbedPane();
            this.tabMain.addTab(Utils._("Received"), Utils.loadCustomIcon("received.gif"), this.getScrollRecv(), Utils._("Received faxes"));
            this.tabMain.addTab(Utils._("Sent"), Utils.loadCustomIcon("sent.gif"), this.getScrollSent(), Utils._("Sent faxes"));
            this.tabMain.addTab(Utils._("Transmitting"), Utils.loadCustomIcon("sending.gif"), this.getScrollSending(), Utils._("Faxes in the output queue"));
            this.addOrRemoveArchiveTab();
            this.tabMain.addChangeListener(this.actChecker);
            this.tabMain.addChangeListener(this.quickSearchHelper);
        }
        return this.tabMain;
    }

    void addOrRemoveArchiveTab() {
        if (this.currentServer.getOptions().showArchive) {
            if (this.scrollArchive == null || this.tabMain.indexOfComponent(this.scrollArchive) < 0) {
                this.tabMain.addTab(Utils._("Archive"), Utils.loadCustomIcon("archive.gif"), this.getScrollArchive());
            }
        } else if (this.scrollArchive != null) {
            this.tabMain.remove(this.scrollArchive);
        }
    }

    private JScrollPane getScrollRecv() {
        if (this.scrollRecv == null) {
            this.scrollRecv = new JScrollPane();
            this.scrollRecv.setViewportView(this.getTableRecv());
            this.recvRowNumbers = new NumberRowViewport(this.tableRecv, this.scrollRecv);
            this.recvRowNumbers.setVisible(this.myopts.showRowNumbers);
        }
        return this.scrollRecv;
    }

    public TooltipJTable<RecvFormat> getTableRecv() {
        if (this.tableRecv == null) {
            this.tableRecv = new TooltipJTable<RecvFormat>(this.getRecvTableModel());
            this.doCommonTableSetup(this.tableRecv);
            this.recvTableModel.setUnreadFont(this.tableRecv.getFont().deriveFont(1));
        }
        return this.tableRecv;
    }

    Color getDefStatusBackground() {
        Color color = UIManager.getColor("control");
        if (color == null) {
            color = new Color(230, 230, 230);
        }
        return color;
    }

    private JTextPane getTextStatus() {
        if (this.textStatus == null) {
            this.textStatus = new JTextPane(){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = Integer.MAX_VALUE;
                    return dimension;
                }
            };
            this.textStatus.setBackground(this.getDefStatusBackground());
            this.textStatus.setFont(new Font("DialogInput", 0, 12));
            this.textStatus.setEditable(false);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new JMenuItem(new ExcDialogAbstractAction(Utils._("Copy"), Utils.loadIcon("general/Copy")){

                protected void actualActionPerformed(ActionEvent actionEvent) {
                    StringSelection stringSelection = new StringSelection(MainWin.this.textStatus.getText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            }));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ActionJCheckBoxMenuItem(this.actAutoSizeStatus));
            this.textStatus.setComponentPopupMenu(jPopupMenu);
        }
        return this.textStatus;
    }

    @Override
    public void bringToFront() {
        int n;
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (((n = this.getExtendedState()) & 1) != 0) {
            this.setExtendedState(n & 0xFFFFFFFE);
        }
        this.toFront();
    }

    public ReadStateFaxListTableModel<RecvFormat> getRecvTableModel() {
        if (this.recvTableModel == null) {
            this.recvTableModel = new ReadStateFaxListTableModel<RecvFormat>(this.connection.getReceivedJobs());
            this.recvTableModel.addUnreadItemListener(new UnreadItemListener<RecvFormat>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void newItemsAvailable(UnreadItemEvent<RecvFormat> unreadItemEvent) {
                    if (unreadItemEvent.isOldDataNull()) {
                        return;
                    }
                    if ((MainWin.this.myopts.newFaxAction & 2) != 0) {
                        MainWin.this.bringToFront();
                    }
                    if ((MainWin.this.myopts.newFaxAction & 1) != 0) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if ((MainWin.this.myopts.newFaxAction & 4) != 0) {
                        try {
                            MainWin.this.connection.beginMultiOperation();
                            try {
                                for (FaxJob<RecvFormat> faxJob : unreadItemEvent.getItems()) {
                                    for (FaxDocument faxDocument : faxJob.getDocuments()) {
                                        try {
                                            faxDocument.getDocument().view();
                                        }
                                        catch (Exception exception) {
                                            log.log(Level.WARNING, "Exception while trying to view new faxes:", exception);
                                        }
                                    }
                                    if ((MainWin.this.myopts.newFaxAction & 8) == 0) continue;
                                    faxJob.setRead(true);
                                }
                            }
                            finally {
                                MainWin.this.connection.endMultiOperation();
                            }
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog(MainWin.this, "Exception while trying to view new faxes:", exception);
                        }
                    }
                }

                @Override
                public void readStateChanged() {
                }
            });
        }
        return this.recvTableModel;
    }

    private JScrollPane getScrollSent() {
        if (this.scrollSent == null) {
            this.scrollSent = new JScrollPane();
            this.scrollSent.setViewportView(this.getTableSent());
            this.sentRowNumbers = new NumberRowViewport(this.tableSent, this.scrollSent);
            this.sentRowNumbers.setVisible(this.myopts.showRowNumbers);
        }
        return this.scrollSent;
    }

    public TooltipJTable<JobFormat> getTableSent() {
        if (this.tableSent == null) {
            this.tableSent = new TooltipJTable<JobFormat>(this.getSentTableModel());
            this.doCommonTableSetup(this.tableSent);
        }
        return this.tableSent;
    }

    public FaxListTableModel<JobFormat> getSentTableModel() {
        if (this.sentTableModel == null) {
            this.sentTableModel = new FaxListTableModel<JobFormat>(this.connection.getSentJobs());
        }
        return this.sentTableModel;
    }

    private JScrollPane getScrollSending() {
        if (this.scrollSending == null) {
            this.scrollSending = new JScrollPane();
            this.scrollSending.setViewportView(this.getTableSending());
            this.sendingRowNumbers = new NumberRowViewport(this.tableSending, this.scrollSending);
            this.sendingRowNumbers.setVisible(this.myopts.showRowNumbers);
        }
        return this.scrollSending;
    }

    public TooltipJTable<JobFormat> getTableSending() {
        if (this.tableSending == null) {
            this.tableSending = new TooltipJTable<JobFormat>(this.getSendingTableModel());
            this.doCommonTableSetup(this.tableSending);
        }
        return this.tableSending;
    }

    private void doCommonTableSetup(TooltipJTable<? extends FmtItem> tooltipJTable) {
        tooltipJTable.setShowGrid(true);
        tooltipJTable.setSelectionMode(2);
        tooltipJTable.getSelectionModel().addListSelectionListener(this.actChecker);
        tooltipJTable.addMouseListener(this.getTblMouseListener());
        tooltipJTable.getActionMap().put("yajhfc-show", this.actShow);
        tooltipJTable.getActionMap().put("yajhfc-delete", this.actDelete);
        InputMap inputMap = tooltipJTable.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "yajhfc-show");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "yajhfc-delete");
        tooltipJTable.setDefaultRenderer(Date.class, this.getHylaDateRenderer());
        tooltipJTable.setDefaultRenderer(IconMap.class, new IconMap.TableCellRenderer());
        JTableTABAction.replaceTABWithNextRow(tooltipJTable);
    }

    public FaxListTableModel<JobFormat> getSendingTableModel() {
        if (this.sendingTableModel == null) {
            this.sendingTableModel = new FaxListTableModel<JobFormat>(this.connection.getSendingJobs());
        }
        return this.sendingTableModel;
    }

    FaxListTableModel<QueueFileFormat> getArchiveTableModel() {
        if (this.archiveTableModel == null) {
            this.archiveTableModel = new FaxListTableModel<QueueFileFormat>(this.connection.getArchivedJobs());
        }
        return this.archiveTableModel;
    }

    JScrollPane getScrollArchive() {
        if (this.scrollArchive == null) {
            this.tableArchive = new TooltipJTable<QueueFileFormat>(this.getArchiveTableModel());
            this.doCommonTableSetup(this.tableArchive);
            this.scrollArchive = new JScrollPane(this.tableArchive);
            this.archiveRowNumbers = new NumberRowViewport(this.tableArchive, this.scrollArchive);
            this.archiveRowNumbers.setVisible(this.myopts.showRowNumbers);
        }
        return this.scrollArchive;
    }

    public JMenu getMenuFax() {
        if (this.menuFax == null) {
            this.menuFax = new JMenu();
            this.menuFax.setText(Utils._("Fax"));
            this.menuFax.add(new JMenuItem(this.actSend));
            this.menuFax.add(new JMenuItem(this.actPoll));
            this.menuFax.add(new JMenuItem(this.actForward));
            this.menuFax.add(new JMenuItem(this.actResend));
            this.menuFax.addSeparator();
            this.menuFax.add(new JMenuItem(this.actShow));
            this.menuFax.add(new JMenuItem(this.actFaxSave));
            this.menuFax.add(new JMenuItem(this.actSaveAsPDF));
            this.menuFax.add(new JMenuItem(this.actSaveAsTIFF));
            this.menuFax.add(new JMenuItem(this.actViewLog));
            this.menuFax.add(new JMenuItem(this.actDelete));
            this.menuFax.addSeparator();
            this.menuFax.add(new JMenuItem(this.actResume));
            this.menuFax.add(new JMenuItem(this.actSuspend));
            this.menuFax.add(new JMenuItem(this.actEditJob));
            this.menuFax.addSeparator();
            this.menuFax.add(new ActionJCheckBoxMenuItem(this.actFaxRead));
            this.menuFax.add(new JMenuItem(this.actEditComment));
            if (!this.hideMenusForMac) {
                this.menuFax.addSeparator();
                this.menuFax.add(new JMenuItem(this.actExit));
            }
        }
        return this.menuFax;
    }

    public JMenu getMenuTable() {
        if (this.menuTable == null) {
            this.menuTable = new JMenu(Utils._("Table"));
            this.menuTable.add(new JMenuItem(this.actSearchFax));
            this.menuTable.addSeparator();
            this.menuTable.add(new JMenuItem(this.actClipCopy));
            this.menuTable.add(new JMenuItem(this.actPrintTable));
            this.menuTable.add(new JMenuItem(this.actExport));
            this.menuTable.addSeparator();
            this.menuTable.add(new JMenuItem(this.actSelectAll));
        }
        return this.menuTable;
    }

    public JMenu getMenuExtras() {
        if (this.menuExtras == null) {
            this.menuExtras = new JMenu(Utils._("Extras"));
            this.menuExtras.add(this.actPhonebook);
            this.menuExtras.addSeparator();
            if (!this.hideMenusForMac) {
                this.menuExtras.add(new JMenuItem(this.actOptions));
            }
            this.menuExtras.add(new JMenuItem(this.actEditToolbar));
            this.menuExtras.add(new JMenuItem(this.actEditAccelerators));
            this.menuExtras.addSeparator();
            this.menuExtras.add(new JMenuItem(this.actReconnect));
            this.menuExtras.add(new ActionJCheckBoxMenuItem(this.actAdminMode));
            this.menuExtras.addSeparator();
            this.menuExtras.add(new JMenuItem(this.actAnswerCall));
            if (PluginManager.pluginUIs.size() > 0) {
                boolean bl = false;
                for (PluginUI pluginUI : PluginManager.pluginUIs) {
                    JMenuItem[] jMenuItemArray = pluginUI.createMenuItems();
                    if (jMenuItemArray == null) continue;
                    for (JMenuItem jMenuItem : jMenuItemArray) {
                        if (!bl) {
                            this.menuExtras.addSeparator();
                            bl = true;
                        }
                        this.menuExtras.add(jMenuItem);
                    }
                }
            }
        }
        return this.menuExtras;
    }

    protected ServerMenu getServerMenu() {
        if (this.serverMenu == null) {
            this.serverMenu = new ServerMenu();
            if (this.currentServer != null) {
                this.serverMenu.setSelectionByID(this.currentServer.getID());
            }
        }
        return this.serverMenu;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public YajOptionPane getDialogUI() {
        return this.dialogUI;
    }

    void refreshFilter() {
        this.refreshFilter(this.getSelectedTable().getRealModel());
    }

    void refreshFilter(FaxListTableModel faxListTableModel) {
        TableType tableType = faxListTableModel.getTableType();
        Filter<FaxJob<? extends FmtItem>, ? extends FmtItem> filter = this.menuViewListener.getFilterFor(tableType);
        Filter<FaxJob<? extends FmtItem>, ? extends FmtItem> filter2 = this.quickSearchHelper.getFilterFor(tableType);
        Filter<FaxJob<? extends FmtItem>, ? extends FmtItem> filter3 = filter == null ? (filter2 == null ? null : filter2) : (filter2 == null ? filter : new AndFilter<FaxJob<? extends FmtItem>, FmtItem>(filter, filter2));
        faxListTableModel.setJobFilter(filter3);
    }

    public HylaClientManager getClientManager() {
        return this.connection.getClientManager();
    }

    protected void setCurrentServerByID(int n) {
        ServerManager serverManager = ServerManager.getDefault();
        if (!serverManager.setCurrentByID(n) && serverManager.getServers().size() > 0) {
            serverManager.setCurrentByIndex(0);
        }
        this.currentServer = serverManager.getCurrent();
        this.actServerSelectionPopup.putValue("Name", this.currentServer.toString());
    }

    protected void switchServer(final int n) {
        this.doLogout(true, new Runnable(){

            public void run() {
                MainWin.this.setCurrentServerByID(n);
                MainWin.this.addOrRemoveArchiveTab();
                if (MainWin.this.currentServer.getConnection() == MainWin.this.connection) {
                    MainWin.this.getRecvTableModel().fireTableStructureChanged();
                    MainWin.this.getSentTableModel().fireTableStructureChanged();
                    MainWin.this.getSendingTableModel().fireTableStructureChanged();
                    if (MainWin.this.currentServer.getOptions().showArchive) {
                        MainWin.this.getArchiveTableModel().fireTableStructureChanged();
                    }
                } else {
                    MainWin.this.setFaxListConnectionFromServer();
                    MainWin.this.getRecvTableModel().setJobs(MainWin.this.connection.getReceivedJobs());
                    MainWin.this.getSentTableModel().setJobs(MainWin.this.connection.getSentJobs());
                    MainWin.this.getSendingTableModel().setJobs(MainWin.this.connection.getSendingJobs());
                    if (MainWin.this.currentServer.getOptions().showArchive) {
                        MainWin.this.getArchiveTableModel().setJobs(MainWin.this.connection.getArchivedJobs());
                    }
                }
                MainWin.this.serverMenu.setSelectionByID(n);
            }
        });
    }

    protected void optionsChanged() {
        this.showOrHideTrayIcon();
        ServerManager.getDefault().optionsChanged();
        this.serverMenu.refreshMenuItems();
        this.switchServer(this.currentServer.getID());
    }

    void setFaxListConnectionFromServer() {
        if (this.currentServer == null) {
            return;
        }
        try {
            if (this.connection != null) {
                this.connection.removeFaxListConnectionListener(this.connListener);
            }
            this.connection = this.currentServer.getConnection();
            this.connection.addFaxListConnectionListener(this.connListener);
        }
        catch (Exception exception) {
            if (this.currentServer.getOptions().faxListConnectionType == FaxListConnectionType.HYLAFAX) {
                ExceptionDialog.showExceptionDialog(this, "Error creating FaxListConnection, exiting YajHFC.", exception);
                System.exit(1);
            }
            ExceptionDialog.showExceptionDialog(this, "Error creating FaxListConnection, fallling back to default.", exception);
            this.currentServer.getOptions().faxListConnectionType = FaxListConnectionType.HYLAFAX;
            this.setFaxListConnectionFromServer();
        }
    }

    protected void setupReconnectTimer() {
        if (this.reconnectTimer == null) {
            this.reconnectTimer = new Timer(1000, null);
            this.reconnectTimer.setInitialDelay(0);
            this.reconnectTimer.addActionListener(new ActionListener(){
                private int counter = 30;
                private MessageFormat reconnectFmt = new MessageFormat(Utils._("Disconnected, will try to reconnect in {0} seconds..."));

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.counter > 0) {
                        MainWin.this.textStatus.setText(this.reconnectFmt.format(new Object[]{this.counter}));
                        --this.counter;
                    } else {
                        MainWin.this.textStatus.setText(Utils._("Trying to reconnect..."));
                        MainWin.this.reconnectTimer.stop();
                        MainWin.this.reconnectTimer = null;
                        MainWin.this.reconnectToServer(null, false);
                    }
                }
            });
            this.reconnectTimer.start();
        }
    }

    private void stopReconnectTimer() {
        if (this.reconnectTimer != null && this.reconnectTimer.isRunning()) {
            this.reconnectTimer.stop();
            this.reconnectTimer = null;
        }
    }

    class ServerMenu
    implements ActionListener {
        private static final int ITEMS_PER_SUBMENU = 10;
        private static final int SUBMENU_THRESHOLD = 12;
        private static final int SUBMENU_STRLEN = 8;
        protected JMenu serverMenu;
        protected final List<JRadioButtonMenuItem> serverMenuItems = new ArrayList<JRadioButtonMenuItem>();
        protected ButtonGroup serverGroup;

        public ServerMenu() {
            this.serverMenu = new JMenu(Utils._("Server"));
            this.serverGroup = new ButtonGroup();
            this.refreshMenuItems();
        }

        public JMenu getMenu() {
            return this.serverMenu;
        }

        public void refreshMenuItems() {
            Map<String, JRadioButtonMenuItem> map;
            if (this.serverMenuItems.size() > 0) {
                map = new HashMap();
                for (JRadioButtonMenuItem jRadioButtonMenuItem : this.serverMenuItems) {
                    map.put(jRadioButtonMenuItem.getActionCommand(), jRadioButtonMenuItem);
                }
            } else {
                map = Collections.emptyMap();
            }
            this.serverMenuItems.clear();
            this.serverMenu.removeAll();
            List<Server> list = ServerManager.getDefault().getServers();
            int n = list.size();
            JMenu jMenu = this.serverMenu;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string;
                JRadioButtonMenuItem jRadioButtonMenuItem;
                Object object = (Server)list.get(i);
                if (n - n2 > 12 && i % 10 == 0) {
                    n2 = i;
                    int n3 = Math.min(i + 10, n) - 1;
                    jMenu = new JMenu(Utils.shortenStringForDisplay(((Server)object).toString(), 8) + " -> " + Utils.shortenStringForDisplay(((Server)list.get(n3)).toString(), 8));
                    this.serverMenu.add(jMenu);
                }
                if ((jRadioButtonMenuItem = (JRadioButtonMenuItem)map.get(string = String.valueOf(((Server)object).getID()))) == null) {
                    jRadioButtonMenuItem = new JRadioButtonMenuItem(((Server)object).toString());
                    jRadioButtonMenuItem.addActionListener(this);
                    jRadioButtonMenuItem.setActionCommand(string);
                    this.serverGroup.add(jRadioButtonMenuItem);
                } else {
                    jRadioButtonMenuItem.setText(((Server)object).toString());
                    map.remove(string);
                }
                this.serverMenuItems.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
                if (object != MainWin.this.currentServer) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
            for (Object object : map.values()) {
                this.serverGroup.remove((AbstractButton)object);
            }
        }

        public void setSelectionByIndex(int n) {
            this.serverMenuItems.get(n).setSelected(true);
        }

        public void setSelectionByID(int n) {
            String string = String.valueOf(n);
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.serverMenuItems) {
                if (!string.equals(jRadioButtonMenuItem.getActionCommand())) continue;
                jRadioButtonMenuItem.setSelected(true);
                break;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            if (n != MainWin.this.currentServer.getID()) {
                MainWin.this.switchServer(n);
            }
        }
    }

    class StatusBarResizeAction
    extends ExcDialogAbstractAction
    implements DocumentListener,
    PropertyChangeListener,
    WindowListener {
        private static final int RESET_THRESHOLD = 2;
        private boolean firstDisplay = true;
        private boolean programmaticAdjustment = true;

        StatusBarResizeAction() {
        }

        public void actualActionPerformed(ActionEvent actionEvent) {
            this.setSelected(!this.isSelected());
        }

        public boolean isSelected() {
            Boolean bl = (Boolean)this.getValue("selected");
            return bl != null ? bl : false;
        }

        public void setSelected(boolean bl) {
            this.putValue("selected", bl);
            if (bl) {
                this.makePreferredSize();
            }
        }

        private void makePreferredSize() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBarResizeAction.this.setDividerLocationNoEvent(StatusBarResizeAction.this.getAutoDividerLocation());
                }
            });
        }

        int getAutoDividerLocation() {
            return MainWin.this.statusSplitter.getHeight() - MainWin.this.statusSplitter.getBottomComponent().getPreferredSize().height - MainWin.this.statusSplitter.getDividerSize() - 1;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.isSelected()) {
                this.makePreferredSize();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.isSelected()) {
                this.makePreferredSize();
            }
        }

        public void setDividerLocationNoEvent(int n) {
            this.programmaticAdjustment = true;
            MainWin.this.statusSplitter.setDividerLocation(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.programmaticAdjustment) {
                this.programmaticAdjustment = false;
                return;
            }
            if (!MainWin.this.isVisible()) {
                return;
            }
            if (this.isSelected() && Math.abs((Integer)propertyChangeEvent.getNewValue() - this.getAutoDividerLocation()) > 2) {
                this.setSelected(false);
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (this.firstDisplay) {
                this.setSelected(MainWin.this.myopts.statusBarSize < 0);
                if (MainWin.this.myopts.statusBarSize >= 0) {
                    this.setDividerLocationNoEvent(MainWin.this.statusSplitter.getHeight() - MainWin.this.myopts.statusBarSize);
                }
                this.firstDisplay = false;
            } else if (this.isSelected()) {
                this.makePreferredSize();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuickSearchHelper
    extends AbstractQuickSearchHelper
    implements ChangeListener {
        QuickSearchHelper() {
        }

        public Filter getFilterFor(TableType tableType) {
            String string = this.textQuickSearch.getText();
            if (string == null || string.length() == 0) {
                return null;
            }
            FmtItemList<? extends FmtItem> fmtItemList = this.getColumnsFor(tableType);
            OrFilter orFilter = new OrFilter();
            for (FmtItem fmtItem : fmtItemList) {
                orFilter.addChild(new StringFilter(fmtItem, StringFilterOperator.CONTAINS, string, false));
            }
            return orFilter;
        }

        private FmtItemList<? extends FmtItem> getColumnsFor(TableType tableType) {
            switch (tableType) {
                case RECEIVED: {
                    return MainWin.this.recvTableModel.getColumns();
                }
                case SENT: {
                    return MainWin.this.sentTableModel.getColumns();
                }
                case SENDING: {
                    return MainWin.this.sendingTableModel.getColumns();
                }
                case ARCHIVE: {
                    return MainWin.this.archiveTableModel.getColumns();
                }
            }
            throw new IllegalArgumentException("Unknown table type");
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MainWin.this.refreshFilter();
        }

        @Override
        protected void performActualQuickSearch() {
            MainWin.this.refreshFilter();
        }

        @Override
        protected Component getFocusComponent() {
            return MainWin.this.getSelectedTable();
        }

        public JToolBar getQuickSearchBar(Action action) {
            return this.getQuickSearchBar(action, Utils._("Type here parts of the sender, recipient or file name in order to search for a fax."), Utils._("Reset quick search and show all faxes."));
        }
    }

    class LoginThread
    implements Runnable {
        protected boolean wantAdmin;
        protected Runnable loginAction;
        protected boolean refreshComplete = false;
        protected boolean showErrorDialogs = true;

        public void run() {
            try {
                VirtColPersister virtColPersister = MainWin.this.currentServer.getPersistence();
                MainWin.this.recvTableModel.setPersistence(virtColPersister);
                MainWin.this.sentTableModel.setPersistence(virtColPersister);
                MainWin.this.sendingTableModel.setPersistence(virtColPersister);
                if (MainWin.this.archiveTableModel != null) {
                    MainWin.this.archiveTableModel.setPersistence(virtColPersister);
                }
                virtColPersister.prepareValues();
                if (Utils.debugMode) {
                    log.info("Begin login (wantAdmin=" + this.wantAdmin + ")");
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        MainWin.this.reloadTableColumnSettings();
                        MainWin.this.menuView.setEnabled(true);
                        MainWin.this.menuViewListener.reConnected();
                        MainWin.this.actSend.setEnabled(true);
                        MainWin.this.actPoll.setEnabled(true);
                        MainWin.this.actAnswerCall.setEnabled(true);
                        MainWin.this.setActReconnectState(false);
                        MainWin.this.sendReady = SendReadyState.Ready;
                        MainWin.this.setEnabled(true);
                        if (Utils.debugMode) {
                            log.info("Finished init work after refresh complete!");
                        }
                        if (LoginThread.this.loginAction != null) {
                            if (Utils.debugMode) {
                                log.info("Doing login action: " + LoginThread.this.loginAction.getClass().getName());
                            }
                            LoginThread.this.loginAction.run();
                            if (Utils.debugMode) {
                                log.info("Finished login action.");
                            }
                        }
                    }
                };
                MainWin.this.connection.addFaxListConnectionListener(new RefreshCompleteHider(MainWin.this.tablePanel, MainWin.this.connection, runnable));
                if (MainWin.this.connection.getClientManager() != null) {
                    MainWin.this.connection.getClientManager().setShowErrorsUsingGUI(this.showErrorDialogs);
                }
                if (!MainWin.this.connection.connect(this.wantAdmin)) {
                    log.info("Login failed, bailing out");
                    this.doErrorCleanup();
                    return;
                }
                if (Utils.debugMode) {
                    log.info("Login succeeded. -- begin init work.");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HylaClientManager hylaClientManager;
                        if (MainWin.this.tablePanel.isShowingProgress()) {
                            MainWin.this.tablePanel.showIndeterminateProgress(Utils._("Fetching fax list..."));
                        }
                        if ((hylaClientManager = MainWin.this.connection.getClientManager()) != null) {
                            MainWin.this.setTitle(hylaClientManager.getUser() + "@" + MainWin.this.currentServer.getOptions().host + (hylaClientManager.isAdminMode() ? " (admin)" : "") + " - " + "Yet Another Java HylaFAX Client (YajHFC)");
                            MainWin.this.actAdminMode.putValue("selected", hylaClientManager.isAdminMode());
                            if (hylaClientManager.isAdminMode()) {
                                Color color = MainWin.this.getDefStatusBackground();
                                MainWin.this.textStatus.setBackground(new Color(Math.min(color.getRed() + 40, 255), color.getGreen(), color.getBlue()));
                            }
                        } else {
                            MainWin.this.setTitle(MainWin.this.currentServer.getOptions().user + "@" + MainWin.this.currentServer.getOptions().host + " - " + "Yet Another Java HylaFAX Client (YajHFC)");
                        }
                        if (MainWin.this.trayIcon != null) {
                            MainWin.this.trayIcon.setConnectedState(true);
                        }
                        log.fine("Finished init work after connect!");
                    }
                });
                if (MainWin.this.connection.getClientManager() != null) {
                    MainWin.this.connection.getClientManager().setShowErrorsUsingGUI(true);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog(MainWin.this, Utils._("An error occured connecting to the server:"), exception);
                this.doErrorCleanup();
            }
        }

        private void doErrorCleanup() {
            if (Utils.debugMode) {
                log.info("Login failed! -- doing cleanup.");
            }
            MainWin.this.connection.disconnect();
            MainWin.this.sendReady = SendReadyState.NotReady;
            if (MainWin.this.connection.getClientManager() != null) {
                MainWin.this.connection.getClientManager().setShowErrorsUsingGUI(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWin.this.tablePanel.hideProgress();
                    MainWin.this.setEnabled(true);
                }
            });
        }

        public LoginThread(boolean bl, Runnable runnable, boolean bl2) {
            this.wantAdmin = bl;
            this.loginAction = runnable;
            this.showErrorDialogs = bl2;
        }
    }

    static class RefreshCompleteHider
    extends SwingFaxListConnectionListener {
        final ProgressWorker.ProgressUI progressUI;
        final FaxListConnection parent;
        final Runnable refreshCompleteAction;

        protected void refreshCompleteSwing(FaxListConnectionListener.RefreshKind refreshKind, boolean bl) {
            if (refreshKind != FaxListConnectionListener.RefreshKind.STATUS) {
                this.progressUI.close();
                this.parent.removeFaxListConnectionListener(this);
                if (this.refreshCompleteAction != null) {
                    this.refreshCompleteAction.run();
                }
            }
        }

        public RefreshCompleteHider(ProgressWorker.ProgressUI progressUI, FaxListConnection faxListConnection) {
            this(progressUI, faxListConnection, null);
        }

        public RefreshCompleteHider(ProgressWorker.ProgressUI progressUI, FaxListConnection faxListConnection, Runnable runnable) {
            super(false, false, true);
            this.progressUI = progressUI;
            this.parent = faxListConnection;
            this.refreshCompleteAction = runnable;
        }
    }

    class ActionEnabler
    implements ListSelectionListener,
    ChangeListener {
        ActionEnabler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.doEnableCheck();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.doEnableCheck();
        }

        public void doEnableCheck() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            Component component = MainWin.this.tabMain.getSelectedComponent();
            TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
            if (component == MainWin.this.scrollRecv) {
                if (MainWin.this.tableRecv.getSelectedRow() >= 0) {
                    bl = true;
                    bl2 = true;
                    bl3 = true;
                    bl4 = MainWin.this.tableRecv.getJobForRow(MainWin.this.tableRecv.getSelectedRow()).isRead();
                }
            } else if (component == MainWin.this.scrollSent) {
                if (MainWin.this.tableSent.getSelectedRow() >= 0) {
                    bl2 = true;
                    bl = true;
                    bl5 = true;
                    bl7 = true;
                }
            } else if (component == MainWin.this.scrollSending && MainWin.this.tableSending.getSelectedRow() >= 0) {
                bl2 = true;
                bl = true;
                bl5 = true;
                bl6 = true;
                bl7 = true;
            }
            if (component == MainWin.this.scrollArchive && MainWin.this.tableArchive.getSelectedRow() >= 0) {
                bl2 = true;
                bl = true;
                bl5 = true;
                bl7 = true;
            }
            MainWin.this.actShow.setEnabled(bl);
            MainWin.this.actFaxSave.setEnabled(bl);
            MainWin.this.actSaveAsPDF.setEnabled(bl);
            MainWin.this.actSaveAsTIFF.setEnabled(bl);
            MainWin.this.actDelete.setEnabled(bl2);
            MainWin.this.actFaxRead.setEnabled(bl3);
            MainWin.this.actForward.setEnabled(bl3);
            MainWin.this.actResend.setEnabled(bl5);
            MainWin.this.actSuspend.setEnabled(bl6);
            MainWin.this.actResume.setEnabled(bl6);
            MainWin.this.actEditJob.setEnabled(bl6);
            MainWin.this.actClipCopy.setEnabled(bl);
            MainWin.this.actViewLog.setEnabled(bl7);
            MainWin.this.actEditComment.setEnabled(bl && tooltipJTable.getRealModel().getColumns().getVirtualColumnIndex(VirtualColumnType.USER_COMMENT) >= 0);
            MainWin.this.actFaxRead.putValue("selected", bl4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MenuViewListener
    extends MultiButtonGroup
    implements ChangeListener {
        private static final String VIEW_CUSTOM = "view_custom";
        private static final String VIEW_OWN = "view_own";
        private static final String VIEW_ALL = "view_all";
        private String[] lastSel = new String[TableType.TABLE_COUNT];
        private Filter[] currentFilters = new Filter[TableType.TABLE_COUNT];
        private MultiButtonGroup.Item itemViewAll = this.addItem(Utils._("All faxes"), "view_all");
        private MultiButtonGroup.Item itemViewOwn;
        private MultiButtonGroup.Item itemViewCustom;

        public MenuViewListener() {
            this.itemViewAll.setSelected(true);
            this.itemViewAll.setEnabled(MainWin.this.myopts.allowChangeFilter);
            MainWin.this.putAvailableAction(this.itemViewAll);
            this.itemViewOwn = this.addItem(Utils._("Only own faxes"), VIEW_OWN);
            this.itemViewOwn.setEnabled(MainWin.this.myopts.allowChangeFilter);
            MainWin.this.putAvailableAction(this.itemViewOwn);
            this.itemViewCustom = this.addItem(Utils._("Custom filter..."), VIEW_CUSTOM);
            this.itemViewCustom.setEnabled(MainWin.this.myopts.allowChangeFilter);
            MainWin.this.putAvailableAction(this.itemViewCustom);
        }

        private void setJobFilter(FaxListTableModel faxListTableModel, Filter filter) {
            this.currentFilters[faxListTableModel.getTableType().ordinal()] = filter;
            MainWin.this.refreshFilter(faxListTableModel);
        }

        public Filter<FaxJob<? extends FmtItem>, ? extends FmtItem> getFilterFor(TableType tableType) {
            return this.currentFilters[tableType.ordinal()];
        }

        @Override
        protected void actualActionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            FaxListTableModel<? extends FmtItem> faxListTableModel = MainWin.this.getSelectedTable().getRealModel();
            int n = MainWin.this.tabMain.getSelectedIndex();
            if (string.equals(VIEW_ALL)) {
                this.setJobFilter(faxListTableModel, null);
                this.lastSel[n] = VIEW_ALL;
            } else if (string.equals(VIEW_OWN)) {
                this.setJobFilter(faxListTableModel, this.getOwnFilterFor(faxListTableModel));
                this.lastSel[n] = VIEW_OWN;
            } else if (string.equals(VIEW_CUSTOM)) {
                CustomFilterDialog customFilterDialog = new CustomFilterDialog(MainWin.this, MessageFormat.format(Utils._("Custom filter for table {0}"), MainWin.this.tabMain.getTitleAt(n)), Utils._("Only display fax jobs fulfilling:"), Utils._("You have entered no filtering conditions. Do you want to show all faxes instead?"), Utils._("Please enter a valid date/time!\n(Hint: Exactly the same format as in the fax job table is expected)"), faxListTableModel.getColumns(), this.lastSel[n] == VIEW_CUSTOM ? this.getFilterFor(faxListTableModel.getTableType()) : null);
                customFilterDialog.setVisible(true);
                if (customFilterDialog.okClicked) {
                    if (customFilterDialog.returnValue == null) {
                        this.itemViewAll.actionPerformed(new ActionEvent(this, 0, VIEW_ALL));
                        return;
                    }
                    this.setJobFilter(faxListTableModel, customFilterDialog.returnValue);
                    this.lastSel[n] = VIEW_CUSTOM;
                } else if (this.lastSel[n] != VIEW_CUSTOM) {
                    this.resetLastSel(n);
                }
            }
        }

        private void resetLastSel(int n) {
            if (this.lastSel[n] != null) {
                this.setSelectedActionCommand(this.lastSel[n]);
            } else {
                this.setSelectedActionCommand(VIEW_ALL);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FaxListTableModel<? extends FmtItem> faxListTableModel = MainWin.this.getSelectedTable().getRealModel();
            boolean bl = this.ownFilterOK(faxListTableModel);
            boolean bl2 = this.canMarkError(faxListTableModel);
            this.resetLastSel(MainWin.this.tabMain.getSelectedIndex());
            this.itemViewOwn.setEnabled(MainWin.this.myopts.allowChangeFilter && bl);
            MainWin.this.actMarkFailedJobs.setEnabled(bl2);
            if (!bl && this.itemViewOwn.isSelected()) {
                this.setSelectedActionCommand(VIEW_ALL);
                this.setJobFilter(faxListTableModel, null);
            }
        }

        private Filter<FaxJob<? extends FmtItem>, ? extends FmtItem> getOwnFilterFor(FaxListTableModel<? extends FmtItem> faxListTableModel) {
            String string = MainWin.this.currentServer.isConnected() ? MainWin.this.connection.getClientManager().getUser() : MainWin.this.currentServer.getOptions().user;
            return new StringFilter<FaxJob<? extends FmtItem>, FmtItem>(this.getOwnerColumn(faxListTableModel), StringFilterOperator.EQUAL, string, true);
        }

        private boolean canMarkError(FaxListTableModel<? extends FmtItem> faxListTableModel) {
            return faxListTableModel.getJobs().isShowingErrorsSupported();
        }

        private FmtItem getOwnerColumn(FaxListTableModel<? extends FmtItem> faxListTableModel) {
            switch (faxListTableModel.getTableType()) {
                case RECEIVED: {
                    return RecvFormat.o;
                }
                case SENT: 
                case SENDING: {
                    return JobFormat.o;
                }
                case ARCHIVE: {
                    return QueueFileFormat.owner;
                }
            }
            return null;
        }

        private boolean ownFilterOK(FaxListTableModel<? extends FmtItem> faxListTableModel) {
            FmtItem fmtItem = this.getOwnerColumn(faxListTableModel);
            return fmtItem != null && faxListTableModel.getColumns().getCompleteView().contains(fmtItem);
        }

        public void reConnected() {
            for (int i = 0; i < MainWin.this.tabMain.getTabCount(); ++i) {
                FaxListTableModel<? extends FmtItem> faxListTableModel = MainWin.this.getTableByIndex(i).getRealModel();
                if (this.lastSel[i] == VIEW_OWN) {
                    if (this.ownFilterOK(faxListTableModel)) {
                        this.setJobFilter(faxListTableModel, this.getOwnFilterFor(faxListTableModel));
                        continue;
                    }
                    this.lastSel[i] = VIEW_ALL;
                    this.setJobFilter(faxListTableModel, null);
                    continue;
                }
                if (this.lastSel[i] == VIEW_CUSTOM) {
                    if (this.getFilterFor(faxListTableModel.getTableType()) != null && this.getFilterFor(faxListTableModel.getTableType()).validate(faxListTableModel.getColumns())) continue;
                    this.lastSel[i] = VIEW_ALL;
                    this.setJobFilter(faxListTableModel, null);
                    continue;
                }
                if (this.lastSel[i] != VIEW_ALL) continue;
                this.setJobFilter(faxListTableModel, null);
            }
            this.stateChanged(null);
        }

        private void loadSaveString(int n, String string) {
            if (string == null || string.equals("A")) {
                this.lastSel[n] = VIEW_ALL;
            } else if (string.equals("O")) {
                this.lastSel[n] = VIEW_OWN;
            } else if (string.startsWith("C")) {
                FaxListTableModel<? extends FmtItem> faxListTableModel = MainWin.this.getTableByIndex(n).getRealModel();
                Filter filter = FilterCreator.stringToFilter(string.substring(1), faxListTableModel.getColumns());
                if (filter == null) {
                    this.lastSel[n] = VIEW_ALL;
                } else {
                    this.lastSel[n] = VIEW_CUSTOM;
                    this.setJobFilter(faxListTableModel, filter);
                }
            } else {
                log.warning("Unknown filter for index " + n + ":" + string);
                this.lastSel[n] = VIEW_ALL;
            }
        }

        public void loadFromOptions(FaxOptions faxOptions) {
            this.loadSaveString(0, faxOptions.recvFilter);
            this.loadSaveString(1, faxOptions.sentFilter);
            this.loadSaveString(2, faxOptions.sendingFilter);
            this.loadSaveString(3, faxOptions.archiveFilter);
            this.reConnected();
        }

        private String getSaveString(int n) {
            if (this.lastSel[n] == null || this.lastSel[n] == VIEW_ALL) {
                return "A";
            }
            if (this.lastSel[n] == VIEW_OWN) {
                return "O";
            }
            if (this.lastSel[n] == VIEW_CUSTOM) {
                FaxListTableModel<? extends FmtItem> faxListTableModel = MainWin.this.getTableByIndex(n).getRealModel();
                return "C" + FilterCreator.filterToString(this.getFilterFor(faxListTableModel.getTableType()));
            }
            return null;
        }

        public void saveToOptions(FaxOptions faxOptions) {
            faxOptions.recvFilter = this.getSaveString(0);
            faxOptions.sentFilter = this.getSaveString(1);
            faxOptions.sendingFilter = this.getSaveString(2);
            faxOptions.archiveFilter = this.getSaveString(3);
        }
    }

    private class SaveToFormatAction
    extends ExcDialogAbstractAction {
        private final MultiFileConvFormat desiredFormat;

        public void actualActionPerformed(ActionEvent actionEvent) {
            TooltipJTable<? extends FmtItem> tooltipJTable = MainWin.this.getSelectedTable();
            if (tooltipJTable.getSelectedRowCount() == 0) {
                return;
            }
            if (Utils.searchExecutableInPath(MainWin.this.myopts.ghostScriptLocation) == null || Utils.searchExecutableInPath(MainWin.this.myopts.tiff2PDFLocation) == null) {
                JOptionPane.showMessageDialog(MainWin.this, MessageFormat.format(Utils._("Save to {0} needs GhostScript and tiff2pdf.\nPlease specify the location of these tools in the options dialog (see the FAQ for download locations)."), this.desiredFormat.name()), Utils._("Error"), 1);
                return;
            }
            if (tooltipJTable.getSelectedRowCount() > 1) {
                SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
                safeJFileChooser.setDialogTitle(Utils._("Select a directory to save the faxes in"));
                safeJFileChooser.setApproveButtonText(Utils._("Select"));
                safeJFileChooser.setFileSelectionMode(1);
                if (Utils.getFaxOptions().lastSavePath.length() > 0) {
                    safeJFileChooser.setSelectedFile(new File(Utils.getFaxOptions().lastSavePath));
                }
                if (safeJFileChooser.showOpenDialog(MainWin.this) == 0) {
                    SaveToFormatWorker saveToFormatWorker = new SaveToFormatWorker(tooltipJTable, safeJFileChooser.getSelectedFile(), false, this.desiredFormat);
                    saveToFormatWorker.startWork(MainWin.this, Utils._("Saving faxes"));
                    Utils.getFaxOptions().lastSavePath = safeJFileChooser.getSelectedFile().getPath();
                }
            } else {
                SaveToFormatWorker saveToFormatWorker = new SaveToFormatWorker(tooltipJTable, null, true, this.desiredFormat);
                saveToFormatWorker.startWork(MainWin.this, Utils._("Saving faxes"));
            }
        }

        public SaveToFormatAction(MultiFileConvFormat multiFileConvFormat) {
            this.desiredFormat = multiFileConvFormat;
            this.putValue("Name", MessageFormat.format(Utils._("Save fax as {0}..."), new Object[]{multiFileConvFormat}));
            this.putValue("ShortDescription", MessageFormat.format(Utils._("Saves the selected fax(es) as single {0} file"), new Object[]{multiFileConvFormat}));
            this.putValue("SmallIcon", Utils.loadCustomIcon("saveAs" + multiFileConvFormat.name() + ".png"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveToFormatWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;
        private File targetDir;
        private int fileCounter;
        private JFileChooser fileChooser;
        private boolean askForEveryFile;
        private final MultiFileConvFormat desiredFormat;

        @Override
        protected int calculateMaxProgress() {
            return 1000 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doWork() {
            try {
                this.fileCounter = 0;
                MainWin.this.connection.beginMultiOperation();
                try {
                    ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>();
                    MessageFormat messageFormat = new MessageFormat(Utils._("Saving fax {0}"));
                    for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                        try {
                            this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                            arrayList.clear();
                            for (FaxDocument faxDocument : faxJob.getDocuments()) {
                                try {
                                    arrayList.add(faxDocument.getDocument());
                                }
                                catch (ServerResponseException serverResponseException) {
                                    this.showExceptionDialog(MessageFormat.format(Utils._("While downloading the file {0} (job {1}), the server gave back an error code:"), faxDocument.getPath(), faxJob.getIDValue()), serverResponseException);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    this.showExceptionDialog(MessageFormat.format(Utils._("The file {0} (job {1}) could not be opened for reading (probably you lack the necessary access permissions):"), faxDocument.getPath(), faxJob.getIDValue()), fileNotFoundException);
                                }
                                catch (Exception exception) {
                                    this.showExceptionDialog(MessageFormat.format(Utils._("An error occured saving the file {0} (job {1}):"), faxDocument.getPath(), faxJob.getIDValue()), exception);
                                }
                            }
                            if (arrayList.size() > 0) {
                                void var8_15;
                                Object object = faxJob.getIDValue();
                                if (object instanceof Integer) {
                                    String string = "fax" + (Integer)object;
                                } else {
                                    String string = object.toString();
                                    int n = string.lastIndexOf(46);
                                    if (n >= 0) {
                                        String string2 = string.substring(0, n);
                                    }
                                }
                                File file = new File(this.targetDir, (String)var8_15 + '.' + this.desiredFormat.getFileFormat().getDefaultExtension());
                                if (this.askForEveryFile) {
                                    FileChooserRunnable fileChooserRunnable = new FileChooserRunnable(MainWin.this, this.fileChooser, MessageFormat.format(Utils._("File name to save fax {0}"), faxJob.getIDValue()), null, file, false);
                                    SwingUtilities.invokeAndWait(fileChooserRunnable);
                                    if (fileChooserRunnable.getSelection() == null) {
                                        return;
                                    }
                                    file = fileChooserRunnable.getSelection();
                                    this.targetDir = file.getParentFile();
                                }
                                MultiFileConverter.convertMultipleFilesToSingleFile(arrayList, file, this.desiredFormat, MainWin.this.currentServer.getOptions().paperSize);
                                ++this.fileCounter;
                            }
                        }
                        catch (Exception exception) {
                            this.showExceptionDialog(Utils._("An error occured saving the fax:"), exception);
                        }
                        this.stepProgressBar(1000);
                    }
                    if (this.targetDir == null) return;
                    Utils.getFaxOptions().lastSavePath = this.targetDir.getAbsolutePath();
                    return;
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error saving faxes:"), exception);
            }
        }

        @Override
        protected void initialize() {
            if (this.askForEveryFile) {
                if (this.targetDir == null && Utils.getFaxOptions().lastSavePath.length() > 0) {
                    this.targetDir = new File(Utils.getFaxOptions().lastSavePath);
                }
                this.fileChooser = new SafeJFileChooser();
                this.fileChooser.resetChoosableFileFilters();
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter(this.desiredFormat.getFileFormat().getPossibleExtensions(), this.desiredFormat.getFileFormat().getDescription());
                this.fileChooser.addChoosableFileFilter(exampleFileFilter);
                this.fileChooser.setFileFilter(exampleFileFilter);
            }
        }

        @Override
        protected void pMonClosed() {
            if (!this.askForEveryFile) {
                JOptionPane.showMessageDialog(MainWin.this, MessageFormat.format(Utils._("{0} files saved to directory {1}."), this.fileCounter, this.targetDir.getPath()), Utils._("Faxes saved"), 1);
            }
        }

        public SaveToFormatWorker(TooltipJTable<? extends FmtItem> tooltipJTable, File file, boolean bl, MultiFileConvFormat multiFileConvFormat) {
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.targetDir = file;
            this.progressMonitor = MainWin.this.tablePanel;
            this.askForEveryFile = bl;
            this.desiredFormat = multiFileConvFormat;
            this.setCloseOnExit(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResumeWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;

        @Override
        protected int calculateMaxProgress() {
            return 20 + 10 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWork() {
            try {
                MainWin.this.connection.beginMultiOperation();
                try {
                    MessageFormat messageFormat = new MessageFormat(Utils._("Resuming job {0}"));
                    for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                        try {
                            this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                            JobState jobState = faxJob.getCurrentJobState();
                            if (jobState != JobState.SUSPENDED) {
                                if (this.showConfirmDialog(MessageFormat.format(Utils._("Job {0} is not in state \"Suspended\" so resuming it probably will not work. Try to resume it anyway?"), faxJob.getIDValue()), Utils._("Resume fax job"), 0, 3) == 0) {
                                    faxJob.resume();
                                }
                            } else {
                                faxJob.resume();
                            }
                            this.stepProgressBar(10);
                        }
                        catch (Exception exception) {
                            String string = faxJob == null ? Utils._("Error resuming a fax job:\n") : MessageFormat.format(Utils._("Error resuming the fax job \"{0}\":\n"), faxJob.getIDValue());
                            this.showExceptionDialog(string, exception);
                        }
                    }
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error resuming faxes:"), exception);
            }
        }

        @Override
        protected void done() {
            MainWin.this.refreshTables();
        }

        public ResumeWorker(TooltipJTable<? extends FmtItem> tooltipJTable) {
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.progressMonitor = MainWin.this.tablePanel;
            this.setCloseOnExit(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuspendWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;

        @Override
        protected int calculateMaxProgress() {
            return 20 + 10 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWork() {
            try {
                MainWin.this.connection.beginMultiOperation();
                try {
                    MessageFormat messageFormat = new MessageFormat(Utils._("Suspending job {0}"));
                    for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                        try {
                            this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                            JobState jobState = faxJob.getCurrentJobState();
                            if (jobState == JobState.RUNNING) {
                                if (this.showConfirmDialog(MessageFormat.format(Utils._("Suspending the currently running job {0} may block until it is done (or switch to another \"non running state\"). Try to suspend it anyway?"), faxJob.getIDValue()), Utils._("Suspend fax job"), 0, 3) == 0) {
                                    faxJob.suspend();
                                }
                            } else {
                                faxJob.suspend();
                            }
                            this.stepProgressBar(10);
                        }
                        catch (Exception exception) {
                            String string = faxJob == null ? Utils._("Error suspending a fax job:\n") : MessageFormat.format(Utils._("Error suspending the fax job \"{0}\":\n"), faxJob.getIDValue());
                            this.showExceptionDialog(string, exception);
                        }
                    }
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error suspending faxes:"), exception);
            }
        }

        @Override
        protected void done() {
            MainWin.this.refreshTables();
        }

        public SuspendWorker(TooltipJTable<? extends FmtItem> tooltipJTable) {
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.progressMonitor = MainWin.this.tablePanel;
            this.setCloseOnExit(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShowWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;
        private boolean updateReadState;
        private int sMin;
        private int sMax;

        @Override
        protected int calculateMaxProgress() {
            return 100 + 1200 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWork() {
            try {
                MainWin.this.connection.beginMultiOperation();
                try {
                    ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    MessageFormat messageFormat = new MessageFormat(Utils._("Displaying fax {0}"));
                    MessageFormat messageFormat2 = new MessageFormat(Utils._("Downloading {0}"));
                    for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                        try {
                            this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                            arrayList.clear();
                            arrayList2.clear();
                            Collection<FaxDocument> collection = faxJob.getDocuments(arrayList2);
                            this.stepProgressBar(100);
                            if (collection.size() == 0) {
                                StringBuffer stringBuffer = new StringBuffer();
                                new MessageFormat(Utils._("No accessible document files are available for the fax \"{0}\".")).format(new Object[]{faxJob.getIDValue()}, stringBuffer, (FieldPosition)null);
                                if (arrayList2.size() > 0) {
                                    stringBuffer.append("\n\n");
                                    stringBuffer.append(Utils._("The following files were inaccessible:"));
                                    stringBuffer.append('\n');
                                    for (String string : arrayList2) {
                                        stringBuffer.append(string).append('\n');
                                    }
                                }
                                this.showMessageDialog(stringBuffer.toString(), Utils._("Display fax"), 1);
                                this.stepProgressBar(1000);
                            } else {
                                int n = 1000 / collection.size();
                                arrayList.clear();
                                for (FaxDocument faxDocument : collection) {
                                    this.updateNote(messageFormat2.format(new Object[]{faxDocument.getPath()}));
                                    try {
                                        arrayList.add(faxDocument.getDocument());
                                    }
                                    catch (ServerResponseException exception) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("While downloading the file {0} (job {1}), the server gave back an error code:"), faxDocument.getPath(), faxJob.getIDValue()), exception);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("The file {0} (job {1}) could not be opened for reading (probably you lack the necessary access permissions):"), faxDocument.getPath(), faxJob.getIDValue()), fileNotFoundException);
                                    }
                                    catch (Exception exception) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("An error occured displaying the file {0} (job {1}):\n"), faxDocument.getPath(), faxJob.getIDValue()), exception);
                                    }
                                    this.stepProgressBar(n);
                                }
                                this.updateNote(Utils._("Launching viewer"));
                                if (arrayList.size() > 0) {
                                    MultiFileConverter.viewMultipleFiles(arrayList, MainWin.this.currentServer.getOptions().paperSize, false);
                                }
                                this.stepProgressBar(100);
                            }
                            faxJob.setRead(true);
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().contains("All fill bits preceding EOL code must be 0.")) {
                                Iterator iterator = Utils._("It seems the TIFF files of your HylaFAX installation are incompatible with iText (often the case with capi4hylafax).") + "\n\n" + Utils._("Please see the following page for more details and how to work around this problem:") + "\n" + "http://www.yajhfc.de/documentation/knowledge-base/134-error-qall-fill-bits-preceding-eol-code-must-be-0q" + "\n\nTechnical info: The following exception was thrown:\n" + exception.toString();
                                SwingUtilities.invokeLater(new Runnable((String)((Object)iterator)){
                                    final /* synthetic */ String val$text;
                                    {
                                        this.val$text = string;
                                    }

                                    public void run() {
                                        JButton jButton = new JButton(Utils._("Go to website"));
                                        jButton.addActionListener(new ActionListener(){

                                            public void actionPerformed(ActionEvent actionEvent) {
                                                try {
                                                    DesktopManager.getDefault().safeBrowse(new URI("http://www.yajhfc.de/documentation/knowledge-base/134-error-qall-fill-bits-preceding-eol-code-must-be-0q"), MainWin.this);
                                                }
                                                catch (URISyntaxException uRISyntaxException) {
                                                    log.log(Level.SEVERE, "Error on constant URL", uRISyntaxException);
                                                }
                                            }
                                        });
                                        Object[] objectArray = new Object[]{jButton, Utils._("Close")};
                                        JOptionPane.showOptionDialog(MainWin.this, this.val$text, Utils._("Display fax"), -1, 2, null, objectArray, objectArray[0]);
                                    }
                                });
                                break;
                            }
                            this.showExceptionDialog(MessageFormat.format(Utils._("An error occured displaying the fax \"{0}\":"), faxJob.getIDValue()), exception);
                        }
                    }
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error displaying faxes:"), exception);
            }
        }

        @Override
        protected void done() {
            if (this.sMax >= 0 && this.updateReadState) {
                MainWin.this.tableRecv.getSorter().fireTableRowsUpdated(this.sMin, this.sMax);
                MainWin.this.actFaxRead.putValue("selected", true);
            }
        }

        public ShowWorker(TooltipJTable<? extends FmtItem> tooltipJTable) {
            this.updateReadState = tooltipJTable == MainWin.this.tableRecv;
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.progressMonitor = MainWin.this.tablePanel;
            this.setCloseOnExit(true);
            if (this.updateReadState) {
                this.sMin = Integer.MAX_VALUE;
                this.sMax = Integer.MIN_VALUE;
                for (int n : tooltipJTable.getSelectedRows()) {
                    if (n < this.sMin) {
                        this.sMin = n;
                    }
                    if (n <= this.sMax) continue;
                    this.sMax = n;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiSaveWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;
        private File targetDir;
        private int fileCounter;
        private final boolean askForEveryFile;
        private JFileChooser fileChooser;

        @Override
        protected int calculateMaxProgress() {
            return 1000 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doWork() {
            this.fileCounter = 0;
            try {
                MainWin.this.connection.beginMultiOperation();
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    MessageFormat messageFormat = new MessageFormat(Utils._("Saving fax {0}"));
                    FaxJob<? extends FmtItem>[] faxJobArray = this.selJobs;
                    int n = faxJobArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FaxJob<? extends FmtItem> faxJob = faxJobArray[n2];
                        try {
                            arrayList.clear();
                            Collection<FaxDocument> collection = faxJob.getDocuments(arrayList);
                            if (collection.size() == 0) {
                                if (this.askForEveryFile) {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    new MessageFormat(Utils._("No accessible document files are available for the fax \"{0}\".")).format(new Object[]{faxJob.getIDValue()}, stringBuffer, (FieldPosition)null);
                                    if (arrayList.size() > 0) {
                                        stringBuffer.append("\n\n");
                                        stringBuffer.append(Utils._("The following files were inaccessible:"));
                                        stringBuffer.append('\n');
                                        for (String string : arrayList) {
                                            stringBuffer.append(string).append('\n');
                                        }
                                    }
                                    this.showMessageDialog(stringBuffer.toString(), Utils._("Save fax"), 1);
                                }
                            } else {
                                this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                                for (FaxDocument faxDocument : collection) {
                                    try {
                                        FileFilter[] fileFilterArray;
                                        String string;
                                        string = faxDocument.getPath();
                                        int n3 = string.lastIndexOf(47);
                                        if (n3 < 0) {
                                            n3 = string.lastIndexOf(File.separatorChar);
                                        }
                                        if (n3 >= 0) {
                                            string = string.substring(n3 + 1);
                                        }
                                        File file = new File(this.targetDir, string);
                                        if (this.askForEveryFile) {
                                            fileFilterArray = new FileFilter[]{new ExampleFileFilter(faxDocument.getType().getDefaultExtension(), faxDocument.getType().getDescription())};
                                            FileChooserRunnable fileChooserRunnable = new FileChooserRunnable(MainWin.this, this.fileChooser, MessageFormat.format(Utils._("Save {0} to"), faxDocument.getPath()), fileFilterArray, file, false);
                                            SwingUtilities.invokeAndWait(fileChooserRunnable);
                                            if (fileChooserRunnable.getSelection() == null) {
                                                return;
                                            }
                                            file = fileChooserRunnable.getSelection();
                                            this.targetDir = file.getParentFile();
                                        }
                                        fileFilterArray = new FileOutputStream(file);
                                        faxDocument.downloadToStream((OutputStream)fileFilterArray);
                                        fileFilterArray.close();
                                        ++this.fileCounter;
                                    }
                                    catch (ServerResponseException serverResponseException) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("While downloading the file {0} (job {1}), the server gave back an error code:"), faxDocument.getPath(), faxJob.getIDValue()), serverResponseException);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("The file {0} (job {1}) could not be opened for reading (probably you lack the necessary access permissions):"), faxDocument.getPath(), faxJob.getIDValue()), fileNotFoundException);
                                    }
                                    catch (Exception exception) {
                                        this.showExceptionDialog(MessageFormat.format(Utils._("An error occured saving the file {0} (job {1}):"), faxDocument.getPath(), faxJob.getIDValue()), exception);
                                    }
                                }
                            }
                            if (this.targetDir != null) {
                                Utils.getFaxOptions().lastSavePath = this.targetDir.getAbsolutePath();
                            }
                        }
                        catch (Exception exception) {
                            this.showExceptionDialog(Utils._("An error occured saving the fax:"), exception);
                        }
                        this.stepProgressBar(1000);
                        ++n2;
                    }
                    return;
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error saving faxes:"), exception);
            }
        }

        @Override
        protected void initialize() {
            if (this.askForEveryFile) {
                if (this.targetDir == null && Utils.getFaxOptions().lastSavePath.length() > 0) {
                    this.targetDir = new File(Utils.getFaxOptions().lastSavePath);
                }
                this.fileChooser = new SafeJFileChooser();
            }
        }

        @Override
        protected void pMonClosed() {
            if (!this.askForEveryFile) {
                JOptionPane.showMessageDialog(MainWin.this, MessageFormat.format(Utils._("{0} files saved to directory {1}."), this.fileCounter, this.targetDir.getPath()), Utils._("Faxes saved"), 1);
            }
        }

        public MultiSaveWorker(TooltipJTable<? extends FmtItem> tooltipJTable, File file, boolean bl) {
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.targetDir = file;
            this.progressMonitor = MainWin.this.tablePanel;
            this.askForEveryFile = bl;
            this.setCloseOnExit(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteWorker
    extends ProgressWorker {
        private FaxJob<? extends FmtItem>[] selJobs;

        @Override
        protected int calculateMaxProgress() {
            return 20 + 10 * this.selJobs.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWork() {
            try {
                MainWin.this.connection.beginMultiOperation();
                try {
                    MessageFormat messageFormat = new MessageFormat(Utils._("Deleting fax {0}"));
                    for (FaxJob<? extends FmtItem> faxJob : this.selJobs) {
                        try {
                            this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                            faxJob.delete();
                            this.stepProgressBar(10);
                        }
                        catch (Exception exception) {
                            String string = faxJob == null ? Utils._("Error deleting a fax:\n") : MessageFormat.format(Utils._("Error deleting the fax \"{0}\":\n"), faxJob.getIDValue());
                            this.showExceptionDialog(string, exception);
                        }
                    }
                }
                finally {
                    MainWin.this.connection.endMultiOperation();
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error deleting faxes:"), exception);
            }
        }

        @Override
        protected void done() {
            MainWin.this.refreshTables();
        }

        public DeleteWorker(TooltipJTable<? extends FmtItem> tooltipJTable) {
            this.selJobs = tooltipJTable.getSelectedJobs();
            this.progressMonitor = MainWin.this.tablePanel;
            this.setCloseOnExit(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SendReadyState {
        Ready,
        NeedToWait,
        NotReady;

    }
}

