/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExDateFormat
extends DateFormat {
    private static final Logger log = Logger.getLogger(RegExDateFormat.class.getName());
    protected Pattern pattern;
    protected int[] calendarFields;
    protected Calendar calendar = Calendar.getInstance(Locale.US);

    public RegExDateFormat(String string, int ... nArray) {
        this.pattern = Pattern.compile(string);
        this.calendarFields = nArray;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        throw new UnsupportedOperationException("A RegExDateFormat cannot format.");
    }

    public Date parse(String string, ParsePosition parsePosition) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.find(parsePosition.getIndex())) {
            parsePosition.setIndex(matcher.end());
            try {
                this.calendar.clear();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    int n = this.calendarFields[i - 1];
                    String string2 = matcher.group(i);
                    if (string2 == null || string2.length() <= 0) continue;
                    int n2 = Integer.parseInt(string2);
                    if (n == 2) {
                        --n2;
                    }
                    if (n2 < 0) continue;
                    this.calendar.set(n, n2);
                }
                return this.calendar.getTime();
            }
            catch (Exception exception) {
                log.log(Level.INFO, "Error parsing the date \"" + string + "\"", exception);
                return null;
            }
        }
        return null;
    }
}

