/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YajHFCVersion
implements Comparable<YajHFCVersion> {
    private static final Logger log = Logger.getLogger(YajHFCVersion.class.getName());
    private int major = -1;
    private int minor = -1;
    private int revision = 0;
    private String additionString = "";
    private int additionInt = 0;
    private int additionNumber = 0;
    private String stringVersion;
    private static final Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?(\\D*)(\\d*)");

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getAdditionString() {
        return this.additionString;
    }

    public int getAdditionInt() {
        return this.additionInt;
    }

    public int getAdditionNumber() {
        return this.additionNumber;
    }

    @Override
    public int compareTo(YajHFCVersion yajHFCVersion) {
        int n = this.major - yajHFCVersion.major;
        if (n == 0 && (n = this.minor - yajHFCVersion.minor) == 0 && (n = this.revision - yajHFCVersion.revision) == 0 && (n = this.additionInt - yajHFCVersion.additionInt) == 0) {
            n = this.additionNumber - yajHFCVersion.additionNumber;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof YajHFCVersion) {
            return this.compareTo((YajHFCVersion)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (((this.major * 10 + this.minor) * 10 + this.revision) * 10 + this.additionInt) * 10 + this.additionNumber;
    }

    public String toString() {
        return this.stringVersion;
    }

    public YajHFCVersion() {
        this("0.6.1 (srfax v4)");
    }

    public YajHFCVersion(String string) {
        this.stringVersion = string;
        this.parseVersion(string);
    }

    private void parseVersion(String string) {
        Matcher matcher = versionPattern.matcher(string);
        if (matcher.matches()) {
            try {
                String string2;
                this.major = Integer.parseInt(matcher.group(1));
                this.minor = Integer.parseInt(matcher.group(2));
                String string3 = matcher.group(3);
                if (string3 != null && string3.length() > 0 && Character.isDigit(string3.charAt(0))) {
                    this.revision = Integer.parseInt(string3);
                }
                this.additionString = string2 = matcher.group(4);
                this.additionInt = string2 == null || string2.length() == 0 ? 10 : (string2.equalsIgnoreCase("alpha") ? -30 : (string2.equalsIgnoreCase("beta") ? -20 : (string2.equalsIgnoreCase("rc") ? -10 : (string2.length() == 1 ? (int)Character.toLowerCase(string2.charAt(0)) : -40))));
                String string4 = matcher.group(5);
                if (string4 != null && string4.length() > 0) {
                    this.additionNumber = Integer.parseInt(string4);
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error parsing the version " + string, exception);
            }
        }
    }
}

