/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.util.MsgBundle;

public class YajLanguage
extends MsgBundle {
    private static final Logger log = Logger.getLogger(YajLanguage.class.getName());
    public static final List<YajLanguage> supportedLanguages = new ArrayList<YajLanguage>();
    public static final YajLanguage SYSTEM_DEFAULT = new YajLanguage(null);
    protected final Locale locale;
    private String description = null;
    private final String langCode;

    public static YajLanguage languageFromLangCode(String string) {
        for (YajLanguage yajLanguage : supportedLanguages) {
            if (!yajLanguage.matchesLangCode(string)) continue;
            return yajLanguage;
        }
        return SYSTEM_DEFAULT;
    }

    public String toString() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    protected String createDescription() {
        if (this.locale == null) {
            return Utils._("(System default)");
        }
        if (Utils.getLocale().getLanguage().equals(this.locale.getLanguage())) {
            return this.locale.getDisplayName(Utils.getLocale());
        }
        return this.locale.getDisplayName(this.locale) + " (" + this.locale.getDisplayName(Utils.getLocale()) + ")";
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Utils.DEFAULT_LOCALE;
        }
        return this.locale;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public boolean matchesLangCode(String string) {
        if (this.langCode.length() >= string.length()) {
            return this.langCode.startsWith(string);
        }
        return string.startsWith(this.langCode);
    }

    protected URL getResource(String string) {
        return this.getClass().getResource(string);
    }

    public URL getLocalizedFile(String string, boolean bl) {
        String string2;
        String string3;
        Locale locale = this.getLocale();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        String[] stringArray = new String[]{string3 + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant() + string2, string3 + "_" + locale.getLanguage() + "_" + locale.getCountry() + string2, string3 + "_" + locale.getLanguage() + string2};
        URL uRL = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Utils.debugMode) {
                log.fine("Trying to find " + stringArray[i] + " for language " + locale);
            }
            if ((uRL = this.getResource(stringArray[i])) == null) continue;
            if (Utils.debugMode) {
                log.fine("Found " + uRL);
            }
            return uRL;
        }
        if (bl) {
            return this.getResource(string);
        }
        return null;
    }

    public YajLanguage(Locale locale) {
        super("yajhfc.i18n.Messages", YajLanguage.class.getClassLoader());
        this.locale = locale;
        this.langCode = locale == null ? "auto" : locale.toString();
    }

    static {
        supportedLanguages.add(SYSTEM_DEFAULT);
        supportedLanguages.add(new YajLanguage(Locale.TRADITIONAL_CHINESE));
        supportedLanguages.add(new YajLanguage(Locale.SIMPLIFIED_CHINESE));
        supportedLanguages.add(new YajLanguage(Locale.ENGLISH));
        supportedLanguages.add(new YajLanguage(Locale.FRENCH));
        supportedLanguages.add(new YajLanguage(Locale.GERMAN));
        supportedLanguages.add(new YajLanguage(new Locale("el")));
        supportedLanguages.add(new YajLanguage(Locale.ITALIAN));
        supportedLanguages.add(new YajLanguage(new Locale("pl")));
        supportedLanguages.add(new YajLanguage(new Locale("ru")));
        supportedLanguages.add(new YajLanguage(new Locale("es")));
        supportedLanguages.add(new YajLanguage(new Locale("tr")));
    }
}

