/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.faxcover;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import yajhfc.DateKind;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.faxcover.FaxcoverHyla;
import yajhfc.faxcover.HTMLFaxcover;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.phonebook.convrules.CompanyRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.convrules.ZIPCodeRule;

public abstract class Faxcover {
    private static final String DEFAULT_FAXCOVER_NAME = "/yajhfc/faxcover/coverpage.html";
    public DateFormat dateFmt;
    public Date coverDate = new Date();
    public PaperSize pageSize;
    public PBEntryFieldContainer fromData;
    public PBEntryFieldContainer toData;
    public PBEntryFieldContainer[] ccData;
    public EntryToStringRule nameRule = NameRule.TITLE_GIVENNAME_NAME_JOBTITLE;
    public EntryToStringRule locationRule = ZIPCodeRule.ZIPCODE_LOCATION;
    public EntryToStringRule companyRule = CompanyRule.DEPARTMENT_COMPANY;
    public String regarding;
    public String comments;
    public int pageCount;
    protected URL coverTemplate;
    public static final Map<FileFormat, Class<? extends Faxcover>> supportedCoverFormats = new EnumMap<FileFormat, Class<? extends Faxcover>>(FileFormat.class);
    protected static FileFilter[] acceptedFilters;

    public abstract void makeCoverSheet(OutputStream var1) throws IOException;

    public int estimatePostscriptPages(InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[4];
        if (inputStream.read(byArray) == byArray.length) {
            if (byArray[0] == 37 && byArray[1] == 33) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                int n2 = 0;
                int n3 = 0;
                Pattern pattern = Pattern.compile("%%Pages:\\s+(\\d+)");
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("%%Page:")) {
                        ++n3;
                        continue;
                    }
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    n2 = Integer.parseInt(matcher.group(1));
                }
                n = n2 > 0 ? n2 : n3;
                bufferedReader.close();
            } else if (byArray[0] == 37 && byArray[1] == 80 && byArray[2] == 68 && byArray[3] == 70) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray2 = new byte[4000];
                byte[] byArray3 = "/Type".getBytes();
                byte[] byArray4 = "/Page".getBytes();
                int n4 = byArray3.length + byArray4.length + 2;
                int n5 = 0;
                int n6 = 0;
                while ((n6 = bufferedInputStream.read(byArray2, n5, byArray2.length - n5)) > 0) {
                    int n7 = -1;
                    n6 += n5;
                    n5 = 0;
                    while ((n7 = this.arrIndexOf(byArray2, (byte)47, n7 + 1)) >= 0) {
                        if (n7 < n6 - n4) {
                            int n8;
                            boolean bl = true;
                            for (n8 = 0; n8 < byArray3.length; ++n8) {
                                if (byArray2[n7 + n8] == byArray3[n8]) continue;
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            n8 = n7 + byArray3.length;
                            while (Character.isWhitespace(byArray2[n8])) {
                                ++n8;
                            }
                            bl = true;
                            for (int i = 0; i < byArray4.length; ++i) {
                                if (byArray2[n8 + i] == byArray4[i]) continue;
                                bl = false;
                                break;
                            }
                            if (!bl || byArray2[n8 + byArray4.length] == 115) continue;
                            ++n;
                            continue;
                        }
                        n5 = n6 - n7;
                        if (n5 <= 0) break;
                        System.arraycopy(byArray2, n7, byArray2, 0, n5);
                        break;
                    }
                    if (n5 >= 0) continue;
                    break;
                }
                bufferedInputStream.close();
            } else if (byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42) {
                n = Faxcover.countTIFFPages(inputStream, false, byArray);
            } else if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
                n = Faxcover.countTIFFPages(inputStream, true, byArray);
            }
        }
        this.pageCount += n;
        return n;
    }

    private static int countTIFFPages(InputStream inputStream, boolean bl, byte[] byArray) throws IOException {
        long l;
        int n = 0;
        long l2 = 4L;
        while ((l = Faxcover.readDWord(inputStream, bl, byArray)) > 0L) {
            ++n;
            if (l - (l2 += 4L) > 0L) {
                l2 += inputStream.skip(l - l2);
            }
            int n2 = Faxcover.readWord(inputStream, bl, byArray);
            l2 += 2L;
            l2 += inputStream.skip(12 * n2);
        }
        return n;
    }

    private static int readWord(InputStream inputStream, boolean bl, byte[] byArray) throws IOException {
        return (int)Faxcover.readNByteInt(inputStream, bl, 2, byArray);
    }

    private static long readDWord(InputStream inputStream, boolean bl, byte[] byArray) throws IOException {
        return Faxcover.readNByteInt(inputStream, bl, 4, byArray);
    }

    private static long readNByteInt(InputStream inputStream, boolean bl, int n, byte[] byArray) throws IOException {
        int n2;
        int n3 = n;
        do {
            if ((n2 = inputStream.read(byArray, n - n3, n3)) >= 0) continue;
            throw new IOException("Premature EOF found.");
        } while ((n3 -= n2) > 0);
        long l = 0L;
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
        }
        return l;
    }

    private int arrIndexOf(byte[] byArray, byte by, int n) {
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    protected Faxcover(URL uRL) {
        this.dateFmt = DateKind.getInstanceFromKind(DateKind.DATE_AND_TIME);
        this.coverTemplate = uRL;
    }

    public static FileFilter[] getAcceptedFileFilters() {
        if (acceptedFilters == null) {
            acceptedFilters = FileFormat.createFileFiltersFromFormats(supportedCoverFormats.keySet());
        }
        return acceptedFilters;
    }

    public static Faxcover createInstanceForTemplate(File file) throws IOException, InvalidCoverFormatException {
        FileFormat fileFormat;
        Class<? extends Faxcover> clazz;
        URL uRL;
        if (file == null) {
            uRL = Utils.getYajHFCLanguage().getLocalizedFile(DEFAULT_FAXCOVER_NAME, true);
            if (uRL == null) {
                throw new IOException("Default cover page not found!");
            }
        } else {
            uRL = file.toURI().toURL();
        }
        if ((clazz = supportedCoverFormats.get((Object)(fileFormat = FormattedFile.detectFileFormat(uRL.openStream())))) == null) {
            throw new InvalidCoverFormatException("Unsupported cover page format!");
        }
        try {
            Constructor<? extends Faxcover> constructor = clazz.getConstructor(URL.class);
            return constructor.newInstance(uRL);
        }
        catch (Exception exception) {
            throw new InvalidCoverFormatException(exception);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Creating cover page...");
        FaxcoverHyla faxcoverHyla = new FaxcoverHyla(null);
        String[] stringArray2 = new String[]{"/home/jonas/mozilla.ps", "/home/jonas/nssg.pdf", "/var/spool/hylafax/recvq/fax000000002.tif", "/var/spool/hylafax/recvq/fax000000004.tif", "/var/spool/hylafax/recvq/fax000000005.tif"};
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                System.out.println(stringArray2[i] + " pages: " + faxcoverHyla.estimatePostscriptPages(new FileInputStream(stringArray2[i])));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        supportedCoverFormats.put(FileFormat.PostScript, FaxcoverHyla.class);
        supportedCoverFormats.put(FileFormat.HTML, HTMLFaxcover.class);
    }

    public static class InvalidCoverFormatException
    extends Exception {
        public InvalidCoverFormatException() {
        }

        public InvalidCoverFormatException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InvalidCoverFormatException(String string) {
            super(string);
        }

        public InvalidCoverFormatException(Throwable throwable) {
            super(throwable);
        }
    }
}

