/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.FaxOptions;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileCache;
import yajhfc.file.FileConverter;
import yajhfc.file.FileConverterToFile;
import yajhfc.file.FileConverters;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.UnknownFormatException;
import yajhfc.options.MultiFileMode;
import yajhfc.send.HylaTFLItem;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiFileConverter {
    private static final Logger log = Logger.getLogger(MultiFileConverter.class.getName());
    protected FileCache cache;

    protected FileCache getCache() {
        if (this.cache == null) {
            this.cache = new FileCache();
        }
        return this.cache;
    }

    public abstract FileFormat getTargetFormat();

    public abstract void convertMultiplePSorPDFFiles(File[] var1, File var2, PaperSize var3) throws IOException, FileConverter.ConversionException;

    public void convertMultipleFiles(List<FormattedFile> list, File file, PaperSize paperSize) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        if (list.size() == 1 && list.get(0).getFormat() == this.getTargetFormat()) {
            Utils.copyFile(list.get((int)0).file, file);
            return;
        }
        File file2 = this.getCache().checkCache(list, paperSize);
        if (file2 != null) {
            log.fine("Found valid cached file " + file2);
            Utils.copyFile(file2, file);
            return;
        }
        log.fine("Did not find cached file");
        File[] fileArray = new File[list.size()];
        block9: for (int i = 0; i < list.size(); ++i) {
            FormattedFile formattedFile = list.get(i);
            switch (formattedFile.getFormat()) {
                case PDF: 
                case PostScript: {
                    fileArray[i] = formattedFile.file;
                    continue block9;
                }
                default: {
                    Object object;
                    FileConverter fileConverter = FileConverters.getConverterFor(formattedFile.getFormat());
                    if (fileConverter == null || fileConverter == FileConverter.IDENTITY_CONVERTER) {
                        throw new UnknownFormatException("Unsupported file format: " + (Object)((Object)formattedFile.getFormat()));
                    }
                    File file3 = File.createTempFile("multi", ".ps");
                    ShutdownManager.deleteOnExit(file3);
                    FileFormat fileFormat = this.getTargetFormat();
                    switch (fileFormat) {
                        case PDF: 
                        case PostScript: {
                            break;
                        }
                        default: {
                            fileFormat = FileFormat.PDF;
                        }
                    }
                    if (fileConverter instanceof FileConverterToFile) {
                        ((FileConverterToFile)fileConverter).convertToHylaFormatFile(formattedFile.file, file3, paperSize, fileFormat);
                    } else {
                        object = new FileOutputStream(file3);
                        fileConverter.convertToHylaFormat(formattedFile.file, (OutputStream)object, paperSize, fileFormat);
                        ((FileOutputStream)object).close();
                    }
                    object = FormattedFile.detectFileFormat(file3);
                    switch (1.$SwitchMap$yajhfc$file$FileFormat[((Enum)object).ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            throw new FileConverter.ConversionException("Converter output for file " + formattedFile.file + " has an unsupported file format " + object + " (converter=" + fileConverter + ")");
                        }
                    }
                    fileArray[i] = file3;
                }
            }
        }
        if (fileArray.length == 1 && FormattedFile.detectFileFormat(fileArray[0]) == this.getTargetFormat()) {
            Utils.copyFile(fileArray[0], file);
        } else {
            this.convertMultiplePSorPDFFiles(fileArray, file, paperSize);
        }
        this.getCache().addToCache(list, file, paperSize);
    }

    public static void viewMultipleFiles(List<FormattedFile> list, PaperSize paperSize, boolean bl) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        boolean bl2;
        MultiFileConvFormat multiFileConvFormat;
        boolean bl3;
        FaxOptions faxOptions = Utils.getFaxOptions();
        if (bl) {
            bl3 = faxOptions.alwaysCreateTargetFormat;
            multiFileConvFormat = faxOptions.singleFileFormat;
            bl2 = faxOptions.multiFileSendMode != MultiFileMode.NONE;
        } else {
            bl3 = faxOptions.alwaysCreateTargetFormatForViewing;
            multiFileConvFormat = faxOptions.singleFileFormatForViewing;
            bl2 = faxOptions.createSingleFilesForViewing;
        }
        if (bl2) {
            if (!(list.size() != 1 || list.get(0).getFormat() != multiFileConvFormat.getFileFormat() && bl3)) {
                list.get(0).view();
            } else {
                File file = File.createTempFile("view", "." + multiFileConvFormat.getFileFormat().getDefaultExtension());
                ShutdownManager.deleteOnExit(file);
                FormattedFile formattedFile = MultiFileConverter.convertMultipleFilesToSingleFile(list, file, multiFileConvFormat, paperSize);
                formattedFile.view();
            }
        } else {
            for (FormattedFile formattedFile : list) {
                formattedFile.view();
            }
        }
    }

    public static FormattedFile convertMultipleFilesToSingleFile(List<FormattedFile> list, File file, MultiFileConvFormat multiFileConvFormat, PaperSize paperSize) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        MultiFileConverter multiFileConverter = multiFileConvFormat.getConverter();
        if (multiFileConverter == null) {
            throw new UnknownFormatException("Unsupported target format: " + (Object)((Object)multiFileConvFormat));
        }
        multiFileConverter.convertMultipleFiles(list, file, paperSize);
        return new FormattedFile(file, multiFileConverter.getTargetFormat());
    }

    public static FormattedFile convertTFLItemsToSingleFile(List<HylaTFLItem> list, File file, MultiFileConvFormat multiFileConvFormat, PaperSize paperSize) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>(list.size());
        for (HylaTFLItem hylaTFLItem : list) {
            arrayList.add(hylaTFLItem.getPreviewFilename());
        }
        return MultiFileConverter.convertMultipleFilesToSingleFile(arrayList, file, multiFileConvFormat, paperSize);
    }

    public static void main(String[] stringArray) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        List<FormattedFile> list = Arrays.asList(new FormattedFile(new File("/home/jonas/test.ps")), new FormattedFile(new File("/home/jonas/Karte.png")), new FormattedFile(new File("/home/jonas/timeline.pdf")));
        File file = new File("/tmp/out.pdf");
        MultiFileConverter.convertMultipleFilesToSingleFile(list, file, MultiFileConvFormat.PDF, PaperSize.A4);
        Runtime.getRuntime().exec(new String[]{"kpdf", file.getPath()});
        file = new File("/tmp/out.ps");
        MultiFileConverter.convertMultipleFilesToSingleFile(list, file, MultiFileConvFormat.PostScript, PaperSize.A4);
        Runtime.getRuntime().exec(new String[]{"gv", file.getPath()});
    }
}

