/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.util.ReplacerOutputStream;

public class PrintServiceFileConverter
implements PrintJobListener,
FileConverter {
    protected int completed;
    protected static final int NOT_COMPLETED = 0;
    protected static final int COMPLETED_SUCCESSFULLY = 1;
    protected static final int FAILED = 2;
    public DocFlavor flavor;
    private static final byte[] jdk16PSToReplace;
    private static final byte[] jdk16PSReplacement;

    public PrintServiceFileConverter(DocFlavor docFlavor) {
        this.flavor = docFlavor;
    }

    public void convertToHylaFormat(File file, OutputStream outputStream, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException {
        try {
            this.convertUsingPrintService(file.toURI().toURL(), outputStream, paperSize);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileConverter.ConversionException(malformedURLException);
        }
    }

    public boolean isOverridable() {
        return true;
    }

    protected void convertUsingPrintService(Object object, OutputStream outputStream, PaperSize paperSize) throws FileConverter.ConversionException {
        MediaSize mediaSize;
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray;
        if (Utils.getFaxOptions().useJDK16PSBugfix) {
            outputStream = new ReplacerOutputStream(outputStream, jdk16PSToReplace, jdk16PSReplacement);
        }
        if ((streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(this.flavor, DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType())).length < 1) {
            throw new FileConverter.ConversionException(MessageFormat.format(Utils._("Cannot find a PrintService to convert files of type {0} to Postscript!"), this.flavor.getMimeType()));
        }
        StreamPrintService streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(outputStream);
        DocPrintJob docPrintJob = streamPrintService.createPrintJob();
        docPrintJob.addPrintJobListener(this);
        this.completed = 0;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        switch (paperSize) {
            default: {
                mediaSize = MediaSize.ISO.A4;
                break;
            }
            case A5: {
                mediaSize = MediaSize.ISO.A5;
                break;
            }
            case LETTER: {
                mediaSize = MediaSize.NA.LETTER;
                break;
            }
            case LEGAL: {
                mediaSize = MediaSize.NA.LEGAL;
            }
        }
        hashPrintRequestAttributeSet.add(mediaSize.getMediaSizeName());
        try {
            docPrintJob.print(new SimpleDoc(object, this.flavor, null), hashPrintRequestAttributeSet);
        }
        catch (PrintException printException) {
            throw new FileConverter.ConversionException(printException);
        }
        while (this.completed == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.completed != 1) {
            throw new FileConverter.ConversionException(Utils._("An error occured while converting the document to PostScript."));
        }
    }

    public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
    }

    public void printJobCompleted(PrintJobEvent printJobEvent) {
        this.completed = 1;
    }

    public void printJobCanceled(PrintJobEvent printJobEvent) {
        this.completed = 2;
    }

    public void printJobFailed(PrintJobEvent printJobEvent) {
        this.completed = 2;
    }

    public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
        this.completed = 1;
    }

    public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
    }

    static {
        byte[] byArray;
        try {
            byArray = "/DeferredMediaSelection true".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            byArray = new byte[]{};
        }
        jdk16PSToReplace = byArray;
        jdk16PSReplacement = new byte[0];
    }
}

