/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file.textextract;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.StdErrThread;
import yajhfc.file.textextract.HylaToTextConverter;
import yajhfc.util.ArrayCharSequence;
import yajhfc.util.ExternalProcessExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalCommandToTextConverter
extends HylaToTextConverter {
    private static final int LINES_OF_ERROR_OUTPUT = 20;
    private static final Logger log = Logger.getLogger(ExternalCommandToTextConverter.class.getName());
    protected final String streamEncoding;
    protected final boolean acceptsMultipleFiles;
    protected FaxOptions options;

    public ExternalCommandToTextConverter(String string, boolean bl, FaxOptions faxOptions) {
        this.streamEncoding = string;
        this.acceptsMultipleFiles = bl;
        this.options = faxOptions;
    }

    protected abstract void buildCommandLine(List<String> var1, File[] var2);

    protected void modifyEnvironment(Map<String, String> map) {
    }

    @Override
    public CharSequence[] convertToText(File[] fileArray) throws FileConverter.ConversionException, IOException {
        if (this.acceptsMultipleFiles) {
            return new CharSequence[]{this.callCommandFor(fileArray)};
        }
        CharSequence[] charSequenceArray = new CharSequence[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            charSequenceArray[i] = this.callCommandFor(new File[]{fileArray[i]});
        }
        return charSequenceArray;
    }

    protected CharSequence callCommandFor(File[] fileArray) throws FileConverter.ConversionException, IOException {
        if (!this.acceptsMultipleFiles && fileArray.length != 1) {
            throw new UnsupportedOperationException("!acceptsMultipleFiles && input.length != 1");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.buildCommandLine(arrayList, fileArray);
        ExternalProcessExecutor.quoteCommandLine(arrayList);
        if (Utils.debugMode) {
            log.fine((String)arrayList.get(0) + " command line:");
            for (String object2 : arrayList) {
                log.fine(object2);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        this.modifyEnvironment(processBuilder.environment());
        Process process = processBuilder.start();
        StdErrThread stdErrThread = new StdErrThread((String)arrayList.get(0), process.getErrorStream(), 20);
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(), this.streamEncoding);
        ArrayCharSequence arrayCharSequence = ArrayCharSequence.readCompletely(inputStreamReader);
        inputStreamReader.close();
        process.getOutputStream().close();
        try {
            int interruptedException = process.waitFor();
            if (interruptedException != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Non-zero exit code of ").append((String)arrayList.get(0)).append(" (").append(interruptedException).append("):\n");
                for (String string : stdErrThread.getTail()) {
                    stringBuilder.append(string).append('\n');
                }
                throw new FileConverter.ConversionException(stringBuilder.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new FileConverter.ConversionException(interruptedException);
        }
        return arrayCharSequence;
    }
}

