/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import yajhfc.Utils;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.launch.Launcher2;
import yajhfc.launch.SendWinSubmitProtocol;

public class LockThread
extends Thread {
    private static final Logger log = Logger.getLogger(LockThread.class.getName());
    public final ServerSocket socket;
    private boolean isLocking = true;

    public LockThread(ServerSocket serverSocket) {
        this.socket = serverSocket;
    }

    private int waitSubmitOK() throws InterruptedException {
        while (true) {
            if (Launcher2.application != null) {
                switch (Launcher2.application.getSendReadyState()) {
                    case Ready: {
                        return 0;
                    }
                    case NotReady: {
                        return 10;
                    }
                }
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block33: while (this.isLocking) {
            Socket socket = null;
            FilterInputStream filterInputStream = null;
            FilterOutputStream filterOutputStream = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                socket = this.socket.accept();
                if (Utils.debugMode) {
                    log.info("Got connection from new instance...");
                }
                filterInputStream = new DataInputStream(socket.getInputStream());
                filterOutputStream = new DataOutputStream(socket.getOutputStream());
                SendWinSubmitProtocol sendWinSubmitProtocol = new SendWinSubmitProtocol();
                block34: do {
                    String string;
                    int n;
                    try {
                        n = 0;
                        string = "OK";
                        int n2 = filterInputStream.read();
                        switch (n2) {
                            case 5: {
                                log.fine("Got CODE_ADD_FILES");
                                arrayList.clear();
                                int n3 = ((DataInputStream)filterInputStream).readInt();
                                for (int i = 0; i < n3; ++i) {
                                    arrayList.add(((DataInputStream)filterInputStream).readUTF());
                                }
                                sendWinSubmitProtocol.addFiles(arrayList);
                                break;
                            }
                            case 7: {
                                log.fine("Got CODE_ADD_RECIPIENTS");
                                arrayList.clear();
                                int n3 = ((DataInputStream)filterInputStream).readInt();
                                for (int i = 0; i < n3; ++i) {
                                    arrayList.add(((DataInputStream)filterInputStream).readUTF());
                                }
                                sendWinSubmitProtocol.addRecipients(arrayList);
                                break;
                            }
                            case 6: {
                                log.fine("Got CODE_BRING_TO_FRONT");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        Launcher2.application.bringToFront();
                                    }
                                });
                                break;
                            }
                            case 10: {
                                log.fine("Got CODE_SET_COMMENT");
                                sendWinSubmitProtocol.setComments(((DataInputStream)filterInputStream).readUTF());
                                break;
                            }
                            case 9: {
                                log.fine("Got CODE_SET_SUBJECT");
                                sendWinSubmitProtocol.setSubject(((DataInputStream)filterInputStream).readUTF());
                                break;
                            }
                            case 8: {
                                log.fine("Got CODE_USE_COVER");
                                sendWinSubmitProtocol.setCover(((DataInputStream)filterInputStream).readBoolean());
                                break;
                            }
                            case 14: {
                                log.fine("Got CODE_EXTRACT_RECIPIENTS");
                                int n4 = ((DataInputStream)filterInputStream).readInt();
                                RecipientExtractionMode[] recipientExtractionModeArray = RecipientExtractionMode.values();
                                if (n4 >= 0 && n4 < recipientExtractionModeArray.length) {
                                    sendWinSubmitProtocol.setExtractRecipients(recipientExtractionModeArray[n4]);
                                    break;
                                }
                                log.warning("Invalid ordinal " + n4 + " received for CODE_EXTRACT_RECIPIENTS");
                                break;
                            }
                            case 11: {
                                log.fine("Got CODE_SET_MODEM");
                                sendWinSubmitProtocol.setModem(((DataInputStream)filterInputStream).readUTF());
                                break;
                            }
                            case 12: {
                                log.fine("Got CODE_SET_SERVER");
                                sendWinSubmitProtocol.setServer(((DataInputStream)filterInputStream).readUTF());
                                break;
                            }
                            case 13: {
                                log.fine("Got CODE_SET_IDENTITY");
                                sendWinSubmitProtocol.setIdentity(((DataInputStream)filterInputStream).readUTF());
                                break;
                            }
                            case 1: 
                            case 3: {
                                boolean bl = ((DataInputStream)filterInputStream).readBoolean();
                                if (n2 == 1) {
                                    log.fine("Got CODE_SUBMIT_STREAM");
                                    sendWinSubmitProtocol.setInputStream(filterInputStream, null);
                                } else {
                                    log.fine("Got CODE_SUBMIT");
                                }
                                n = this.waitSubmitOK();
                                if (n == 0) {
                                    long[] lArray = sendWinSubmitProtocol.submit(bl);
                                    ((DataOutputStream)filterOutputStream).write(n);
                                    ((DataOutputStream)filterOutputStream).writeUTF(string);
                                    if (lArray == null) {
                                        ((DataOutputStream)filterOutputStream).writeInt(0);
                                    } else {
                                        ((DataOutputStream)filterOutputStream).writeInt(lArray.length);
                                        for (long l : lArray) {
                                            ((DataOutputStream)filterOutputStream).writeLong(l);
                                        }
                                    }
                                    ((DataOutputStream)filterOutputStream).flush();
                                    continue block34;
                                }
                                break;
                            }
                            case -1: {
                                log.fine("Stream closed.");
                                continue block33;
                            }
                            default: {
                                log.fine("Got unkown opcode: " + n2);
                                n = 255;
                                string = "Unknown opcode " + n2;
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, "Got exception: ", exception);
                        n = 2;
                        string = exception.toString();
                    }
                    if (Utils.debugMode) {
                        log.fine("Write response " + n + "; msg: " + string);
                    }
                    ((DataOutputStream)filterOutputStream).write(n);
                    ((DataOutputStream)filterOutputStream).writeUTF(string);
                    ((DataOutputStream)filterOutputStream).flush();
                } while (!socket.isClosed());
            }
            catch (Exception exception) {
                log.log(Level.INFO, "Maybe error waiting for connection", exception);
            }
            finally {
                try {
                    filterInputStream.close();
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                }
                catch (Exception exception) {}
                socket = null;
                filterInputStream = null;
                filterOutputStream = null;
            }
        }
    }

    public void releaseLock() {
        this.isLocking = false;
    }
}

