/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.model.FmtItem;
import yajhfc.model.VirtualColumnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtItemList<T extends FmtItem>
extends ArrayList<T>
implements FilterKeyList<T> {
    private static final Logger log = Logger.getLogger(FmtItemList.class.getName());
    protected T[] availableItems;
    protected T[] obligateItems;
    protected List<T> completeView;
    protected Map<T, Integer> itemIndices;
    protected Map<VirtualColumnType, Integer> virtualColumnIndexes;
    protected boolean haveItemMap = false;
    private static final char sep = '|';

    public List<T> getCompleteView() {
        if (this.completeView == null) {
            this.itemIndices.clear();
            this.virtualColumnIndexes.clear();
            for (int i = 0; i < this.size(); ++i) {
                T[] TArray = (T[])this.get(i);
                Integer n = i;
                this.itemIndices.put(TArray, n);
                if (TArray.getVirtualColumnType() == VirtualColumnType.NONE) continue;
                this.virtualColumnIndexes.put(TArray.getVirtualColumnType(), n);
            }
            this.haveItemMap = true;
            ArrayList arrayList = new ArrayList<T>(this.size() + this.obligateItems.length){

                @Override
                public int indexOf(Object object) {
                    return FmtItemList.this.indexOfFromMap(object);
                }

                @Override
                public boolean contains(Object object) {
                    return FmtItemList.this.itemIndices.containsKey(object);
                }
            };
            arrayList.addAll(this);
            for (T t : this.obligateItems) {
                if (this.contains(t)) continue;
                arrayList.add(t);
                Integer n = arrayList.size() - 1;
                this.itemIndices.put(t, n);
                if (t.getVirtualColumnType() == VirtualColumnType.NONE) continue;
                this.virtualColumnIndexes.put(t.getVirtualColumnType(), n);
            }
            this.completeView = arrayList.size() > this.size() ? arrayList : this;
        }
        return this.completeView;
    }

    public String getFormatString(char c, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (FmtItem fmtItem : this.getCompleteView()) {
            if (fmtItem.getHylaFmt() != null) {
                stringBuilder.append('%').append(fmtItem.getHylaFmt());
            }
            stringBuilder.append(c);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public String saveToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FmtItem fmtItem : this) {
            stringBuilder.append(fmtItem.name()).append('|');
        }
        return stringBuilder.toString();
    }

    public void loadFromString(String string) {
        String[] stringArray = Utils.fastSplit(string, '|');
        this.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            FilterKey filterKey = this.getKeyForName(stringArray[i]);
            if (filterKey == null) {
                log.log(Level.WARNING, "FmtItem for " + stringArray[i] + "not found.");
                continue;
            }
            this.add((T)filterKey);
        }
    }

    @Override
    public T getKeyForName(String string) {
        Class<?> clazz = this.availableItems.getClass().getComponentType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return (T)((FmtItem)Enum.valueOf(clazz, string));
            }
            catch (Exception exception) {
                log.log(Level.INFO, "Enum constant not found: ", exception);
                return null;
            }
        }
        for (T t : this.availableItems) {
            if (!t.name().equals(string)) continue;
            return t;
        }
        return null;
    }

    @Override
    public boolean add(T t) {
        this.resetCompleteView();
        return super.add(t);
    }

    @Override
    public void add(int n, T t) {
        this.resetCompleteView();
        super.add(n, t);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.resetCompleteView();
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        this.resetCompleteView();
        return super.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.resetCompleteView();
        super.clear();
    }

    @Override
    public T remove(int n) {
        this.resetCompleteView();
        return (T)((FmtItem)super.remove(n));
    }

    @Override
    public boolean remove(Object object) {
        this.resetCompleteView();
        return super.remove(object);
    }

    @Override
    public T set(int n, T t) {
        this.resetCompleteView();
        return (T)((FmtItem)super.set(n, t));
    }

    protected void resetCompleteView() {
        this.completeView = null;
        this.itemIndices.clear();
        this.virtualColumnIndexes.clear();
        this.haveItemMap = false;
    }

    protected int indexOfFromMap(Object object) {
        Integer n;
        if (!this.haveItemMap) {
            this.getCompleteView();
        }
        if ((n = this.itemIndices.get(object)) == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        int n = this.indexOfFromMap(object);
        if (n >= this.size()) {
            return -1;
        }
        return n;
    }

    public int getVirtualColumnIndex(VirtualColumnType virtualColumnType) {
        Integer n;
        if (!this.haveItemMap) {
            this.getCompleteView();
        }
        if ((n = this.virtualColumnIndexes.get((Object)virtualColumnType)) == null) {
            return -1;
        }
        return n;
    }

    public Map<VirtualColumnType, Integer> getVirtualColumnIndexes() {
        return this.virtualColumnIndexes;
    }

    public FmtItemList(T[] TArray, T[] TArray2) {
        this.availableItems = TArray;
        this.obligateItems = TArray2;
        Class<T> clazz = this.getItemClass();
        this.itemIndices = Enum.class.isAssignableFrom(clazz) ? new EnumMap<T, Integer>(clazz) : new HashMap<T, Integer>();
        this.virtualColumnIndexes = new EnumMap<VirtualColumnType, Integer>(VirtualColumnType.class);
    }

    @Override
    public boolean containsKey(T t) {
        return this.getCompleteView().contains(t);
    }

    @Override
    public T[] getAvailableKeys() {
        return this.getCompleteView().toArray(this.newArray(this.getCompleteView().size()));
    }

    @Override
    public Object translateKey(T t) {
        return this.getCompleteView().indexOf(t);
    }

    private T[] newArray(int n) {
        return (FmtItem[])Array.newInstance(this.getItemClass(), n);
    }

    private Class<T> getItemClass() {
        return this.availableItems.getClass().getComponentType();
    }
}

