/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model;

import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.IconMap;
import yajhfc.model.VirtualColumnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JobFormat implements FmtItem
{
    A("A", Utils._("SubAddress"), Utils._("Destination SubAddress")),
    B("B", Utils._("Password"), Utils._("Destination Password")),
    C("C", Utils._("Company"), Utils._("Destination company name")),
    D("D", Utils._("Dials: total/max."), Utils._("Total # dials/maximum # dials")),
    E("E", Utils._("Speed"), Utils._("Desired signalling rate"), Integer.class),
    F("F", Utils._("Tagline format"), Utils._("Client-specific tagline format string")),
    G("G", Utils._("Desired min-scanline time"), Utils._("Desired minimum scanline time"), Integer.class),
    H("H", Utils._("Desired data format"), Integer.class),
    I("I", Utils._("Priority"), Utils._("Client-specified scheduling priority"), Integer.class),
    J("J", Utils._("Tag string"), Utils._("Client-specified job tag string")),
    K("K", Utils._("Use ECM?"), Utils._("Desired use of ECM (one-character symbol)")),
    L("L", Utils._("Location"), Utils._("Destination geographic location")),
    M("M", Utils._("Sender e-mail"), Utils._("Notification e-mail address")),
    N("N", Utils._("Private Tagline?"), Utils._("Desired use of private tagline (one-character symbol)"), Boolean.class),
    O("O", Utils._("Use continuation cover"), Utils._("Whether to use continuation cover page (one-character symbol)"), Boolean.class),
    P("P", Utils._("Pages done/total"), Utils._("# pages transmitted/total # pages to transmit")),
    Q("Q", Utils._("Minimal signalling rate"), Utils._("Client-specified minimum acceptable signalling rate"), Integer.class),
    R("R", Utils._("Receiver"), Utils._("Destination person (receiver)")),
    S("S", Utils._("Sender"), Utils._("Sender's identity")),
    T("T", Utils._("Tries: done/max."), Utils._("Total # tries/maximum # tries")),
    U("U", Utils._("Page chopping threshold (inches)"), Float.class),
    V("V", Utils._("Job done operation"), Utils._("Operation to perform when job is done")),
    W("W", Utils._("Communication identifier")),
    X("X", Utils._("Job type"), Utils._("Job type (one-character symbol)")),
    Y("Y", Utils._("Scheduled time"), Utils._("Scheduled date and time"), Utils.HYLA_LONG_DATE_FORMAT, DateKind.DATE_AND_TIME),
    Z("Z", Utils._("Scheduled time (UNIX)"), Utils._("Scheduled time in seconds since the UNIX epoch"), Utils.HYLA_UNIX_DATE_FORMAT, DateKind.DATE_AND_TIME),
    a("a", Utils._("Job state"), Utils._("Job state (one-character symbol)"), IconMap.class),
    b("b", Utils._("# consecutive failed tries"), Utils._("Number of consecutive failed attempts to place call"), Integer.class),
    c("c", Utils._("Client machine name")),
    d("d", Utils._("Total # dials"), Utils._("Total number of phone calls"), Integer.class),
    e("e", Utils._("Number"), Utils._("Public (external) format of dialstring")),
    f("f", Utils._("# consecutive failed dials"), Integer.class),
    g("g", Utils._("Group identifier"), Integer.class),
    h("h", Utils._("Page chop handling"), Utils._("Whitespace truncation handling")),
    i("i", Utils._("Scheduling priority"), Utils._("Current scheduling priority"), Integer.class),
    j("j", Utils._("ID"), Utils._("Job identifier"), Integer.class),
    k("k", Utils._("Job kill time"), Utils._("Time to give up trying to send job")),
    l("l", Utils._("Page length"), Utils._("Page length in mm"), Integer.class),
    m("m", Utils._("Modem"), Utils._("Assigned modem")),
    n("n", Utils._("Notification"), Utils._("E-mail notification handling (one-character symbol)"), IconMap.class),
    o("o", Utils._("Owner"), Utils._("Job owner")),
    p("p", Utils._("# pages"), Utils._("Number of pages transmitted"), Integer.class),
    q("q", Utils._("Retry time"), Utils._("Job retry time"), Utils.HYLA_TIME_ONLY_FORMAT, DateKind.DURATION),
    r("r", Utils._("Resolution"), Utils._("Document resolution in lines/inch"), Integer.class),
    s("s", Utils._("Status"), Utils._("Job status information from last failure")),
    t("t", Utils._("Tries"), Utils._("Total number of attempts to send job"), Integer.class),
    u("u", Utils._("Max. tries"), Utils._("Maximum number of attempts to send job"), Integer.class),
    v("v", Utils._("Specified number"), Utils._("Client-specified dialstring")),
    w("w", Utils._("Page width"), Utils._("Page width in mm"), Integer.class),
    x("x", Utils._("Maximum # dials"), Utils._("Maximum number of times to dial"), Integer.class),
    y("y", Utils._("Pages"), Utils._("Total # pages to transmit"), Integer.class),
    z("z", Utils._("Time to send job")),
    a_desc("a", Utils._("State"), Utils._("Job state (long description)"), IconMap.class),
    n_desc("n", Utils._("Notification when"), Utils._("E-mail notification handling (long description)"), IconMap.class),
    _0("0", Utils._("Use XVRES?"), Utils._("Use extended resolution?"), Boolean.class),
    virt_comment(null, Utils._("User comment"), Utils._("Comment added by a YajHFC user"), String.class, null, null, false, VirtualColumnType.USER_COMMENT),
    srfax_subject(null, Utils._("Subject"), Utils._("Subject (SRFax only)"));

    private final String description;
    private final String hylaFmt;
    private final String longDescription;
    private final Class<?> dataType;
    private final DateFormat hylaDateFormat;
    private final DateKind displayDateFormat;
    private final boolean readOnly;
    private final VirtualColumnType virtualColumnType;
    private static final JobFormat[] requiredFormats;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHylaFmt() {
        return this.hylaFmt;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    @Override
    public DateFormat getHylaDateFormat() {
        return this.hylaDateFormat;
    }

    @Override
    public DateFormat getDisplayDateFormat() {
        if (this.displayDateFormat == null) {
            return null;
        }
        return DateKind.getInstanceFromKind(this.displayDateFormat);
    }

    @Override
    public Format getFormat() {
        if (this.dataType == Date.class) {
            return this.getDisplayDateFormat();
        }
        return null;
    }

    @Override
    public VirtualColumnType getVirtualColumnType() {
        return this.virtualColumnType;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private JobFormat(String string2, String string3) {
        this(string2, string3, string3);
    }

    private JobFormat(String string2, String string3, String string4) {
        this(string2, string3, string4, String.class, null, null);
    }

    private JobFormat(String string2, String string3, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string3, Date.class, dateFormat, dateKind);
    }

    private JobFormat(String string2, String string3, String string4, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, Date.class, dateFormat, dateKind);
    }

    private JobFormat(String string2, String string3, String string4, Class<?> clazz) {
        this(string2, string3, string4, clazz, null, null);
    }

    private JobFormat(String string2, String string3, Class<?> clazz) {
        this(string2, string3, string3, clazz, null, null);
    }

    private JobFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, clazz, dateFormat, dateKind, true, VirtualColumnType.NONE);
    }

    private JobFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind, boolean bl, VirtualColumnType virtualColumnType) {
        this.hylaFmt = string2;
        this.description = string3;
        this.longDescription = string4;
        this.dataType = clazz;
        this.hylaDateFormat = dateFormat;
        this.displayDateFormat = dateKind;
        this.readOnly = bl;
        this.virtualColumnType = virtualColumnType;
    }

    public static JobFormat[] getRequiredFormats() {
        return requiredFormats;
    }

    static {
        requiredFormats = new JobFormat[]{j, o, a, W, virt_comment};
    }
}

