/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.jobq;

import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.IconMap;
import yajhfc.model.VirtualColumnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QueueFileFormat implements FmtItem
{
    chopthreshold("chopthreshold", Utils._("Page chopping threshold (inches)"), Float.class),
    commid("commid", Utils._("Communication identifier for last call"), String.class),
    company("company", Utils._("Company"), Utils._("Destination company name"), String.class),
    client("client", Utils._("Host that submitted the job"), String.class),
    cover("cover", Utils._("Continuation coverpage file"), String.class),
    dataformat("dataformat", Utils._("Data format used to transmit a facsimile"), String.class),
    desiredbr("desiredbr", Utils._("Desired transmit speed"), Integer.class),
    desireddf("desireddf", Utils._("Desired data format"), Integer.class),
    desiredec("desiredec", Utils._("ECM"), Utils._("Desired use of Error Correction Mode (ECM)"), Integer.class),
    desiredst("desiredst", Utils._("Desired min-scanline time"), Utils._("Desired minimum scanline time"), Integer.class),
    desiredtl("desiredtl", Utils._("Tagline"), Utils._("Whether or not to use tagline parameter"), Boolean.class),
    doneop("doneop", Utils._("Job done operation"), Utils._("Operation to perform when job is done"), String.class),
    external("external", Utils._("Number"), Utils._("Public (external) format of dialstring"), String.class),
    fax("fax", Utils._("Ready"), Utils._("Document ready for transmission"), String.class),
    groupid("groupid", Utils._("Group identifier"), Utils._("HylaFAX job group identifier"), Integer.class),
    jobid("jobid", Utils._("ID"), Utils._("HylaFAX job identifier"), Integer.class),
    jobtag("jobtag", Utils._("Tag string"), Utils._("Client-specified job tag string"), String.class),
    jobtype("jobtype", Utils._("Job type"), Utils._("Job type identification string"), String.class),
    killtime("killtime", Utils._("Job kill time"), Utils._("Time to give up trying to send job"), Utils.HYLA_UNIX_DATE_FORMAT_GMT, DateKind.DATE_AND_TIME),
    location("location", Utils._("Location"), Utils._("Destination geographic location"), String.class),
    mailaddr("mailaddr", Utils._("Sender e-mail"), Utils._("Email address of sender"), String.class),
    maxdials("maxdials", Utils._("Maximum # dials"), Utils._("Maximum number of times to dial"), Integer.class),
    maxtries("maxtries", Utils._("Max. tries"), Utils._("Maximum number of attempts to send job"), Integer.class),
    minbr("minbr", Utils._("Minimum speed"), Utils._("Minimum required transmit speed"), Integer.class),
    modem("modem", Utils._("Modem"), Utils._("Outgoing modem to use"), String.class),
    ndials("ndials", Utils._("# consecutive failed tries"), Utils._("Number of consecutive failed attempts to place call"), Integer.class),
    notify("notify", Utils._("Notification"), Utils._("Email notification specification"), IconMap.class),
    npages("npages", Utils._("# pages"), Utils._("Number of pages transmitted"), Integer.class),
    ntries("ntries", Utils._("Tries (current page)"), Utils._("Number of attempts to send current page"), Integer.class),
    number("number", Utils._("Specified number"), Utils._("Client-specified dialstring"), String.class),
    owner("owner", Utils._("Owner"), Utils._("Job owner"), String.class),
    page("page", Utils._("Page PIN"), Utils._("PIN in a page operation"), String.class),
    pagechop("pagechop", Utils._("Page chop handling"), Utils._("Whitespace truncation handling"), Integer.class),
    pagehandling("pagehandling", Utils._("Page handling"), Utils._("Page analysis information"), String.class),
    pagelength("pagelength", Utils._("Page length"), Utils._("Page length in mm"), Integer.class),
    pagewidth("pagewidth", Utils._("Page width"), Utils._("Page width in mm"), Integer.class),
    passwd("passwd", Utils._("Password"), Utils._("Destination Password"), String.class),
    poll("poll", Utils._("Polling request"), String.class),
    priority("priority", Utils._("Priority"), Utils._("Client-specified scheduling priority"), Integer.class),
    receiver("receiver", Utils._("Receiver"), Utils._("Destination person (receiver)"), String.class),
    resolution("resolution", Utils._("Resolution"), Utils._("Document resolution in lines/inch"), Integer.class),
    retrytime("retrytime", Utils._("Retry time"), Utils._("Time to use between job retries"), Integer.class),
    returned("returned", Utils._("Returned status"), Utils._("Indicates status return value for the job"), Integer.class),
    schedpri("schedpri", Utils._("Scheduling priority"), Utils._("Current scheduling priority"), Integer.class),
    sender("sender", Utils._("Sender"), Utils._("Sender's identity"), String.class),
    signalrate("signalrate", Utils._("Speed"), Utils._("Signalling rate at which a facsimile was sent"), String.class),
    state("state", Utils._("Job state"), IconMap.class),
    status("status", Utils._("Status"), Utils._("Job status information from last failure"), String.class),
    subaddr("subaddr", Utils._("SubAddress"), Utils._("Destination SubAddress"), String.class),
    tagline("tagline", Utils._("Tagline format"), Utils._("Client-specific tagline format string"), String.class),
    totdials("totdials", Utils._("Total # dials"), Utils._("Total number of phone calls"), Integer.class),
    totpages("totpages", Utils._("Pages"), Utils._("Total # pages to transmit"), Integer.class),
    tottries("tottries", Utils._("Tries"), Utils._("Total number of attempts to send job"), Integer.class),
    tts("tts", Utils._("Time to send job"), Utils.HYLA_UNIX_DATE_FORMAT_GMT, DateKind.DATE_AND_TIME),
    useccover("useccover", Utils._("Use continuation cover"), Utils._("Whether or not to use a continuation cover page"), Boolean.class),
    usexvres("usexvres", Utils._("Use max. vertical resolution"), Utils._("Whether or not to use highest vertical resolution"), Boolean.class),
    state_desc("state", Utils._("State"), Utils._("Job state (long description)"), IconMap.class),
    notify_desc("notify", Utils._("Notification when"), Utils._("E-mail notification handling (long description)"), IconMap.class),
    voice("voice", Utils._("Recipient phone"), Utils._("Recipient's telephone (voice) number"), String.class),
    regarding("regarding", Utils._("Subject"), Utils._("Subject (\"Regarding\") of the fax"), String.class),
    virt_comment(null, Utils._("User comment"), Utils._("Comment added by a YajHFC user"), String.class, null, null, false, VirtualColumnType.USER_COMMENT);

    private final String description;
    private final String hylaFmt;
    private final String longDescription;
    private final Class<?> dataType;
    private final DateFormat hylaDateFormat;
    private final DateKind displayDateFormat;
    private final boolean readOnly;
    private final VirtualColumnType virtualColumnType;
    private static final QueueFileFormat[] requiredFormats;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHylaFmt() {
        return this.hylaFmt;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    @Override
    public DateFormat getHylaDateFormat() {
        return this.hylaDateFormat;
    }

    @Override
    public DateFormat getDisplayDateFormat() {
        return DateKind.getInstanceFromKind(this.displayDateFormat);
    }

    @Override
    public Format getFormat() {
        if (this.dataType == Date.class) {
            return this.getDisplayDateFormat();
        }
        return null;
    }

    @Override
    public VirtualColumnType getVirtualColumnType() {
        return this.virtualColumnType;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private QueueFileFormat(String string2, String string3, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string3, Date.class, dateFormat, dateKind);
    }

    private QueueFileFormat(String string2, String string3, String string4, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, Date.class, dateFormat, dateKind);
    }

    private QueueFileFormat(String string2, String string3, String string4, Class<?> clazz) {
        this(string2, string3, string4, clazz, null, null);
    }

    private QueueFileFormat(String string2, String string3, Class<?> clazz) {
        this(string2, string3, string3, clazz, null, null);
    }

    private QueueFileFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, clazz, dateFormat, dateKind, true, VirtualColumnType.NONE);
    }

    private QueueFileFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind, boolean bl, VirtualColumnType virtualColumnType) {
        this.hylaFmt = string2;
        this.description = string3;
        this.longDescription = string4;
        this.dataType = clazz;
        this.hylaDateFormat = dateFormat;
        this.displayDateFormat = dateKind;
        this.readOnly = bl;
        this.virtualColumnType = virtualColumnType;
    }

    public static QueueFileFormat[] getRequiredFormats() {
        return requiredFormats;
    }

    static {
        requiredFormats = new QueueFileFormat[]{owner, state, commid};
    }
}

