/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn;

import java.awt.Window;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.directaccess.DirectAccessFaxListConnection;
import yajhfc.model.servconn.directaccess.fritz.FritzFaxListConnection;
import yajhfc.model.servconn.hylafax.HylaFaxListConnection;
import yajhfc.model.servconn.srfax.SRFaxListConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FaxListConnectionType {
    HYLAFAX(Utils._("Using the HylaFAX protocol"), HylaFaxListConnection.class),
    DIRECTACCESS(Utils._("Directly accessing the spool area (experimental)"), DirectAccessFaxListConnection.class),
    FRITZBOX(Utils._("Fritz!Box for received, HylaFAX for outgoing faxes"), FritzFaxListConnection.class),
    SRFAX(Utils._("Using SRFax Protocol"), SRFaxListConnection.class);

    private final Class<? extends FaxListConnection> implementingClass;
    private final String description;
    private Method showConfigDialog;

    private FaxListConnectionType(String string2, Class<? extends FaxListConnection> clazz) {
        this.description = string2;
        this.implementingClass = clazz;
        try {
            this.showConfigDialog = clazz.getMethod("showConfigDialog", Window.class, String.class);
        }
        catch (Exception exception) {
            this.showConfigDialog = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends FaxListConnection> getImplementingClass() {
        return this.implementingClass;
    }

    public boolean canConfigure() {
        return this.showConfigDialog != null;
    }

    public String showConfigDialog(Window window, String string) {
        try {
            return (String)this.showConfigDialog.invoke(null, window, string);
        }
        catch (Exception exception) {
            Logger.getLogger(FaxListConnectionType.class.getName()).log(Level.SEVERE, "Could not successfully show config dialog", exception);
            return null;
        }
    }

    public String toString() {
        return this.description;
    }
}

