/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.defimpl;

import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.DefaultIconMap;
import yajhfc.model.FmtItem;
import yajhfc.model.IconMap;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.model.servconn.HylafaxWorker;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.defimpl.AbstractFaxJobList;
import yajhfc.model.servconn.defimpl.SerializableFaxJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxJob<T extends FmtItem>
implements SerializableFaxJob<T> {
    static final Logger log = Logger.getLogger(AbstractFaxJob.class.getName());
    private static final long serialVersionUID = 1L;
    protected transient AbstractFaxJobList<T> parent;
    protected Object[] data;
    protected String[] rawData;
    protected List<FaxDocument> documents;
    protected List<String> inaccessibleDocuments = null;
    protected JobState state;

    @Override
    public FaxDocument getCommunicationsLog() throws IOException {
        return null;
    }

    @Override
    public Object getData(T t) {
        return this.getData(this.parent.getColumns().getCompleteView().indexOf(t));
    }

    @Override
    public Object getFilterData(Object object) {
        return this.getData((Integer)object);
    }

    @Override
    public Object getData(int n) {
        return this.data[n];
    }

    @Override
    public void setData(T t, Object object) {
        this.setData(t, object, true);
    }

    @Override
    public void setData(T t, Object object, boolean bl) {
        this.setData(this.parent.getColumns().getCompleteView().indexOf(t), object, bl);
    }

    @Override
    public void setData(int n, Object object) {
        this.setData(n, object, true);
    }

    @Override
    public void setData(int n, Object object, boolean bl) {
        FmtItem fmtItem = (FmtItem)this.parent.getColumns().getCompleteView().get(n);
        if (fmtItem.isReadOnly()) {
            throw new UnsupportedOperationException("Column " + fmtItem.name() + " is read only!");
        }
        if (object != null && !fmtItem.getDataType().isInstance(object)) {
            throw new ClassCastException("value is of type " + object.getClass() + ", but column " + fmtItem.name() + " has type " + fmtItem.getDataType());
        }
        Object object2 = this.data[n];
        if (!(object2 == object || object2 != null && object2.equals(object))) {
            this.data[n] = object;
            if (bl) {
                this.parent.fireColumnChanged(this, fmtItem, n, object2, object);
            }
        }
    }

    public String getRawData(T t) {
        return this.getRawData(this.parent.getColumns().getCompleteView().indexOf(t));
    }

    public String getRawData(int n) {
        if (this.rawData == null || n < 0 || n >= this.rawData.length) {
            return null;
        }
        return this.rawData[n];
    }

    @Override
    public Map<String, String> getJobProperties(String ... stringArray) {
        return null;
    }

    @Override
    public Object doHylafaxWork(HylafaxWorker hylafaxWorker) throws IOException, ServerResponseException {
        throw new UnsupportedOperationException("Not a HylaFAX job");
    }

    @Override
    public Collection<FaxDocument> getDocuments() throws IOException, ServerResponseException {
        return this.getDocuments(null);
    }

    @Override
    public Collection<FaxDocument> getDocuments(Collection<String> collection) throws IOException, ServerResponseException {
        if (this.documents == null) {
            this.documents = this.calcDocuments();
            if (Utils.debugMode) {
                log.fine("Calculated documents for " + this.getIDValue() + ": " + this.documents + "; inaccessibleDocs=" + this.inaccessibleDocuments);
            }
        }
        if (collection != null && this.inaccessibleDocuments != null) {
            collection.addAll(this.inaccessibleDocuments);
        }
        return this.documents;
    }

    protected abstract List<FaxDocument> calcDocuments();

    @Override
    public abstract Object getIDValue();

    @Override
    public FaxJobList<T> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FaxJobList<T> faxJobList) {
        this.parent = (AbstractFaxJobList)faxJobList;
    }

    @Override
    public boolean isError() {
        switch (this.getJobState()) {
            case FAILED: 
            case UNDEFINED: {
                return true;
            }
        }
        return false;
    }

    private static int parseInt(String string) {
        long l = Long.parseLong(string);
        if (l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return -((int)(l ^ 0xFFFFFFFFL) + 1);
    }

    protected Object parseValue(T t, String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = t.getDataType();
        if (clazz == String.class) {
            return string;
        }
        string = string.trim();
        if (clazz == Boolean.class) {
            return string.length() == 1 && !string.equals("N");
        }
        if (clazz == IconMap.class) {
            return DefaultIconMap.getInstance(t, string);
        }
        if (string.length() > 0) {
            try {
                if (clazz == Integer.class) {
                    return AbstractFaxJob.parseInt(string);
                }
                if (clazz == Float.class) {
                    return Float.valueOf(string);
                }
                if (clazz == Double.class) {
                    return Double.valueOf(string);
                }
                if (clazz == Date.class) {
                    Date date = t.getHylaDateFormat().parse(string);
                    if (date != null && this.parent.getParent().getOptions().dateOffsetSecs != 0) {
                        Calendar calendar = Calendar.getInstance(Utils.getLocale());
                        calendar.setTime(date);
                        calendar.add(13, this.parent.getParent().getOptions().dateOffsetSecs);
                        date = calendar.getTime();
                    }
                    return date;
                }
                if (clazz == Long.class) {
                    return Long.parseLong(string);
                }
                log.info("Unsupported data class: " + clazz);
                return string;
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.WARNING, "Not a number: " + string + ": ", numberFormatException);
                return null;
            }
            catch (ParseException parseException) {
                log.log(Level.WARNING, "Not a parseable date for column '" + t + "': " + string + ": ", parseException);
                return null;
            }
        }
        return null;
    }

    protected void reloadData(String[] stringArray) {
        if (Utils.debugMode) {
            log.finest("Raw data is: " + Arrays.toString(stringArray));
        }
        this.rawData = stringArray;
        List<T> list = this.parent.getColumns().getCompleteView();
        this.data = new Object[list.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = i < stringArray.length ? this.parseValue((FmtItem)list.get(i), stringArray[i]) : null;
        }
        if (Utils.debugMode) {
            log.finest("Parsed data is: " + Arrays.toString(this.data));
        }
        this.state = this.calculateJobState();
    }

    protected abstract JobState calculateJobState();

    @Override
    public JobState getJobState() {
        return this.state;
    }

    @Override
    public JobState getCurrentJobState() {
        return this.getJobState();
    }

    @Override
    public boolean isRead() {
        int n = this.parent.getColumns().getVirtualColumnIndex(VirtualColumnType.READ);
        if (n < 0) {
            throw new UnsupportedOperationException("This type of fax job doe not support a read/unread state!");
        }
        Boolean bl = (Boolean)this.getData(n);
        return bl != null && bl != false;
    }

    @Override
    public void setRead(boolean bl) {
        this.setRead(bl, true);
    }

    @Override
    public void setRead(boolean bl, boolean bl2) {
        int n = this.parent.getColumns().getVirtualColumnIndex(VirtualColumnType.READ);
        if (n < 0) {
            log.fine("This type of fax job does not support a read/unread state!");
            return;
        }
        this.setData(n, (Object)bl, bl2);
    }

    protected AbstractFaxJob(AbstractFaxJobList<T> abstractFaxJobList) {
        this.parent = abstractFaxJobList;
    }

    protected AbstractFaxJob(AbstractFaxJobList<T> abstractFaxJobList, String[] stringArray) {
        this.parent = abstractFaxJobList;
        this.reloadData(stringArray);
    }

    public String toString() {
        Object object = this.getIDValue();
        return object == null ? "null" : object.toString();
    }
}

