/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.defimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.model.servconn.FaxJobListListener;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.defimpl.SerializableFaxJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxJobList<T extends FmtItem>
implements FaxJobList<T> {
    static final Logger log = Logger.getLogger(AbstractFaxJobList.class.getName());
    protected final FmtItemList<T> columns;
    protected final List<FaxJobListListener<T>> listeners = new ArrayList<FaxJobListListener<T>>();
    protected List<FaxJob<T>> jobs = Collections.emptyList();
    protected final FaxListConnection parent;

    @Override
    public FmtItemList<T> getColumns() {
        return this.columns;
    }

    @Override
    public synchronized List<FaxJob<T>> getJobs() {
        return this.jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setJobs(List<FaxJob<T>> list) {
        List<FaxJob<T>> list2;
        AbstractFaxJobList abstractFaxJobList = this;
        synchronized (abstractFaxJobList) {
            list2 = this.jobs;
            this.jobs = list;
        }
        this.fireFaxJobsUpdated(list, list2);
    }

    public synchronized void fireFaxJobsUpdated(List<FaxJob<T>> list, List<FaxJob<T>> list2) {
        if (Utils.debugMode) {
            log.finest("Fire faxJobsUpdated; newJobs=" + list + "; oldJobs=" + list2);
        }
        for (FaxJobListListener<T> faxJobListListener : this.listeners) {
            faxJobListListener.faxJobsUpdated(this, list2, list);
        }
    }

    @Override
    public synchronized void addFaxJobListListener(FaxJobListListener<T> faxJobListListener) {
        this.listeners.add(faxJobListListener);
    }

    @Override
    public synchronized void removeFaxJobListListener(FaxJobListListener<T> faxJobListListener) {
        this.listeners.remove(faxJobListListener);
    }

    public synchronized void fireColumnChanged(FaxJob<T> faxJob, T t, int n, Object object, Object object2) {
        if (Utils.debugMode) {
            log.fine("Fire column changed for " + faxJob + "; column=" + t.name() + " (idx=" + n + "); oldValue=" + object + "; newValue=" + object2);
        }
        for (FaxJobListListener<T> faxJobListListener : this.listeners) {
            faxJobListListener.columnChanged(this, faxJob, t, n, object, object2);
            if (t.getVirtualColumnType() != VirtualColumnType.READ) continue;
            faxJobListListener.readStateChanged(this, faxJob, object != null && (Boolean)object != false, object2 != null && (Boolean)object2 != false);
        }
    }

    @Override
    public boolean isShowingErrorsSupported() {
        return false;
    }

    public void loadJobsFromCache(Map<String, Object> map, String string) {
        List list = (List)map.get(string);
        if (list != null) {
            log.fine("Loading jobs from cache with prefix " + string);
            for (FaxJob faxJob : list) {
                ((SerializableFaxJob)faxJob).setParent(this);
            }
            this.setJobs(list);
        }
    }

    public void saveJobsToCache(Map<String, Object> map, String string) {
        map.put(string, this.jobs);
    }

    @Override
    public FaxListConnection getParent() {
        return this.parent;
    }

    protected AbstractFaxJobList(FmtItemList<T> fmtItemList, FaxListConnection faxListConnection) {
        this.columns = fmtItemList;
        this.parent = faxListConnection;
    }
}

