/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess;

import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.defimpl.AbstractFaxJob;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJobList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectAccessFaxJob<T extends FmtItem>
extends AbstractFaxJob<T> {
    static final Logger log = Logger.getLogger(DirectAccessFaxJob.class.getName());
    protected final String jobID;
    protected final String fileName;
    protected long lastModified = -1L;

    protected DirectAccessFaxJob(DirectAccessFaxJobList<T> directAccessFaxJobList, String string, String string2) throws IOException {
        super(directAccessFaxJobList);
        this.jobID = string;
        this.fileName = string2;
        this.documents = new ArrayList();
        this.readSpoolFile(this.getDirAccessor());
    }

    public HylaDirAccessor getDirAccessor() {
        return ((DirectAccessFaxJobList)this.parent).getDirAccessor();
    }

    @Override
    public void resume() throws IOException, ServerResponseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() throws IOException, ServerResponseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getIDValue() {
        return this.jobID;
    }

    public boolean pollForChanges() throws IOException {
        HylaDirAccessor hylaDirAccessor = this.getDirAccessor();
        long l = hylaDirAccessor.getLastModified(this.fileName);
        if (Utils.debugMode) {
            log.fine(this.fileName + ": poll for changes: lastModified=" + this.lastModified + "; newModified=" + l);
        }
        if (l != this.lastModified) {
            this.readSpoolFile(hylaDirAccessor);
            this.lastModified = l;
            return true;
        }
        return false;
    }

    protected abstract void readSpoolFile(HylaDirAccessor var1) throws IOException;

    @Override
    protected List<FaxDocument> calcDocuments() {
        return null;
    }
}

