/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.fritz;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import yajhfc.Utils;
import yajhfc.model.servconn.directaccess.fritz.FritzFaxConfig;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ComponentEnabler;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.IntVerifier;

public class FritzConfigDialog
extends JDialog {
    JTextField textHostname;
    JTextField textPort;
    JTextField textUser;
    JPasswordField textPassword;
    JCheckBox checkAlwaysAsk;
    JCheckBox checkPassive;
    JTextField textFaxboxDir;
    JTextField textFaxPattern;
    JTextField textFaxDateFormat;
    CancelAction cancelAction;
    Action okAction;
    boolean okClicked = false;

    public FritzConfigDialog(Window window) {
        super(window, Utils._("Fritz!Box configuration"), Dialog.DEFAULT_MODALITY_TYPE);
        this.initialize();
    }

    private void initialize() {
        this.textHostname = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textHostname);
        this.textPort = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textPort);
        this.textPort.setInputVerifier(new IntVerifier(1, 65536));
        this.textUser = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textUser);
        this.textPassword = new JPasswordField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textPassword);
        this.textFaxboxDir = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textFaxboxDir);
        this.textFaxPattern = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textFaxPattern);
        this.textFaxDateFormat = new JTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textFaxDateFormat);
        this.checkAlwaysAsk = new JCheckBox(Utils._("Always ask"));
        this.checkPassive = new JCheckBox(Utils._("Use passive mode"));
        this.cancelAction = new CancelAction(this);
        this.okAction = new ExcDialogAbstractAction(Utils._("OK")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (FritzConfigDialog.this.validateSettings()) {
                    FritzConfigDialog.this.okClicked = true;
                    FritzConfigDialog.this.setVisible(false);
                }
            }
        };
        double[][] dArrayArray = new double[][]{{5.0, 0.5, 5.0, 0.25, 5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, -2.0, -1.0, 5.0, -2.0, 5.0, -2.0, 5.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        Utils.addWithLabel(jPanel, (Component)this.textHostname, Utils._("Host name:"), "1,2,3,2,f,c");
        Utils.addWithLabel(jPanel, (Component)this.textPort, Utils._("Port:"), "5,2,5,2,f,c");
        jPanel.add((Component)this.checkPassive, "7,2,7,2,l,c");
        Utils.addWithLabel(jPanel, (Component)this.textUser, Utils._("Username:"), "1,5,1,5,f,c");
        JLabel jLabel = Utils.addWithLabel(jPanel, (Component)this.textPassword, Utils._("Password:"), "3,5,5,5,f,c");
        jPanel.add((Component)this.checkAlwaysAsk, "7,5,7,5,l,c");
        Utils.addWithLabel(jPanel, (Component)this.textFaxboxDir, Utils._("Path to \"faxbox\" directory:"), "1,8,7,8,f,c");
        Utils.addWithLabel(jPanel, (Component)this.textFaxPattern, Utils._("File name pattern:"), "1,11,3,11,f,c");
        Utils.addWithLabel(jPanel, (Component)this.textFaxDateFormat, Utils._("Date format in file name:"), "5,11,7,11,f,c");
        jPanel.add((Component)new JSeparator(), "0,14,8,14,f,c");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5), false);
        jPanel2.add(new JButton(this.okAction));
        jPanel2.add(this.cancelAction.createCancelButton());
        jPanel.add((Component)jPanel2, "0,16,8,16,f,f");
        ComponentEnabler.installOn(this.checkAlwaysAsk, false, this.textPassword, jLabel);
        this.setContentPane(jPanel);
        this.setLocationRelativeTo(this.getOwner());
        this.pack();
    }

    public void loadSettings(FritzFaxConfig fritzFaxConfig) {
        this.textHostname.setText(fritzFaxConfig.hostname);
        this.textPort.setText(String.valueOf(fritzFaxConfig.port));
        this.textUser.setText(fritzFaxConfig.user);
        this.textPassword.setText(fritzFaxConfig.pass.getPassword());
        this.textFaxboxDir.setText(fritzFaxConfig.faxboxDir);
        this.textFaxPattern.setText(fritzFaxConfig.faxPattern);
        this.textFaxDateFormat.setText(fritzFaxConfig.faxDateFormat);
        this.checkAlwaysAsk.setSelected(fritzFaxConfig.alwaysAsk);
        this.checkPassive.setSelected(fritzFaxConfig.passive);
    }

    public void saveSettings(FritzFaxConfig fritzFaxConfig) {
        fritzFaxConfig.hostname = this.textHostname.getText();
        fritzFaxConfig.port = Integer.parseInt(this.textPort.getText());
        fritzFaxConfig.user = this.textUser.getText();
        fritzFaxConfig.pass.setPassword(new String(this.textPassword.getPassword()));
        fritzFaxConfig.faxboxDir = this.textFaxboxDir.getText();
        fritzFaxConfig.faxPattern = this.textFaxPattern.getText();
        fritzFaxConfig.faxDateFormat = this.textFaxDateFormat.getText();
        fritzFaxConfig.alwaysAsk = this.checkAlwaysAsk.isSelected();
        fritzFaxConfig.passive = this.checkPassive.isSelected();
    }

    public boolean validateSettings() {
        if (this.textHostname.getText().length() == 0) {
            this.textHostname.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a host name."), Utils._("Error"), 0);
            return false;
        }
        if (this.textUser.getText().length() == 0) {
            this.textUser.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a user name."), Utils._("Error"), 0);
            return false;
        }
        String string = this.textPort.getText();
        boolean bl = true;
        if (string.length() == 0) {
            bl = false;
        } else {
            try {
                int n = Integer.parseInt(string);
                bl = n > 0 && n < 65536;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (!bl) {
            this.textPort.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a valid port number."), Utils._("Error"), 0);
            return false;
        }
        return true;
    }

    public static boolean showConfigDialog(Window window, FritzFaxConfig fritzFaxConfig) {
        FritzConfigDialog fritzConfigDialog = new FritzConfigDialog(window);
        fritzConfigDialog.loadSettings(fritzFaxConfig);
        fritzConfigDialog.setVisible(true);
        if (fritzConfigDialog.okClicked) {
            fritzConfigDialog.saveSettings(fritzFaxConfig);
            fritzConfigDialog.dispose();
            return true;
        }
        return false;
    }
}

