/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.recvq;

import gnu.inet.ftp.ServerResponseException;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.directaccess.DirectAccessFaxDoc;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.recvq.RecvQFaxJobList;
import yajhfc.tiff.RecvTIFFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecvQFaxJob
extends DirectAccessFaxJob<RecvFormat> {
    private static final long serialVersionUID = 1L;
    static final Logger log = Logger.getLogger(RecvQFaxJob.class.getName());

    protected RecvQFaxJob(RecvQFaxJobList recvQFaxJobList, String string, String string2) throws IOException {
        super(recvQFaxJobList, string, string2);
        this.documents.clear();
        this.documents.add(new DirectAccessFaxDoc<RecvFormat>(this, string2, FileFormat.TIFF));
    }

    @Override
    protected void readSpoolFile(HylaDirAccessor hylaDirAccessor) throws IOException {
        String string;
        RecvTIFFReader recvTIFFReader = new RecvTIFFReader();
        FileInputStream fileInputStream = new FileInputStream(hylaDirAccessor.getFile(this.fileName));
        recvTIFFReader.read(fileInputStream);
        fileInputStream.close();
        List list = this.parent.getColumns().getCompleteView();
        Object[] objectArray = new Object[list.size()];
        block21: for (int i = 0; i < list.size(); ++i) {
            switch ((RecvFormat)list.get(i)) {
                case a: {
                    objectArray[i] = recvTIFFReader.getSubAddress();
                    continue block21;
                }
                case b: {
                    objectArray[i] = recvTIFFReader.getBitRate();
                    continue block21;
                }
                case d: {
                    objectArray[i] = recvTIFFReader.getDataFormatName();
                    continue block21;
                }
                case e: {
                    objectArray[i] = recvTIFFReader.getReason();
                    continue block21;
                }
                case f: {
                    objectArray[i] = this.jobID;
                    continue block21;
                }
                case h: {
                    objectArray[i] = new Date(1000L * (long)recvTIFFReader.getRecvTime());
                    continue block21;
                }
                case i: {
                    objectArray[i] = recvTIFFReader.getCallIDName();
                    continue block21;
                }
                case j: {
                    objectArray[i] = recvTIFFReader.getCallIDNumber();
                    continue block21;
                }
                case l: {
                    objectArray[i] = recvTIFFReader.getPageLength();
                    continue block21;
                }
                case m: {
                    objectArray[i] = RecvQFaxJob.getProtection(hylaDirAccessor.getProtection(this.fileName));
                    continue block21;
                }
                case n: {
                    objectArray[i] = (int)hylaDirAccessor.getSize(this.fileName);
                    continue block21;
                }
                case o: {
                    objectArray[i] = "<unknown>";
                    continue block21;
                }
                case p: {
                    objectArray[i] = recvTIFFReader.getNumberOfPages();
                    continue block21;
                }
                case r: {
                    objectArray[i] = recvTIFFReader.getVerticalRes();
                    continue block21;
                }
                case s: {
                    objectArray[i] = recvTIFFReader.getSender();
                    continue block21;
                }
                case t: {
                    objectArray[i] = DateFormat.getDateTimeInstance().format(recvTIFFReader.getDate());
                    continue block21;
                }
                case w: {
                    objectArray[i] = recvTIFFReader.getPageWidth();
                    continue block21;
                }
                case z: {
                    objectArray[i] = recvTIFFReader.isInProgress();
                    continue block21;
                }
                case Y: 
                case Z: {
                    objectArray[i] = recvTIFFReader.getDate();
                }
            }
        }
        this.data = objectArray;
        if (Utils.debugMode) {
            log.finest(this.jobID + " data after reading: " + Arrays.toString(objectArray));
        }
        this.state = (string = recvTIFFReader.getReason()) != null && string.length() > 0 ? JobState.FAILED : (recvTIFFReader.isInProgress() ? JobState.RUNNING : JobState.DONE);
    }

    public static String getProtection(int n) {
        char[] cArray = new char[]{'-', (n & 0x20) != 0 ? (char)'r' : '-', (n & 0x10) != 0 ? (char)'w' : '-', (n & 8) != 0 ? (char)'x' : '-', (n & 4) != 0 ? (char)'r' : '-', (n & 2) != 0 ? (char)'w' : '-', (n & 1) != 0 ? (char)'x' : '-'};
        return new String(cArray);
    }

    @Override
    protected JobState calculateJobState() {
        return JobState.DONE;
    }

    @Override
    public void delete() throws IOException, ServerResponseException {
        this.getDirAccessor().deleteFile(this.fileName);
    }
}

